/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.javac.decorations.element;

import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.ElementDecoration;
import com.webcohesion.enunciate.javac.decorations.ElementDecorator;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.javadoc.DefaultJavaDocTagHandler;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class DecoratedElement<E extends Element>
implements Element {
    protected final E delegate;
    protected final DecoratedProcessingEnvironment env;
    private final HashMap<JavaDocTagHandler, JavaDoc> javaDocs = new HashMap();
    private TypeMirror type;
    private Element enclosingElement;
    private List<? extends Element> enclosedElements;
    private List<AnnotationMirror> annotationMirrors;
    private Map<String, AnnotationMirror> annotations = null;

    public DecoratedElement(E delegate, DecoratedProcessingEnvironment env) {
        this.delegate = delegate;
        this.env = env;
        if (this.env.getElementDecorations() != null) {
            for (ElementDecoration elementDecoration : this.env.getElementDecorations()) {
                elementDecoration.applyTo(this, this.env);
            }
        }
    }

    public boolean isPublic() {
        return this.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public boolean isProtected() {
        return this.getModifiers().contains((Object)Modifier.PROTECTED);
    }

    public boolean isPrivate() {
        return this.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    public boolean isAbstract() {
        return this.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean isStatic() {
        return this.getModifiers().contains((Object)Modifier.STATIC);
    }

    public boolean isFinal() {
        return this.getModifiers().contains((Object)Modifier.FINAL);
    }

    public boolean isTransient() {
        return this.getModifiers().contains((Object)Modifier.TRANSIENT);
    }

    public boolean isVolatile() {
        return this.getModifiers().contains((Object)Modifier.VOLATILE);
    }

    public boolean isSynchronized() {
        return this.getModifiers().contains((Object)Modifier.SYNCHRONIZED);
    }

    public boolean isNative() {
        return this.getModifiers().contains((Object)Modifier.NATIVE);
    }

    public boolean isStrictfp() {
        return this.getModifiers().contains((Object)Modifier.STRICTFP);
    }

    public String getDocComment() {
        return this.env.getElementUtils().getDocComment((Element)this.delegate);
    }

    public final JavaDoc getJavaDoc() {
        return this.getJavaDoc(DefaultJavaDocTagHandler.INSTANCE);
    }

    public final JavaDoc getJavaDoc(JavaDocTagHandler tagHandler) {
        return this.getJavaDoc(tagHandler, true);
    }

    protected JavaDoc getJavaDoc(JavaDocTagHandler tagHandler, boolean useDelegate) {
        if (useDelegate && this.delegate instanceof DecoratedElement) {
            return ((DecoratedElement)this.delegate).getJavaDoc(tagHandler);
        }
        JavaDoc javaDoc = this.javaDocs.get(tagHandler);
        if (javaDoc == null) {
            javaDoc = new JavaDoc(this.getDocComment(), tagHandler, this, this.env);
            this.javaDocs.put(tagHandler, javaDoc);
        }
        return javaDoc;
    }

    public final String getDocValue() {
        return this.getDocValue(DefaultJavaDocTagHandler.INSTANCE);
    }

    public final String getDocValue(JavaDocTagHandler tagHandler) {
        String value = this.getJavaDoc(tagHandler).toString();
        if (value != null && "".equals(value = value.trim())) {
            value = null;
        }
        return value;
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, AnnotationMirror>();
            for (AnnotationMirror annotationMirror : this.getAnnotationMirrors()) {
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                if (annotationType == null || !(annotationType.asElement() instanceof TypeElement)) continue;
                this.annotations.put(((TypeElement)annotationType.asElement()).getQualifiedName().toString(), annotationMirror);
            }
        }
        return this.annotations;
    }

    @Override
    public TypeMirror asType() {
        if (this.type == null) {
            this.type = TypeMirrorDecorator.decorate(this.delegate.asType(), this.env);
        }
        return this.type;
    }

    @Override
    public ElementKind getKind() {
        return this.delegate.getKind();
    }

    @Override
    public Element getEnclosingElement() {
        if (this.enclosingElement == null) {
            this.enclosingElement = ElementDecorator.decorate(this.delegate.getEnclosingElement(), this.env);
        }
        return this.enclosingElement;
    }

    @Override
    public List<? extends Element> getEnclosedElements() {
        if (this.enclosedElements == null) {
            this.enclosedElements = ElementDecorator.decorate(this.delegate.getEnclosedElements(), this.env);
        }
        return this.enclosedElements;
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> v, P p) {
        return v.visitUnknown(this, p);
    }

    @Override
    public List<? extends AnnotationMirror> getAnnotationMirrors() {
        if (this.annotationMirrors == null) {
            this.annotationMirrors = ElementDecorator.decorateAnnotationMirrors(this.delegate.getAnnotationMirrors(), this.env);
        }
        return this.annotationMirrors;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.delegate.getAnnotation(annotationType);
    }

    @Override
    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
        return this.delegate.getAnnotationsByType(annotationType);
    }

    @Override
    public Set<Modifier> getModifiers() {
        return this.delegate.getModifiers();
    }

    @Override
    public Name getSimpleName() {
        return this.delegate.getSimpleName();
    }

    public String getSimpleNameString() {
        return this.getSimpleName().toString();
    }

    public E getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DecoratedElement) {
            return this.equals(((DecoratedElement)obj).delegate);
        }
        E delegate = this.delegate;
        while (delegate instanceof DecoratedElement) {
            delegate = ((DecoratedElement)delegate).delegate;
        }
        return delegate.equals(obj);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

