/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.javac.decorations.element;

import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.ElementDecorator;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedExecutableElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.decorations.element.PropertyElement;
import com.webcohesion.enunciate.javac.decorations.element.PropertySpec;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class DecoratedTypeElement
extends DecoratedElement<TypeElement>
implements TypeElement {
    private PackageElement pckg;
    private List<PropertyElement> properties;
    private TypeMirror superclass;
    private List<? extends TypeMirror> interfaces;
    private List<ExecutableElement> methods;
    private List<ExecutableElement> constructors;
    private List<VariableElement> enumConstants;

    public DecoratedTypeElement(TypeElement delegate, DecoratedProcessingEnvironment env) {
        super(delegate, env);
    }

    public PackageElement getPackage() {
        if (this.pckg == null) {
            this.pckg = ElementDecorator.decorate(this.env.getElementUtils().getPackageOf(this.delegate), this.env);
        }
        return this.pckg;
    }

    @Override
    public List<? extends TypeParameterElement> getTypeParameters() {
        return ElementDecorator.decorate(((TypeElement)this.delegate).getTypeParameters(), this.env);
    }

    @Override
    public NestingKind getNestingKind() {
        return ((TypeElement)this.delegate).getNestingKind();
    }

    @Override
    public Name getQualifiedName() {
        return ((TypeElement)this.delegate).getQualifiedName();
    }

    @Override
    public TypeMirror getSuperclass() {
        if (this.superclass == null) {
            this.superclass = TypeMirrorDecorator.decorate(((TypeElement)this.delegate).getSuperclass(), this.env);
        }
        return this.superclass;
    }

    @Override
    public List<? extends TypeMirror> getInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = TypeMirrorDecorator.decorate(((TypeElement)this.delegate).getInterfaces(), this.env);
        }
        return this.interfaces;
    }

    public List<ExecutableElement> getMethods() {
        if (this.methods == null) {
            this.methods = ElementDecorator.decorate(ElementFilter.methodsIn(((TypeElement)this.delegate).getEnclosedElements()), this.env);
        }
        return this.methods;
    }

    public List<? extends VariableElement> getFields() {
        ArrayList<VariableElement> fields = new ArrayList<VariableElement>();
        List<VariableElement> allFields = ElementFilter.fieldsIn(((TypeElement)this.delegate).getEnclosedElements());
        for (VariableElement field : allFields) {
            if (field.getKind() != ElementKind.FIELD || field.getModifiers().contains((Object)Modifier.STATIC)) continue;
            fields.add(field);
        }
        return fields;
    }

    public List<ExecutableElement> getConstructors() {
        if (this.constructors == null) {
            this.constructors = ElementDecorator.decorate(ElementFilter.constructorsIn(((TypeElement)this.delegate).getEnclosedElements()), this.env);
        }
        return this.constructors;
    }

    public List<PropertyElement> getProperties() {
        return this.getProperties(new ElementUtils.DefaultPropertySpec(this.env));
    }

    public List<PropertyElement> getProperties(PropertySpec spec) {
        if (this.properties == null) {
            this.properties = this.loadProperties(spec);
        }
        return this.properties;
    }

    public List<VariableElement> enumValues() {
        if (this.enumConstants == null) {
            this.enumConstants = this.loadEnumConstants();
        }
        return this.enumConstants;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        TypeElement superDecl;
        A annotation = super.getAnnotation(annotationType);
        if (this.isClass() && annotation == null && annotationType.getAnnotation(Inherited.class) != null && this.getSuperclass() instanceof DeclaredType && (superDecl = (TypeElement)((DeclaredType)this.getSuperclass()).asElement()) != null && !Object.class.getName().equals(superDecl.getQualifiedName().toString())) {
            return superDecl.getAnnotation(annotationType);
        }
        return annotation;
    }

    protected List<PropertyElement> loadProperties(PropertySpec spec) {
        HashMap<String, DecoratedExecutableElement> getters = new HashMap<String, DecoratedExecutableElement>();
        HashMap setters = new HashMap();
        for (ExecutableElement method : this.getMethods()) {
            DecoratedExecutableElement decoratedMethod = (DecoratedExecutableElement)method;
            boolean getter = spec.isGetter(decoratedMethod);
            boolean setter = spec.isSetter(decoratedMethod);
            if (!getter && !setter) continue;
            HashMap<String, DecoratedExecutableElement> methodMap = getter ? getters : setters;
            methodMap.put(decoratedMethod.getPropertyName(), decoratedMethod);
        }
        ArrayList<PropertyElement> properties = new ArrayList<PropertyElement>(getters.size());
        for (String propertyName : getters.keySet()) {
            DecoratedExecutableElement setter;
            DecoratedExecutableElement getter = (DecoratedExecutableElement)getters.get(propertyName);
            if (spec.isPaired(getter, setter = (DecoratedExecutableElement)setters.remove(propertyName))) {
                properties.add(new PropertyElement(getter, setter, spec, this.env));
                continue;
            }
            properties.add(new PropertyElement(getter, null, spec, this.env));
        }
        for (DecoratedExecutableElement setter : setters.values()) {
            properties.add(new PropertyElement(null, setter, spec, this.env));
        }
        return properties;
    }

    protected List<VariableElement> loadEnumConstants() {
        ArrayList<VariableElement> constants = new ArrayList<VariableElement>();
        if (this.isEnum()) {
            List<VariableElement> fields = ElementFilter.fieldsIn(((TypeElement)this.delegate).getEnclosedElements());
            for (VariableElement field : fields) {
                if (field.getKind() != ElementKind.ENUM_CONSTANT) continue;
                constants.add(ElementDecorator.decorate(field, this.env));
            }
        }
        return constants;
    }

    public boolean isClass() {
        return this.getKind() == ElementKind.CLASS;
    }

    public boolean isInterface() {
        return this.getKind() == ElementKind.INTERFACE;
    }

    public boolean isEnum() {
        return this.getKind() == ElementKind.ENUM;
    }

    public boolean isAnnotatedType() {
        return this.getKind() == ElementKind.ANNOTATION_TYPE;
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> v, P p) {
        return v.visitType(this, p);
    }
}

