/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.javac.decorations.element;

import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.ElementDecorator;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedExecutableElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.decorations.element.PropertySpec;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Name;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class PropertyElement
extends DecoratedExecutableElement {
    private final DecoratedExecutableElement setter;
    private final DecoratedExecutableElement getter;
    private final String propertyName;
    private final String simpleName;
    private final TypeMirror propertyType;
    private final boolean readOnly;
    private final boolean writeOnly;
    private final boolean recordComponent;

    public PropertyElement(DecoratedExecutableElement getter, DecoratedExecutableElement setter, DecoratedProcessingEnvironment env) {
        this(getter, setter, new ElementUtils.DefaultPropertySpec(env), env);
    }

    public PropertyElement(RecordComponentElement component, DecoratedProcessingEnvironment env) {
        super(ElementDecorator.decorate(component.getAccessor(), env), env);
        this.getter = (DecoratedExecutableElement)ElementDecorator.decorate(component.getAccessor(), env);
        this.setter = null;
        this.readOnly = false;
        this.writeOnly = false;
        this.propertyName = this.simpleName = component.getSimpleName().toString();
        this.propertyType = this.getter.getReturnType();
        this.recordComponent = true;
    }

    public PropertyElement(DecoratedExecutableElement getter, DecoratedExecutableElement setter, PropertySpec spec, DecoratedProcessingEnvironment env) {
        super(getter == null ? setter : getter);
        this.getter = getter;
        this.setter = setter;
        this.propertyName = spec.getPropertyName(getter != null ? getter : setter);
        this.simpleName = spec.getSimpleName(getter != null ? getter : setter);
        this.recordComponent = false;
        TypeMirror propertyType = null;
        if (getter != null) {
            propertyType = getter.getReturnType();
        }
        if (setter != null) {
            List<? extends VariableElement> parameters = setter.getParameters();
            if (parameters == null || parameters.size() != 1) {
                throw new IllegalStateException(this.setter + ": invalid setter for " + propertyType);
            }
            TypeMirror setterType = parameters.iterator().next().asType();
            if (propertyType == null) {
                propertyType = setterType;
            } else if (!env.getTypeUtils().isSameType(propertyType, setterType)) {
                throw new IllegalStateException(this.setter + ": invalid setter for getter of type " + propertyType);
            }
        }
        if (propertyType == null) {
            throw new IllegalStateException("Unable to determine property type for property" + this.propertyName + ".");
        }
        this.propertyType = propertyType;
        this.readOnly = this.setter == null;
        this.writeOnly = this.getter == null;
    }

    @Override
    public TypeMirror asType() {
        return this.getPropertyType();
    }

    public TypeMirror getPropertyType() {
        return this.propertyType;
    }

    @Override
    public Name getSimpleName() {
        return this.env.getElementUtils().getName(this.simpleName);
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    public DecoratedExecutableElement getSetter() {
        return this.setter;
    }

    public DecoratedExecutableElement getGetter() {
        return this.getter;
    }

    public boolean isRecordComponent() {
        return this.recordComponent;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isWriteOnly() {
        return this.writeOnly;
    }

    @Override
    public Map<String, AnnotationMirror> getAnnotations() {
        HashMap<String, AnnotationMirror> annotations = new HashMap<String, AnnotationMirror>();
        if (this.getGetter() != null) {
            annotations.putAll(this.getGetter().getAnnotations());
        }
        if (this.getSetter() != null) {
            annotations.putAll(this.getSetter().getAnnotations());
        }
        return annotations;
    }

    @Override
    public List<AnnotationMirror> getAnnotationMirrors() {
        return new ArrayList<AnnotationMirror>(this.getAnnotations().values());
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        A annotation = null;
        if (this.getter != null) {
            annotation = this.getter.getAnnotation(annotationType);
        }
        if (annotation == null && this.setter != null) {
            annotation = this.setter.getAnnotation(annotationType);
        }
        return annotation;
    }

    @Override
    public TypeMirror getReturnType() {
        return this.getPropertyType();
    }

    @Override
    public boolean isGetter() {
        return false;
    }

    @Override
    public boolean isSetter() {
        return false;
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> v, P p) {
        return v.visitExecutable(this, p);
    }
}

