/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb.util;

import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.model.Attribute;
import com.webcohesion.enunciate.modules.jaxb.model.ElementDeclaration;
import com.webcohesion.enunciate.modules.jaxb.model.EnumValue;
import com.webcohesion.enunciate.modules.jaxb.model.LocalElementDeclaration;
import com.webcohesion.enunciate.modules.jaxb.model.QNameEnumTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.RootElementDeclaration;
import com.webcohesion.enunciate.modules.jaxb.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.Value;
import com.webcohesion.enunciate.modules.jaxb.model.types.MapXmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlClassType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlType;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.xml.namespace.QName;

public class ReferencedNamespacesMethod
implements TemplateMethodModelEx {
    private final EnunciateJaxbContext context;

    public ReferencedNamespacesMethod(EnunciateJaxbContext context) {
        this.context = context;
    }

    public Object exec(List list) throws TemplateModelException {
        if (list.size() < 1) {
            throw new TemplateModelException("The referencedNamespaces method must have an element as a parameter.");
        }
        TemplateModel from = (TemplateModel)list.get(0);
        Object unwrapped = BeansWrapper.getDefaultInstance().unwrap(from);
        if (!(unwrapped instanceof ElementDeclaration)) {
            throw new TemplateModelException("The referencedNamespaces method must have an element as a parameter.");
        }
        ElementDeclaration elementDeclaration = (ElementDeclaration)unwrapped;
        HashSet<String> referencedNamespaces = new HashSet<String>();
        referencedNamespaces.add(elementDeclaration.getNamespace());
        if (elementDeclaration instanceof RootElementDeclaration) {
            TypeDefinition typeDef = ((RootElementDeclaration)elementDeclaration).getTypeDefinition();
            this.addReferencedNamespaces(typeDef, referencedNamespaces);
        } else if (elementDeclaration instanceof LocalElementDeclaration) {
            TypeDefinition typeDefinition;
            Element element;
            TypeElement typeElement = null;
            TypeMirror elementType = ((LocalElementDeclaration)elementDeclaration).getElementType();
            if (elementType instanceof DeclaredType && (element = ((DeclaredType)elementType).asElement()) instanceof TypeElement) {
                typeElement = (TypeElement)element;
            }
            if ((typeDefinition = this.context.findTypeDefinition(typeElement)) != null) {
                this.addReferencedNamespaces(typeDefinition, referencedNamespaces);
            }
        }
        referencedNamespaces.remove(null);
        referencedNamespaces.remove("");
        referencedNamespaces.remove("http://www.w3.org/2001/XMLSchema");
        return referencedNamespaces;
    }

    private void addReferencedNamespaces(TypeDefinition typeDefinition, Set<String> referencedNamespaces) {
        for (Attribute attribute : typeDefinition.getAttributes()) {
            QName ref = attribute.getRef();
            if (ref != null) {
                referencedNamespaces.add(ref.getNamespaceURI());
                continue;
            }
            this.addReferencedNamespaces(attribute.getBaseType(), referencedNamespaces);
        }
        for (com.webcohesion.enunciate.modules.jaxb.model.Element element : typeDefinition.getElements()) {
            for (com.webcohesion.enunciate.modules.jaxb.model.Element element2 : element.getChoices()) {
                QName ref = element2.getRef();
                if (ref != null) {
                    referencedNamespaces.add(ref.getNamespaceURI());
                    continue;
                }
                this.addReferencedNamespaces(element2.getBaseType(), referencedNamespaces);
            }
        }
        Value value = typeDefinition.getValue();
        if (value != null) {
            this.addReferencedNamespaces(value.getBaseType(), referencedNamespaces);
        }
        if (typeDefinition instanceof QNameEnumTypeDefinition) {
            for (EnumValue enumValue : ((QNameEnumTypeDefinition)typeDefinition).getEnumValues()) {
                if (enumValue.getValue() == null) continue;
                referencedNamespaces.add(((QName)enumValue.getValue()).getNamespaceURI());
            }
        }
        this.addReferencedNamespaces(typeDefinition.getBaseType(), referencedNamespaces);
    }

    private void addReferencedNamespaces(XmlType xmlType, Set<String> referencedNamespaces) {
        if (!xmlType.isAnonymous()) {
            referencedNamespaces.add(xmlType.getNamespace());
        } else if (xmlType instanceof MapXmlType) {
            referencedNamespaces.add(((MapXmlType)xmlType).getKeyType().getNamespace());
            referencedNamespaces.add(((MapXmlType)xmlType).getValueType().getNamespace());
        } else if (xmlType instanceof XmlClassType) {
            this.addReferencedNamespaces(((XmlClassType)xmlType).getTypeDefinition(), referencedNamespaces);
        }
    }
}

