/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb.api.impl;

import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedDeclaredType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.metadata.DocumentationExample;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import com.webcohesion.enunciate.modules.jaxb.api.impl.ExampleImpl;
import com.webcohesion.enunciate.modules.jaxb.model.Accessor;
import com.webcohesion.enunciate.modules.jaxb.model.Attribute;
import com.webcohesion.enunciate.modules.jaxb.model.ComplexTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.ElementDeclaration;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlClassType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlTypeFactory;
import com.webcohesion.enunciate.util.TypeHintUtils;
import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class ComplexTypeExampleImpl
extends ExampleImpl {
    private final ComplexTypeDefinition typeDefinition;
    private final List<DataTypeReference.ContainerType> containers;
    private final ApiRegistrationContext registrationContext;

    public ComplexTypeExampleImpl(ComplexTypeDefinition type, ApiRegistrationContext registrationContext) {
        this(type, null, registrationContext);
    }

    public ComplexTypeExampleImpl(ComplexTypeDefinition typeDefinition, List<DataTypeReference.ContainerType> containers, ApiRegistrationContext registrationContext) {
        this.typeDefinition = typeDefinition;
        this.containers = containers == null ? Collections.emptyList() : containers;
        this.registrationContext = registrationContext;
    }

    @Override
    public String getBody() {
        try {
            org.w3c.dom.Element rootElement;
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder domBuilder = builderFactory.newDocumentBuilder();
            Document document = domBuilder.newDocument();
            Object rootName = Character.toLowerCase(this.typeDefinition.getSimpleName().charAt(0)) + "-----";
            String rootNamespace = this.typeDefinition.getNamespace();
            ElementDeclaration element = this.typeDefinition.getContext().findElementDeclaration((Element)((Object)this.typeDefinition));
            if (element != null) {
                rootName = element.getName();
                rootNamespace = element.getNamespace();
            }
            org.w3c.dom.Element outer = rootElement = document.createElementNS(rootNamespace, (String)rootName);
            for (DataTypeReference.ContainerType container : this.containers) {
                org.w3c.dom.Element containerEl = document.createElementNS("", container.name());
                containerEl.appendChild(outer);
                outer = containerEl;
            }
            document.appendChild(outer);
            Context context = new Context();
            context.stack = new LinkedList();
            this.build(rootElement, this.typeDefinition, document, context);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("encoding", "utf-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(document);
            StringWriter value = new StringWriter();
            transformer.transform(source, new StreamResult(value));
            return value.toString();
        }
        catch (ParserConfigurationException e) {
            throw new EnunciateException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new EnunciateException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String build(org.w3c.dom.Element rootElement, ComplexTypeDefinition type, Document document, Context context) {
        if (context.stack.size() > 2) {
            return rootElement.getNamespaceURI();
        }
        if (context.stack.contains(type.getQualifiedName().toString())) {
            return rootElement.getNamespaceURI();
        }
        String defaultNamespace = rootElement.getNamespaceURI();
        context.stack.push(type.getQualifiedName().toString());
        try {
            String defaultSuperNs;
            FacetFilter facetFilter = this.registrationContext.getFacetFilter();
            for (Attribute attribute : type.getAttributes()) {
                String configuredExample;
                DocumentationExample documentationExample;
                if (ElementUtils.findDeprecationMessage((DecoratedElement)attribute, null) != null || !facetFilter.accept((HasFacets)attribute)) continue;
                String example = "...";
                JavaDoc.JavaDocTagList tags = this.getDocumentationExampleTags(attribute);
                if (tags != null && tags.size() > 0) {
                    String string = ((String)tags.get(0)).trim();
                    String string2 = example = string.isEmpty() ? null : string;
                }
                if ((documentationExample = this.getDocumentationExample(attribute)) != null) {
                    if (documentationExample.exclude()) continue;
                    if (context.currentIndex == 1 && !"##default".equals(documentationExample.value2())) {
                        example = documentationExample.value2();
                    } else if (!"##default".equals(documentationExample.value())) {
                        example = documentationExample.value();
                    }
                }
                if ((configuredExample = this.getConfiguredExample(attribute)) != null) {
                    example = configuredExample;
                }
                rootElement.setAttributeNS(attribute.getNamespace(), attribute.getName(), example);
                if (attribute.getNamespace() != null) continue;
                defaultNamespace = null;
            }
            if (type.getValue() != null) {
                String configuredExample;
                DocumentationExample documentationExample;
                Object example = "...";
                JavaDoc.JavaDocTagList tags = this.getDocumentationExampleTags(type.getValue());
                if (tags != null && tags.size() > 0) {
                    String tag = ((String)tags.get(0)).trim();
                    Object object = example = tag.isEmpty() ? null : tag;
                }
                if ((documentationExample = this.getDocumentationExample(type.getValue())) != null && !"##default".equals(documentationExample.value())) {
                    example = documentationExample.value();
                }
                if ((configuredExample = this.getConfiguredExample(type.getValue())) != null) {
                    example = configuredExample;
                }
                rootElement.setTextContent((String)example);
            } else {
                for (com.webcohesion.enunciate.modules.jaxb.model.Element element : type.getElements()) {
                    if (ElementUtils.findDeprecationMessage((DecoratedElement)element, null) != null || !facetFilter.accept((HasFacets)element)) continue;
                    org.w3c.dom.Element currentElement = rootElement;
                    if (element.isWrapped()) {
                        org.w3c.dom.Element wrapper = document.createElementNS(element.getWrapperNamespace(), element.getWrapperName());
                        rootElement.appendChild(wrapper);
                        currentElement = wrapper;
                        if (element.getWrapperNamespace() == null) {
                            defaultNamespace = null;
                        }
                    }
                    for (com.webcohesion.enunciate.modules.jaxb.model.Element element2 : element.getChoices()) {
                        TypeMirror typeHint;
                        DocumentationExample documentationExample;
                        String tag;
                        org.w3c.dom.Element childElement = document.createElementNS(element2.getNamespace(), element2.getName());
                        if (element2.getNamespace() == null) {
                            defaultNamespace = null;
                        }
                        XmlType baseType = element2.getXmlType();
                        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)element2.getJavaDoc().get((Object)"documentationType");
                        if (tags != null && tags.size() > 0 && !(tag = ((String)tags.get(0)).trim()).isEmpty()) {
                            TypeElement typeElement = type.getContext().getContext().getProcessingEnvironment().getElementUtils().getTypeElement(tag);
                            if (typeElement != null) {
                                baseType = XmlTypeFactory.getXmlType(typeElement.asType(), type.getContext());
                            } else {
                                type.getContext().getContext().getLogger().warn("Invalid documentation type %s.", new Object[]{tag});
                            }
                        }
                        if ((documentationExample = this.getDocumentationExample(element2)) != null && (typeHint = TypeHintUtils.getTypeHint((TypeHint)documentationExample.type(), (DecoratedProcessingEnvironment)type.getContext().getContext().getProcessingEnvironment(), null)) != null) {
                            baseType = XmlTypeFactory.getXmlType(typeHint, type.getContext());
                        }
                        if (baseType instanceof XmlClassType && ((XmlClassType)baseType).getTypeDefinition() instanceof ComplexTypeDefinition) {
                            String defaultChildNs = this.build(childElement, (ComplexTypeDefinition)((XmlClassType)baseType).getTypeDefinition(), document, context);
                            if (defaultChildNs == null) {
                                defaultNamespace = null;
                            }
                        } else {
                            String configuredExample;
                            String example = "...";
                            tags = this.getDocumentationExampleTags(element2);
                            if (tags != null && tags.size() > 0) {
                                String tag2 = ((String)tags.get(0)).trim();
                                String string = example = tag2.isEmpty() ? null : tag2;
                            }
                            if (documentationExample != null) {
                                if (documentationExample.exclude()) continue;
                                if (context.currentIndex == 1 && !"##default".equals(documentationExample.value2())) {
                                    example = documentationExample.value2();
                                } else if (!"##default".equals(documentationExample.value())) {
                                    example = documentationExample.value();
                                }
                            }
                            if ((configuredExample = this.getConfiguredExample(element2)) != null) {
                                example = configuredExample;
                            }
                            childElement.setTextContent(example);
                        }
                        currentElement.appendChild(childElement);
                    }
                }
            }
            XmlType supertype = type.getBaseType();
            if (supertype instanceof XmlClassType && ((XmlClassType)supertype).getTypeDefinition() instanceof ComplexTypeDefinition && (defaultSuperNs = this.build(rootElement, (ComplexTypeDefinition)((XmlClassType)supertype).getTypeDefinition(), document, context)) == null) {
                defaultNamespace = null;
            }
            if (type.getAnyElement() != null && ElementUtils.findDeprecationMessage((DecoratedElement)type.getAnyElement(), null) == null) {
                org.w3c.dom.Element extension1 = document.createElementNS(defaultNamespace, "extension1");
                extension1.setTextContent("...");
                rootElement.appendChild(extension1);
                org.w3c.dom.Element extension2 = document.createElementNS(defaultNamespace, "extension2");
                extension2.setTextContent("...");
                rootElement.appendChild(extension2);
            }
        }
        finally {
            context.stack.pop();
        }
        return defaultNamespace;
    }

    private DocumentationExample getDocumentationExample(Accessor member) {
        DecoratedTypeMirror accessorType;
        DocumentationExample annotation = (DocumentationExample)member.getAnnotation(DocumentationExample.class);
        if (annotation == null && (accessorType = member.getBareAccessorType()) instanceof DecoratedDeclaredType) {
            annotation = ((DecoratedDeclaredType)accessorType).asElement().getAnnotation(DocumentationExample.class);
        }
        return annotation;
    }

    private JavaDoc.JavaDocTagList getDocumentationExampleTags(Accessor member) {
        DecoratedTypeMirror accessorType;
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)member.getJavaDoc().get((Object)"documentationExample");
        if ((tags == null || tags.isEmpty()) && (accessorType = member.getBareAccessorType()) instanceof DecoratedDeclaredType) {
            Element element = ((DecoratedDeclaredType)accessorType).asElement();
            tags = element instanceof DecoratedElement ? (JavaDoc.JavaDocTagList)((DecoratedElement)element).getJavaDoc().get((Object)"documentationExample") : null;
        }
        return tags;
    }

    private String getConfiguredExample(Accessor member) {
        Element element;
        String configuredExample = null;
        DecoratedTypeMirror accessorType = member.getBareAccessorType();
        if (accessorType instanceof DecoratedDeclaredType && (element = ((DecoratedDeclaredType)accessorType).asElement()) instanceof TypeElement) {
            configuredExample = member.getContext().lookupExternalExample((TypeElement)element);
        }
        return configuredExample;
    }

    private static class Context {
        LinkedList<String> stack;
        int currentIndex = 0;

        private Context() {
        }
    }
}

