/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb.model;

import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.javac.decorations.Annotations;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.model.ElementDeclaration;
import com.webcohesion.enunciate.modules.jaxb.model.EnumValue;
import com.webcohesion.enunciate.modules.jaxb.model.SimpleTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.types.KnownXmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlTypeFactory;
import com.webcohesion.enunciate.util.AnnotationUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class EnumTypeDefinition
extends SimpleTypeDefinition {
    private final XmlEnum xmlEnum = (XmlEnum)this.getAnnotation(XmlEnum.class);
    private List<EnumValue> enumValues;

    public EnumTypeDefinition(TypeElement delegate, EnunciateJaxbContext context) {
        super(delegate, context);
    }

    protected List<EnumValue> loadEnumValues() {
        List enumConstants = this.enumValues();
        ArrayList<EnumValue> enumValues = new ArrayList<EnumValue>();
        HashSet<String> enumValueNames = new HashSet<String>(enumConstants.size());
        for (VariableElement enumConstant : enumConstants) {
            if (AnnotationUtils.isIgnored((Element)enumConstant)) continue;
            String value = enumConstant.getSimpleName().toString();
            XmlEnumValue enumValue = enumConstant.getAnnotation(XmlEnumValue.class);
            if (enumValue != null) {
                value = enumValue.value();
            }
            if (!enumValueNames.add(value)) {
                throw new EnunciateException(this.getQualifiedName() + ": duplicate enum value: " + value);
            }
            enumValues.add(new EnumValue(this, enumConstant, enumConstant.getSimpleName().toString(), value));
        }
        return enumValues;
    }

    @Override
    public XmlType getBaseType() {
        XmlType xmlType = KnownXmlType.STRING;
        if (this.xmlEnum != null) {
            DecoratedTypeMirror typeMirror = Annotations.mirrorOf(() -> ((XmlEnum)this.xmlEnum).value(), (DecoratedProcessingEnvironment)this.env);
            xmlType = XmlTypeFactory.getXmlType((TypeMirror)typeMirror, this.context);
        }
        return xmlType;
    }

    public DecoratedTypeMirror getEnumBaseClass() {
        try {
            return TypeMirrorUtils.mirrorOf((Class)(this.xmlEnum == null ? String.class : this.xmlEnum.value()), (ProcessingEnvironment)this.env);
        }
        catch (MirroredTypeException e) {
            return (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)e.getTypeMirror(), (DecoratedProcessingEnvironment)this.env);
        }
    }

    public List<EnumValue> getEnumValues() {
        if (this.enumValues == null) {
            this.enumValues = this.loadEnumValues();
        }
        return this.enumValues;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return this.getAnnotation(XmlJavaTypeAdapter.class) == null;
    }

    public String getXmlName() {
        ElementDeclaration elementDeclaration = this.getContext().findElementDeclaration(this.delegate);
        String xmlName = null;
        if (elementDeclaration != null) {
            xmlName = elementDeclaration.getName();
        }
        return xmlName;
    }
}

