/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb.model.types;

import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.javac.decorations.Annotations;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.model.Accessor;
import com.webcohesion.enunciate.modules.jaxb.model.adapters.Adaptable;
import com.webcohesion.enunciate.modules.jaxb.model.types.SpecifiedXmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlTypeVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSchemaTypes;

public class XmlTypeFactory {
    public static XmlType findSpecifiedType(Adaptable adaptable, EnunciateJaxbContext context) {
        XmlSchemaType specified;
        XmlType xmlType = null;
        if (adaptable instanceof Accessor && (specified = (XmlSchemaType)((Accessor)adaptable).getAnnotation(XmlSchemaType.class)) != null) {
            return new SpecifiedXmlType(specified);
        }
        if (adaptable.isAdapted()) {
            xmlType = XmlTypeFactory.getXmlType(adaptable.getAdapterType().getAdaptingType(), context);
        } else if (adaptable instanceof Accessor) {
            xmlType = XmlTypeFactory.findExplicitSchemaType((Accessor)adaptable, context);
        }
        return xmlType;
    }

    public static XmlType findExplicitSchemaType(Accessor accessor, EnunciateJaxbContext context) {
        DecoratedTypeMirror typeMirror = accessor.getCollectionItemType();
        SpecifiedXmlType xmlType = null;
        XmlSchemaType schemaType = (XmlSchemaType)accessor.getAnnotation(XmlSchemaType.class);
        if (schemaType == null && typeMirror instanceof DeclaredType) {
            PackageElement pckg = context.getContext().getProcessingEnvironment().getElementUtils().getPackageOf(accessor.getEnclosingElement());
            String packageName = pckg.getQualifiedName().toString();
            Map<String, XmlSchemaType> explicitTypes = context.getPackageSpecifiedTypes(packageName);
            if (explicitTypes == null) {
                explicitTypes = XmlTypeFactory.loadPackageExplicitTypes(pckg, context);
                context.setPackageSpecifiedTypes(packageName, explicitTypes);
            }
            schemaType = explicitTypes.get(((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().toString());
        }
        if (schemaType != null) {
            xmlType = new SpecifiedXmlType(schemaType);
        }
        return xmlType;
    }

    protected static Map<String, XmlSchemaType> loadPackageExplicitTypes(PackageElement pckg, EnunciateJaxbContext context) {
        HashMap<String, XmlSchemaType> explicitTypes = new HashMap<String, XmlSchemaType>();
        XmlSchemaType schemaTypeInfo = pckg.getAnnotation(XmlSchemaType.class);
        XmlSchemaTypes schemaTypes = pckg.getAnnotation(XmlSchemaTypes.class);
        if (schemaTypeInfo != null || schemaTypes != null) {
            ArrayList<XmlSchemaType> allSpecifiedTypes = new ArrayList<XmlSchemaType>();
            if (schemaTypeInfo != null) {
                allSpecifiedTypes.add(schemaTypeInfo);
            }
            if (schemaTypes != null) {
                allSpecifiedTypes.addAll(Arrays.asList(schemaTypes.value()));
            }
            for (XmlSchemaType specifiedType : allSpecifiedTypes) {
                DecoratedTypeMirror typeMirror = Annotations.mirrorOf(() -> ((XmlSchemaType)specifiedType).type(), (DecoratedProcessingEnvironment)context.getContext().getProcessingEnvironment(), XmlSchemaType.DEFAULT.class);
                if (typeMirror == null) {
                    throw new EnunciateException(pckg.getQualifiedName() + ": a type must be specified in " + XmlSchemaType.class.getName() + " at the package-level.");
                }
                if (!(typeMirror instanceof DeclaredType)) {
                    throw new EnunciateException(pckg.getQualifiedName() + ": only a declared type can be adapted.  Offending type: " + typeMirror);
                }
                explicitTypes.put(((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().toString(), specifiedType);
            }
        }
        return Collections.unmodifiableMap(explicitTypes);
    }

    public static XmlType getXmlType(TypeMirror typeMirror, EnunciateJaxbContext context) {
        DecoratedTypeMirror decorated = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)typeMirror, (DecoratedProcessingEnvironment)context.getContext().getProcessingEnvironment());
        XmlTypeVisitor visitor = new XmlTypeVisitor();
        DecoratedTypeMirror componentType = TypeMirrorUtils.getComponentType((DecoratedTypeMirror)decorated, (DecoratedProcessingEnvironment)context.getContext().getProcessingEnvironment());
        componentType = componentType == null ? decorated : componentType;
        return componentType.accept(visitor, new XmlTypeVisitor.Context(context, decorated.isArray(), decorated.isCollection(), new LinkedList<String>()));
    }
}

