/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb.api.impl;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.Styles;
import com.webcohesion.enunciate.api.datatype.DataType;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Example;
import com.webcohesion.enunciate.api.datatype.Namespace;
import com.webcohesion.enunciate.api.datatype.Syntax;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import com.webcohesion.enunciate.modules.jaxb.api.impl.NamespaceImpl;
import com.webcohesion.enunciate.modules.jaxb.api.impl.SyntaxImpl;
import com.webcohesion.enunciate.modules.jaxb.model.TypeDefinition;
import com.webcohesion.enunciate.util.AnnotationUtils;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public abstract class DataTypeImpl
implements DataType {
    private final TypeDefinition typeDefinition;
    protected final ApiRegistrationContext registrationContext;

    protected DataTypeImpl(TypeDefinition typeDefinition, ApiRegistrationContext registrationContext) {
        this.typeDefinition = typeDefinition;
        this.registrationContext = registrationContext;
    }

    public String getLabel() {
        String specifiedLabel = AnnotationUtils.getSpecifiedLabel((Element)((Object)this.typeDefinition));
        if (specifiedLabel != null) {
            return specifiedLabel;
        }
        return this.typeDefinition.isAnonymous() ? this.typeDefinition.getSimpleName() + " (Anonymous)" : this.typeDefinition.getName();
    }

    public String getSlug() {
        String ns = this.typeDefinition.getContext().getNamespacePrefixes().get(this.typeDefinition.getNamespace());
        return "xml_" + ns + "_" + (String)(this.typeDefinition.isAnonymous() ? "anonymous_" + this.typeDefinition.getSimpleName() : this.typeDefinition.getName());
    }

    public String getDescription() {
        return this.typeDefinition.getJavaDoc(this.registrationContext.getTagHandler()).toString();
    }

    public String getDeprecated() {
        return ElementUtils.findDeprecationMessage((DecoratedElement)this.typeDefinition, (JavaDocTagHandler)this.registrationContext.getTagHandler());
    }

    public Namespace getNamespace() {
        return new NamespaceImpl(this.typeDefinition.getContext().getSchemas().get(this.typeDefinition.getNamespace()), this.registrationContext);
    }

    public Syntax getSyntax() {
        return new SyntaxImpl(this.typeDefinition.getContext(), this.registrationContext);
    }

    public List<DataTypeReference> getSupertypes() {
        return null;
    }

    public Set<DataTypeReference> getInterfaces() {
        return null;
    }

    public List<DataTypeReference> getSubtypes() {
        return null;
    }

    public String getSince() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.typeDefinition.getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"since");
        if (tags == null) {
            tags = (JavaDoc.JavaDocTagList)this.typeDefinition.getPackage().getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"since");
        }
        return tags == null ? null : tags.toString();
    }

    public List<String> getSeeAlso() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.typeDefinition.getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"see");
        if (tags == null) {
            tags = (JavaDoc.JavaDocTagList)this.typeDefinition.getPackage().getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"see");
        }
        return tags;
    }

    public String getVersion() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.typeDefinition.getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"version");
        return tags == null ? null : tags.toString();
    }

    public boolean isAbstract() {
        return this.typeDefinition.isAbstract();
    }

    public Example getExample() {
        return null;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)this.typeDefinition.getAnnotation(annotationType);
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.typeDefinition.getAnnotations();
    }

    public Set<Facet> getFacets() {
        return this.typeDefinition.getFacets();
    }

    public JavaDoc getJavaDoc() {
        return this.typeDefinition.getJavaDoc(this.registrationContext.getTagHandler());
    }

    public Set<String> getStyles() {
        return Styles.gatherStyles((Element)((Object)this.typeDefinition), (Map)this.typeDefinition.getContext().getContext().getConfiguration().getAnnotationStyles());
    }

    public Element getJavaElement() {
        return this.typeDefinition;
    }
}

