/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb.api.impl;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.datatype.DataType;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Example;
import com.webcohesion.enunciate.api.datatype.Namespace;
import com.webcohesion.enunciate.api.datatype.Syntax;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedDeclaredType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.api.impl.ComplexDataTypeImpl;
import com.webcohesion.enunciate.modules.jaxb.api.impl.CustomExampleImpl;
import com.webcohesion.enunciate.modules.jaxb.api.impl.DataTypeReferenceImpl;
import com.webcohesion.enunciate.modules.jaxb.api.impl.EnumDataTypeImpl;
import com.webcohesion.enunciate.modules.jaxb.api.impl.MediaTypeDescriptorImpl;
import com.webcohesion.enunciate.modules.jaxb.api.impl.NamespaceImpl;
import com.webcohesion.enunciate.modules.jaxb.model.ComplexTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.EnumTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.SchemaInfo;
import com.webcohesion.enunciate.modules.jaxb.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlTypeFactory;
import jakarta.xml.bind.JAXBElement;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class SyntaxImpl
implements Syntax {
    public static final String SYNTAX_LABEL = "XML";
    private final EnunciateJaxbContext context;
    private ApiRegistrationContext registrationContext;

    public SyntaxImpl(EnunciateJaxbContext context, ApiRegistrationContext registrationContext) {
        this.context = context;
        this.registrationContext = registrationContext;
    }

    public String getId() {
        return "jaxb";
    }

    public int compareTo(Syntax syntax) {
        return this.getId().compareTo(syntax.getId());
    }

    public String getSlug() {
        return "syntax_xml";
    }

    public String getLabel() {
        return SYNTAX_LABEL;
    }

    public boolean isEmpty() {
        return this.context.getSchemas().isEmpty();
    }

    public List<Namespace> getNamespaces() {
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        for (SchemaInfo schemaInfo : this.context.getSchemas().values()) {
            namespaces.add(new NamespaceImpl(schemaInfo, this.registrationContext));
        }
        return namespaces;
    }

    public boolean isAssignableToMediaType(String mediaType) {
        return mediaType != null && (mediaType.equals("*/*") || mediaType.equals("application/*") || mediaType.equals("text/*") || mediaType.endsWith("/xml") || mediaType.endsWith("+xml"));
    }

    public MediaTypeDescriptor findMediaTypeDescriptor(String mediaType, DecoratedTypeMirror typeMirror) {
        if (mediaType == null) {
            return null;
        }
        if (mediaType.equals("*/*") || mediaType.equals("application/*")) {
            mediaType = "application/xml";
        } else if (mediaType.equals("text/*")) {
            mediaType = "text/xml";
        }
        if (mediaType.endsWith("/xml") || mediaType.endsWith("+xml")) {
            DataTypeReference typeReference = this.findDataTypeReference(typeMirror);
            return typeReference == null ? null : new MediaTypeDescriptorImpl(mediaType, typeReference);
        }
        return null;
    }

    private DataTypeReference findDataTypeReference(DecoratedTypeMirror typeMirror) {
        XmlType xmlType;
        if (typeMirror == null) {
            return null;
        }
        if (typeMirror.isInstanceOf(JAXBElement.class)) {
            List typeArguments = ((DecoratedDeclaredType)typeMirror).getTypeArguments();
            typeMirror = TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)this.context.getContext().getProcessingEnvironment());
            if (typeArguments != null && !typeArguments.isEmpty()) {
                typeMirror = (DecoratedTypeMirror)typeArguments.get(0);
            }
        }
        try {
            xmlType = XmlTypeFactory.getXmlType((TypeMirror)typeMirror, this.context);
        }
        catch (Exception e) {
            xmlType = null;
        }
        return xmlType == null ? null : new DataTypeReferenceImpl(xmlType, typeMirror.isCollection() || typeMirror.isArray(), this.registrationContext);
    }

    public List<DataType> findDataTypes(String name) {
        TypeElement typeElement;
        if (name != null && !name.isEmpty() && (typeElement = this.context.getContext().getProcessingEnvironment().getElementUtils().getTypeElement(name)) != null) {
            TypeDefinition typeDefinition = this.context.findTypeDefinition(typeElement);
            if (typeDefinition instanceof ComplexTypeDefinition) {
                return Collections.singletonList(new ComplexDataTypeImpl((ComplexTypeDefinition)typeDefinition, this.registrationContext));
            }
            if (typeDefinition instanceof EnumTypeDefinition) {
                return Collections.singletonList(new EnumDataTypeImpl((EnumTypeDefinition)typeDefinition, this.registrationContext));
            }
        }
        return Collections.emptyList();
    }

    public Example parseExample(Reader example) throws Exception {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        DocumentBuilder domBuilder = builderFactory.newDocumentBuilder();
        Document document = domBuilder.parse(new InputSource(example));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(document);
        StringWriter value = new StringWriter();
        transformer.transform(source, new StreamResult(value));
        return new CustomExampleImpl(value.toString());
    }
}

