/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb.model;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.Annotations;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedTypeElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.decorations.element.PropertyElement;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedDeclaredType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.metadata.ClientName;
import com.webcohesion.enunciate.metadata.qname.XmlQNameEnumRef;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.adapters.Adaptable;
import com.webcohesion.enunciate.modules.jaxb.model.adapters.AdapterType;
import com.webcohesion.enunciate.modules.jaxb.model.types.KnownXmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlTypeFactory;
import com.webcohesion.enunciate.modules.jaxb.model.util.JAXBUtil;
import com.webcohesion.enunciate.modules.jaxb.model.util.MapType;
import com.webcohesion.enunciate.util.HasClientConvertibleType;
import com.webcohesion.enunciate.util.OptionalUtils;
import jakarta.activation.DataHandler;
import jakarta.xml.bind.annotation.XmlAttachmentRef;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlInlineBinaryData;
import jakarta.xml.bind.annotation.XmlList;
import jakarta.xml.bind.annotation.XmlMimeType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.xml.namespace.QName;

public abstract class Accessor
extends DecoratedElement<Element>
implements Adaptable,
HasFacets,
HasClientConvertibleType {
    final TypeDefinition typeDefinition;
    final AdapterType adapterType;
    final Set<Facet> facets = new TreeSet<Facet>();
    final EnunciateJaxbContext context;

    public Accessor(Element delegate, TypeDefinition typeDef, EnunciateJaxbContext context) {
        super(delegate, context.getContext().getProcessingEnvironment());
        this.typeDefinition = typeDef;
        this.facets.addAll(Facet.gatherFacets((Element)delegate, (EnunciateContext)context.getContext()));
        this.facets.addAll(typeDef.getFacets());
        this.context = context;
        this.adapterType = JAXBUtil.findAdapterType((Element)((Object)this), context);
    }

    public abstract String getName();

    public abstract String getNamespace();

    public EnunciateJaxbContext getContext() {
        return this.context;
    }

    public String getClientSimpleName() {
        String clientSimpleName = this.delegate.getSimpleName().toString();
        ClientName clientName = this.delegate.getAnnotation(ClientName.class);
        if (clientName != null) {
            clientSimpleName = clientName.value();
        }
        return clientSimpleName;
    }

    public DecoratedTypeMirror getAccessorType() {
        Object accessorType = (DecoratedTypeMirror)this.asType();
        DecoratedDeclaredType normalizedCollection = JAXBUtil.getNormalizedCollection(accessorType = OptionalUtils.stripOptional((DecoratedTypeMirror)accessorType, (DecoratedProcessingEnvironment)this.context.getContext().getProcessingEnvironment()), this.context.getContext().getProcessingEnvironment());
        if (normalizedCollection != null) {
            accessorType = normalizedCollection;
        } else {
            MapType mapType = MapType.findMapType((TypeMirror)accessorType, this.context);
            if (mapType != null) {
                accessorType = mapType;
            }
        }
        return accessorType;
    }

    public TypeMirror getClientConvertibleType() {
        return this.getAccessorType();
    }

    public DecoratedTypeMirror getBareAccessorType() {
        if (this.isCollectionType()) {
            return this.getCollectionItemType();
        }
        if (this.isXmlList()) {
            DecoratedTypeMirror componentType = this.getCollectionItemType();
            return componentType != null ? componentType : this.getAccessorType();
        }
        return this.getAccessorType();
    }

    public XmlType getBaseType() {
        if (this.isXmlID()) {
            return KnownXmlType.ID;
        }
        if (this.isXmlIDREF()) {
            return KnownXmlType.IDREF;
        }
        if (this.isSwaRef()) {
            return KnownXmlType.SWAREF;
        }
        XmlType xmlType = XmlTypeFactory.findSpecifiedType(this, this.context);
        return xmlType != null ? xmlType : XmlTypeFactory.getXmlType((TypeMirror)this.getAccessorType(), this.context);
    }

    public XmlType getXmlType() {
        return this.getBaseType();
    }

    public QName getRef() {
        return null;
    }

    public TypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public boolean isXmlList() {
        return this.delegate.getAnnotation(XmlList.class) != null;
    }

    public boolean isXmlID() {
        return this.delegate.getAnnotation(XmlID.class) != null;
    }

    public boolean isXmlIDREF() {
        return this.delegate.getAnnotation(XmlIDREF.class) != null;
    }

    public boolean isBinaryData() {
        return this.isSwaRef() || KnownXmlType.BASE64_BINARY.getQname().equals(this.getBaseType().getQname());
    }

    public boolean isQNameType() {
        return this.getBaseType() == KnownXmlType.QNAME;
    }

    public DecoratedTypeMirror getResolvedAccessorType() {
        DecoratedTypeMirror accessorType = this.getAccessorType();
        if (this.isAdapted()) {
            accessorType = (DecoratedTypeMirror)this.getAdapterType().getAdaptingType(accessorType, this.context.getContext());
        }
        return accessorType;
    }

    public boolean isSwaRef() {
        DecoratedTypeMirror accessorType = this.getAccessorType();
        return this.getAnnotation(XmlAttachmentRef.class) != null && accessorType.isInstanceOf(DataHandler.class);
    }

    public boolean isMTOMAttachment() {
        return this.getAnnotation(XmlInlineBinaryData.class) == null && KnownXmlType.BASE64_BINARY.getQname().equals(this.getBaseType().getQname());
    }

    public String getMimeType() {
        XmlMimeType mimeType = (XmlMimeType)this.getAnnotation(XmlMimeType.class);
        if (mimeType != null) {
            return mimeType.value();
        }
        return null;
    }

    public boolean isCollectionType() {
        if (this.isXmlList()) {
            return false;
        }
        DecoratedTypeMirror accessorType = this.getAccessorType();
        if (this.isAdapted()) {
            accessorType = (DecoratedTypeMirror)this.getAdapterType().getAdaptingType(accessorType, this.context.getContext());
        }
        if (accessorType.isArray()) {
            return ((ArrayType)accessorType).getComponentType().getKind() != TypeKind.BYTE;
        }
        return accessorType.isCollection();
    }

    public DecoratedTypeMirror getCollectionItemType() {
        if (this.isAdapted()) {
            DecoratedTypeMirror adaptingType = (DecoratedTypeMirror)this.getAdapterType().getAdaptingType();
            if (adaptingType.isCollection()) {
                return TypeMirrorUtils.getComponentType((DecoratedTypeMirror)adaptingType, (DecoratedProcessingEnvironment)this.context.getContext().getProcessingEnvironment());
            }
            return adaptingType;
        }
        return TypeMirrorUtils.getComponentType((DecoratedTypeMirror)this.getAccessorType(), (DecoratedProcessingEnvironment)this.context.getContext().getProcessingEnvironment());
    }

    public DecoratedElement getAccessorForXmlID() {
        DecoratedTypeMirror accessorType;
        if (this.isXmlIDREF() && (accessorType = this.getBareAccessorType()).isDeclared()) {
            return this.getXmlIDAccessor((DecoratedDeclaredType)accessorType);
        }
        return null;
    }

    private DecoratedElement getXmlIDAccessor(DecoratedDeclaredType classType) {
        if (classType == null) {
            return null;
        }
        DecoratedTypeElement declaration = (DecoratedTypeElement)classType.asElement();
        if (declaration == null || Object.class.getName().equals(declaration.getQualifiedName().toString())) {
            return null;
        }
        for (Element field : ElementUtils.fieldsOrRecordComponentsIn((TypeElement)declaration)) {
            if (field.getAnnotation(XmlID.class) == null) continue;
            return (DecoratedElement)field;
        }
        for (PropertyElement property : declaration.getProperties()) {
            if (property.getAnnotation(XmlID.class) == null) continue;
            return property;
        }
        TypeMirror superclass = declaration.getSuperclass();
        if (superclass == null || superclass.getKind() == TypeKind.NONE) {
            return null;
        }
        return this.getXmlIDAccessor((DecoratedDeclaredType)superclass);
    }

    public Collection<DecoratedTypeMirror> getSeeAlsos() {
        ArrayList<DecoratedTypeMirror> seeAlsos = null;
        XmlSeeAlso seeAlsoInfo = (XmlSeeAlso)this.getAnnotation(XmlSeeAlso.class);
        if (seeAlsoInfo != null) {
            seeAlsos = new ArrayList<DecoratedTypeMirror>();
            try {
                for (Class clazz : seeAlsoInfo.value()) {
                    seeAlsos.add(TypeMirrorUtils.mirrorOf((Class)clazz, (ProcessingEnvironment)this.env));
                }
            }
            catch (MirroredTypesException e) {
                seeAlsos.addAll(TypeMirrorDecorator.decorate(e.getTypeMirrors(), (DecoratedProcessingEnvironment)this.env));
            }
        }
        return seeAlsos;
    }

    @Override
    public boolean isAdapted() {
        return this.adapterType != null;
    }

    @Override
    public AdapterType getAdapterType() {
        return this.adapterType;
    }

    public boolean isAttribute() {
        return false;
    }

    public boolean isValue() {
        return false;
    }

    public boolean isElementRef() {
        return false;
    }

    public boolean isReferencesQNameEnum() {
        return this.getAnnotation(XmlQNameEnumRef.class) != null;
    }

    public DecoratedTypeMirror getQNameEnumRef() {
        XmlQNameEnumRef enumRef = (XmlQNameEnumRef)this.getAnnotation(XmlQNameEnumRef.class);
        DecoratedTypeMirror qnameEnumType = null;
        if (enumRef != null) {
            qnameEnumType = Annotations.mirrorOf(() -> ((XmlQNameEnumRef)enumRef).value(), (DecoratedProcessingEnvironment)this.env);
        }
        return qnameEnumType;
    }

    public LinkedList<Element> getReferencedFrom() {
        LinkedList<Element> stack = new LinkedList<Element>(this.typeDefinition.getReferencedFrom());
        stack.add((Element)((Object)this));
        return stack;
    }

    public Set<Facet> getFacets() {
        return this.facets;
    }

    public boolean overrides(Accessor accessor) {
        return accessor != null && accessor != this && accessor.getAnnotation(XmlTransient.class) == null && this.getSimpleName().toString().equals(accessor.getSimpleName().toString());
    }
}

