/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb.model;

import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedExecutableElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedVariableElement;
import com.webcohesion.enunciate.javac.decorations.element.PropertyElement;
import com.webcohesion.enunciate.util.AnnotationUtils;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

public class AccessorFilter {
    private final XmlAccessType accessType;

    public AccessorFilter(XmlAccessType accessType) {
        this.accessType = accessType;
        if (accessType == null) {
            throw new IllegalArgumentException("An access type must be specified.");
        }
    }

    public boolean accept(DecoratedElement<?> element) {
        if (AnnotationUtils.isIgnored(element)) {
            return false;
        }
        if (element.getAnnotation(XmlTransient.class) != null) {
            return false;
        }
        if (element instanceof PropertyElement) {
            PropertyElement property = (PropertyElement)element;
            if ("".equals(property.getPropertyName())) {
                return false;
            }
            if (property.isRecordComponent()) {
                return true;
            }
            for (String annotationName : property.getAnnotations().keySet()) {
                if (!annotationName.startsWith("jakarta.xml.bind.annotation")) continue;
                return true;
            }
            DecoratedExecutableElement getter = property.getGetter();
            if (getter == null) {
                return false;
            }
            DecoratedExecutableElement setter = property.getSetter();
            if (setter == null) {
                return false;
            }
            if (!getter.isPublic()) {
                return false;
            }
            if (!setter.isPublic()) {
                return false;
            }
            return this.accessType != XmlAccessType.NONE && this.accessType != XmlAccessType.FIELD || this.explicitlyDeclaredAccessor(element);
        }
        if (element instanceof DecoratedVariableElement) {
            if (element.isStatic() || element.isTransient()) {
                return false;
            }
            if (this.accessType == XmlAccessType.NONE || this.accessType == XmlAccessType.PROPERTY) {
                return this.explicitlyDeclaredAccessor(element);
            }
            if (this.accessType == XmlAccessType.PUBLIC_MEMBER) {
                return element.isPublic() || this.explicitlyDeclaredAccessor(element);
            }
            return true;
        }
        return false;
    }

    protected boolean explicitlyDeclaredAccessor(DecoratedElement<?> element) {
        List mirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement annotationDeclaration;
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (annotationType == null || (annotationDeclaration = (TypeElement)annotationType.asElement()) == null || !annotationDeclaration.getQualifiedName().toString().startsWith(XmlElement.class.getPackage().getName())) continue;
            return !annotationDeclaration.getQualifiedName().toString().equals(XmlTransient.class.getName());
        }
        return false;
    }
}

