/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb.model.adapters;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedDeclaredType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.javac.decorations.type.TypeVariableContext;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public class AdapterType
extends DecoratedDeclaredType {
    private final TypeMirror adaptedType;
    private final TypeMirror adaptingType;

    public AdapterType(DeclaredType adapterType, EnunciateContext context) {
        super(adapterType, context.getProcessingEnvironment());
        DeclaredType adaptorInterfaceType = AdapterType.findXmlAdapterType(adapterType, new TypeVariableContext(), context.getProcessingEnvironment());
        if (adaptorInterfaceType == null) {
            throw new EnunciateException(adapterType + " is not an instance of jakarta.xml.bind.annotation.adapters.XmlAdapter.");
        }
        List<? extends TypeMirror> adaptorTypeArgs = adaptorInterfaceType.getTypeArguments();
        if (adaptorTypeArgs == null || adaptorTypeArgs.size() != 2) {
            throw new EnunciateException(adapterType + " must specify both a value type and a bound type.");
        }
        this.adaptingType = adaptorTypeArgs.get(0);
        TypeMirror adaptedType = adaptorTypeArgs.get(1);
        while (adaptedType instanceof TypeVariable) {
            adaptedType = ((TypeVariable)adaptedType).getUpperBound();
        }
        this.adaptedType = adaptedType = context.getProcessingEnvironment().getTypeUtils().erasure(adaptedType);
    }

    private static DeclaredType findXmlAdapterType(DeclaredType declaredType, TypeVariableContext variableContext, DecoratedProcessingEnvironment env) {
        TypeElement element = (TypeElement)declaredType.asElement();
        if (element == null) {
            return null;
        }
        if (Object.class.getName().equals(element.getQualifiedName().toString())) {
            return null;
        }
        if (XmlAdapter.class.getName().equals(element.getQualifiedName().toString())) {
            return (DeclaredType)variableContext.resolveTypeVariables((TypeMirror)declaredType, (ProcessingEnvironment)env);
        }
        TypeMirror superclass = element.getSuperclass();
        if (!(superclass instanceof DeclaredType) || superclass.getKind() == TypeKind.NONE) {
            return null;
        }
        return AdapterType.findXmlAdapterType((DeclaredType)superclass, variableContext.push(element.getTypeParameters(), declaredType.getTypeArguments()), env);
    }

    public boolean canAdapt(TypeMirror type, EnunciateContext context) {
        return context.getProcessingEnvironment().getTypeUtils().isAssignable(type, this.getAdaptedType());
    }

    public TypeMirror getAdaptingType(DecoratedTypeMirror adaptedType, EnunciateContext context) {
        TypeMirror componentType = null;
        if (adaptedType.isCollection()) {
            List<? extends TypeMirror> itemTypes = ((DeclaredType)adaptedType).getTypeArguments();
            componentType = itemTypes.isEmpty() ? TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)context.getProcessingEnvironment()) : itemTypes.get(0);
        } else if (adaptedType instanceof ArrayType) {
            componentType = ((ArrayType)adaptedType).getComponentType();
        }
        if (componentType != null && this.canAdapt(componentType, context)) {
            return context.getProcessingEnvironment().getTypeUtils().getDeclaredType((TypeElement)TypeMirrorUtils.collectionType((DecoratedProcessingEnvironment)context.getProcessingEnvironment()).asElement(), this.getAdaptingType());
        }
        return this.getAdaptingType();
    }

    public TypeMirror getAdaptedType() {
        return this.adaptedType;
    }

    public TypeMirror getAdaptingType() {
        return this.adaptingType;
    }
}

