/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs.model;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedTypeElement;
import com.webcohesion.enunciate.javac.decorations.element.PropertyElement;
import com.webcohesion.enunciate.javac.decorations.type.TypeVariableContext;
import com.webcohesion.enunciate.modules.jaxrs.EnunciateJaxrsContext;
import com.webcohesion.enunciate.modules.jaxrs.model.PathContext;
import com.webcohesion.enunciate.modules.jaxrs.model.PathSegment;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceMethod;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceParameter;
import com.webcohesion.enunciate.modules.jaxrs.model.SubResource;
import com.webcohesion.enunciate.modules.jaxrs.model.SubResourceLocator;
import com.webcohesion.enunciate.modules.jaxrs.model.util.JaxrsUtil;
import com.webcohesion.enunciate.modules.jaxrs.model.util.MediaType;
import com.webcohesion.enunciate.util.AnnotationUtils;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.HttpMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.security.RolesAllowed;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

public abstract class Resource
extends DecoratedTypeElement
implements HasFacets,
PathContext {
    private final EnunciateJaxrsContext context;
    private final String path;
    private final List<PathSegment> pathComponents;
    private final Set<MediaType> consumesMime;
    private final Set<MediaType> producesMime;
    private final Set<ResourceParameter> resourceParameters;
    private final List<ResourceMethod> resourceMethods;
    private final List<SubResourceLocator> resourceLocators;
    private final Set<Facet> facets = new TreeSet<Facet>();

    protected Resource(TypeElement delegate, String path, TypeVariableContext variableContext, EnunciateJaxrsContext context) {
        super(delegate, context.getContext().getProcessingEnvironment());
        this.context = context;
        if (path == null) {
            throw new NullPointerException();
        }
        this.path = path;
        this.pathComponents = Resource.extractPathComponents(path);
        TreeSet<MediaType> consumes = new TreeSet<MediaType>();
        javax.ws.rs.Consumes consumesInfo = delegate.getAnnotation(javax.ws.rs.Consumes.class);
        Consumes consumesInfo2 = delegate.getAnnotation(Consumes.class);
        if (consumesInfo != null || consumesInfo2 != null) {
            consumes.addAll(JaxrsUtil.value(consumesInfo != null ? consumesInfo.value() : consumesInfo2.value()));
        } else {
            consumes.add(new MediaType("*/*", 1.0f));
        }
        this.consumesMime = Collections.unmodifiableSet(consumes);
        TreeSet<MediaType> produces = new TreeSet<MediaType>();
        Produces producesInfo = delegate.getAnnotation(Produces.class);
        jakarta.ws.rs.Produces producesInfo2 = delegate.getAnnotation(jakarta.ws.rs.Produces.class);
        if (producesInfo != null || producesInfo2 != null) {
            produces.addAll(JaxrsUtil.value(producesInfo != null ? producesInfo.value() : producesInfo2.value()));
        } else {
            produces.add(new MediaType("*/*", 1.0f));
        }
        this.producesMime = Collections.unmodifiableSet(produces);
        this.facets.addAll(Facet.gatherFacets((Element)delegate, (EnunciateContext)context.getContext()));
        this.resourceParameters = Collections.unmodifiableSet(this.getResourceParameters(delegate, context));
        this.resourceMethods = Collections.unmodifiableList(this.getResourceMethods(delegate, new TypeVariableContext(), context));
        this.resourceLocators = Collections.unmodifiableList(this.getSubresourceLocators(delegate, variableContext, context));
    }

    protected List<SubResourceLocator> getSubresourceLocators(TypeElement delegate, TypeVariableContext variableContext, EnunciateJaxrsContext context) {
        TypeMirror superclass;
        if (delegate == null || delegate.getQualifiedName().toString().equals(Object.class.getName())) {
            return Collections.emptyList();
        }
        ArrayList<SubResourceLocator> resourceLocators = new ArrayList<SubResourceLocator>();
        block0: for (ExecutableElement executableElement : ElementFilter.methodsIn(delegate.getEnclosedElements())) {
            if (executableElement.getAnnotation(Path.class) == null && executableElement.getAnnotation(jakarta.ws.rs.Path.class) == null) continue;
            for (AnnotationMirror annotationMirror : executableElement.getAnnotationMirrors()) {
                Element annotationElement = annotationMirror.getAnnotationType().asElement();
                if (annotationElement == null || annotationElement.getAnnotation(javax.ws.rs.HttpMethod.class) == null && annotationElement.getAnnotation(HttpMethod.class) == null) continue;
                continue block0;
            }
            resourceLocators.add(new SubResourceLocator(executableElement, this, variableContext, this.context));
        }
        for (TypeMirror typeMirror : delegate.getInterfaces()) {
            if (!(typeMirror instanceof DeclaredType)) continue;
            List<SubResourceLocator> interfaceMethods = this.getSubresourceLocators((TypeElement)((DeclaredType)typeMirror).asElement(), variableContext, context);
            for (SubResourceLocator interfaceMethod : interfaceMethods) {
                if (this.isOverridden((ExecutableElement)((Object)interfaceMethod), resourceLocators)) continue;
                resourceLocators.add(interfaceMethod);
            }
        }
        if (delegate.getKind() == ElementKind.CLASS && (superclass = delegate.getSuperclass()) instanceof DeclaredType && ((DeclaredType)superclass).asElement() != null) {
            List<SubResourceLocator> list = this.getSubresourceLocators((TypeElement)((DeclaredType)superclass).asElement(), variableContext, context);
            for (SubResourceLocator subResourceLocator : list) {
                if (this.isOverridden((ExecutableElement)((Object)subResourceLocator), resourceLocators)) continue;
                resourceLocators.add(subResourceLocator);
            }
        }
        return resourceLocators;
    }

    protected List<ResourceMethod> getResourceMethods(TypeElement delegate, TypeVariableContext variableContext, EnunciateJaxrsContext context) {
        TypeMirror superclass;
        if (delegate == null || delegate.getQualifiedName().toString().equals(Object.class.getName())) {
            return Collections.emptyList();
        }
        ArrayList<ResourceMethod> resourceMethods = new ArrayList<ResourceMethod>();
        block0: for (ExecutableElement executableElement : ElementFilter.methodsIn(delegate.getEnclosedElements())) {
            if (AnnotationUtils.isIgnored((Element)executableElement) || !executableElement.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            for (AnnotationMirror annotationMirror : executableElement.getAnnotationMirrors()) {
                Element annotationElement = annotationMirror.getAnnotationType().asElement();
                if (annotationElement == null || annotationElement.getAnnotation(javax.ws.rs.HttpMethod.class) == null && annotationElement.getAnnotation(HttpMethod.class) == null) continue;
                resourceMethods.add(new ResourceMethod(executableElement, this, variableContext, context));
                continue block0;
            }
        }
        for (TypeMirror typeMirror : delegate.getInterfaces()) {
            if (!(typeMirror instanceof DeclaredType)) continue;
            DeclaredType declared = (DeclaredType)typeMirror;
            TypeElement typeElement = (TypeElement)declared.asElement();
            List<ResourceMethod> interfaceMethods = this.getResourceMethods(typeElement, variableContext.push(typeElement.getTypeParameters(), declared.getTypeArguments()), context);
            for (ResourceMethod interfaceMethod : interfaceMethods) {
                if (this.isOverridden((ExecutableElement)((Object)interfaceMethod), resourceMethods)) continue;
                resourceMethods.add(interfaceMethod);
            }
        }
        if (delegate.getKind() == ElementKind.CLASS && (superclass = delegate.getSuperclass()) instanceof DeclaredType && ((DeclaredType)superclass).asElement() != null) {
            DeclaredType declaredType = (DeclaredType)superclass;
            TypeElement element = (TypeElement)declaredType.asElement();
            List<ResourceMethod> list = this.getResourceMethods(element, variableContext.push(element.getTypeParameters(), declaredType.getTypeArguments()), context);
            for (ResourceMethod superMethod : list) {
                if (this.isOverridden((ExecutableElement)((Object)superMethod), resourceMethods)) continue;
                resourceMethods.add(superMethod);
            }
        }
        return resourceMethods;
    }

    protected Set<ResourceParameter> getResourceParameters(TypeElement delegate, EnunciateJaxrsContext context) {
        if (delegate == null || delegate.getQualifiedName().toString().equals(Object.class.getName())) {
            return Collections.emptySet();
        }
        TreeSet<ResourceParameter> resourceParameters = new TreeSet<ResourceParameter>();
        for (VariableElement field : ElementFilter.fieldsIn(delegate.getEnclosedElements())) {
            if (!ResourceParameter.isResourceParameter(field, this.context)) continue;
            resourceParameters.add(new ResourceParameter(field, this));
        }
        for (PropertyElement property : ((DecoratedTypeElement)delegate).getProperties()) {
            if (!ResourceParameter.isResourceParameter((Element)property, this.context)) continue;
            resourceParameters.add(new ResourceParameter((Element)property, this));
        }
        if (delegate.getKind() == ElementKind.CLASS && delegate.getSuperclass() instanceof DeclaredType) {
            Set<ResourceParameter> superParams = this.getResourceParameters((TypeElement)((DeclaredType)delegate.getSuperclass()).asElement(), context);
            for (ResourceParameter superParam : superParams) {
                if (this.isHidden(superParam, resourceParameters)) continue;
                resourceParameters.add(superParam);
            }
        }
        return resourceParameters;
    }

    protected boolean isOverridden(ExecutableElement method, ArrayList<? extends ExecutableElement> resourceMethods) {
        Elements decls = this.env.getElementUtils();
        for (ExecutableElement executableElement : resourceMethods) {
            if (!decls.overrides(executableElement, method, (TypeElement)executableElement.getEnclosingElement())) continue;
            return true;
        }
        return false;
    }

    private boolean isHidden(ResourceParameter param, Set<ResourceParameter> resourceParameters) {
        Elements decls = this.env.getElementUtils();
        for (ResourceParameter resourceParameter : resourceParameters) {
            if (!decls.hides((Element)((Object)resourceParameter), (Element)((Object)param))) continue;
            return true;
        }
        return false;
    }

    @Override
    public EnunciateJaxrsContext getContext() {
        return this.context;
    }

    protected static List<PathSegment> extractPathComponents(String path) {
        ArrayList<PathSegment> components = new ArrayList<PathSegment>();
        if (path != null) {
            int inBrace = 0;
            boolean definingRegexp = false;
            StringBuilder name = new StringBuilder();
            StringBuilder regexp = new StringBuilder();
            for (int i = 0; i < path.length(); ++i) {
                char ch = path.charAt(i);
                if (ch == '{') {
                    ++inBrace;
                } else if (ch == '}') {
                    if (--inBrace == 0) {
                        definingRegexp = false;
                    }
                } else if (inBrace == 1 && ch == ':') {
                    definingRegexp = true;
                    continue;
                }
                if (definingRegexp) {
                    regexp.append(ch);
                } else if (!Character.isWhitespace(ch) && ch != '/') {
                    name.append(ch);
                }
                if (i + 1 != path.length() && (ch != '/' || definingRegexp)) continue;
                String trimmed = name.toString().trim();
                if (!trimmed.isEmpty()) {
                    components.add(new PathSegment(trimmed, regexp.length() > 0 ? regexp.toString().trim() : null));
                }
                name = new StringBuilder();
                regexp = new StringBuilder();
            }
        }
        return components;
    }

    public final String getPath() {
        return this.path;
    }

    @Override
    public List<PathSegment> getPathComponents() {
        ArrayList<PathSegment> components = new ArrayList<PathSegment>();
        Resource parent = this.getParent();
        if (parent != null) {
            components.addAll(parent.getPathComponents());
        }
        components.addAll(this.pathComponents);
        return components;
    }

    public abstract Resource getParent();

    public Set<MediaType> getConsumesMediaTypes() {
        return this.consumesMime;
    }

    public Set<MediaType> getProducesMediaTypes() {
        return this.producesMime;
    }

    public Set<ResourceParameter> getResourceParameters() {
        return this.resourceParameters;
    }

    public List<ResourceMethod> getResourceMethods() {
        return this.resourceMethods;
    }

    public List<ResourceMethod> getResourceMethods(boolean loadDescendants) {
        if (!loadDescendants) {
            return this.resourceMethods;
        }
        ArrayList<ResourceMethod> resourceMethods = new ArrayList<ResourceMethod>();
        LinkedList<Resource> resources = new LinkedList<Resource>();
        TreeSet<String> visited = new TreeSet<String>();
        resources.add(this);
        while (!resources.isEmpty()) {
            Resource resource = (Resource)resources.pop();
            visited.add(resource.getQualifiedName().toString());
            resourceMethods.addAll(resource.getResourceMethods());
            for (SubResourceLocator locator : resource.getResourceLocators()) {
                SubResource subresource = locator.getResource();
                if (visited.contains(subresource.getQualifiedName().toString())) continue;
                resources.add(subresource);
            }
        }
        return resourceMethods;
    }

    public List<SubResourceLocator> getResourceLocators() {
        return this.resourceLocators;
    }

    public Set<Facet> getFacets() {
        return this.facets;
    }

    public Set<String> getSecurityRoles() {
        Resource parent;
        TreeSet<String> roles = new TreeSet<String>();
        RolesAllowed rolesAllowed = (RolesAllowed)this.getAnnotation(RolesAllowed.class);
        if (rolesAllowed != null) {
            Collections.addAll(roles, rolesAllowed.value());
        }
        if ((parent = this.getParent()) != null) {
            roles.addAll(parent.getSecurityRoles());
        }
        return roles;
    }
}

