/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs;

import com.webcohesion.enunciate.CompletionFailureException;
import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.ApiRegistry;
import com.webcohesion.enunciate.artifacts.Artifact;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.module.ApiFeatureProviderModule;
import com.webcohesion.enunciate.module.ApiRegistryProviderModule;
import com.webcohesion.enunciate.module.BasicProviderModule;
import com.webcohesion.enunciate.module.DependencySpec;
import com.webcohesion.enunciate.module.EnunciateModule;
import com.webcohesion.enunciate.module.MediaTypeDefinitionModule;
import com.webcohesion.enunciate.module.TypeDetectingModule;
import com.webcohesion.enunciate.modules.jaxrs.EnunciateJaxrsContext;
import com.webcohesion.enunciate.modules.jaxrs.JaxrsApiRegistry;
import com.webcohesion.enunciate.modules.jaxrs.JaxrsProviderClassListArtifact;
import com.webcohesion.enunciate.modules.jaxrs.JaxrsRootResourceClassListArtifact;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceEntityParameter;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceMethod;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceRepresentationMetadata;
import com.webcohesion.enunciate.modules.jaxrs.model.ResponseCode;
import com.webcohesion.enunciate.modules.jaxrs.model.RootResource;
import com.webcohesion.enunciate.modules.jaxrs.model.util.MediaType;
import com.webcohesion.enunciate.util.AnnotationUtils;
import com.webcohesion.enunciate.util.PathSortStrategy;
import jakarta.ws.rs.ApplicationPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javassist.bytecode.ClassFile;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;

public class JaxrsModule
extends BasicProviderModule
implements TypeDetectingModule,
ApiRegistryProviderModule,
ApiFeatureProviderModule {
    private ApiRegistryProviderModule.DataTypeDetectionStrategy defaultDataTypeDetectionStrategy;
    private final List<MediaTypeDefinitionModule> mediaTypeModules = new ArrayList<MediaTypeDefinitionModule>();
    private EnunciateJaxrsContext jaxrsContext;
    static final String NAME = "jaxrs";
    private PathSortStrategy defaultSortStrategy = PathSortStrategy.breadth_first;

    public String getName() {
        return NAME;
    }

    public List<DependencySpec> getDependencySpecifications() {
        return Collections.singletonList(new MediaTypeDependencySpec());
    }

    public ApiRegistryProviderModule.DataTypeDetectionStrategy getDataTypeDetectionStrategy() {
        String dataTypeDetection = this.config.getString("[@datatype-detection]", null);
        if (dataTypeDetection != null) {
            try {
                return ApiRegistryProviderModule.DataTypeDetectionStrategy.valueOf((String)dataTypeDetection);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.defaultDataTypeDetectionStrategy != null) {
            return this.defaultDataTypeDetectionStrategy;
        }
        if (this.enunciate.getIncludePatterns().isEmpty()) {
            return ApiRegistryProviderModule.DataTypeDetectionStrategy.local;
        }
        return ApiRegistryProviderModule.DataTypeDetectionStrategy.aggressive;
    }

    public void setDefaultDataTypeDetectionStrategy(ApiRegistryProviderModule.DataTypeDetectionStrategy strategy) {
        this.defaultDataTypeDetectionStrategy = strategy;
    }

    public PathSortStrategy getPathSortStrategy() {
        PathSortStrategy strategy = this.defaultSortStrategy;
        try {
            strategy = PathSortStrategy.valueOf((String)this.config.getString("[@path-sort-strategy]", this.defaultSortStrategy.name()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return strategy;
    }

    public boolean isDisableExamples() {
        return this.config.getBoolean("[@disableExamples]", false);
    }

    public void setDefaultSortStrategy(PathSortStrategy defaultSortStrategy) {
        this.defaultSortStrategy = defaultSortStrategy;
    }

    public EnunciateJaxrsContext getJaxrsContext() {
        return this.jaxrsContext;
    }

    public ApiRegistry getApiRegistry() {
        return new JaxrsApiRegistry(this.jaxrsContext);
    }

    public void call(EnunciateContext context) {
        this.jaxrsContext = new EnunciateJaxrsContext(context, this.isDisableExamples());
        ApiRegistryProviderModule.DataTypeDetectionStrategy detectionStrategy = this.getDataTypeDetectionStrategy();
        String relativeContextPath = "";
        if (detectionStrategy != ApiRegistryProviderModule.DataTypeDetectionStrategy.passive) {
            Set elements = detectionStrategy == ApiRegistryProviderModule.DataTypeDetectionStrategy.local ? context.getLocalApiElements() : context.getApiElements();
            for (Element declaration : elements) {
                LinkedList<Element> contextStack = new LinkedList<Element>();
                contextStack.push(declaration);
                try {
                    TypeElement element;
                    if (!(declaration instanceof TypeElement) || "org.glassfish.jersey.server.wadl.internal.WadlResource".equals((element = (TypeElement)declaration).getQualifiedName().toString()) || AnnotationUtils.isIgnored((Element)declaration)) continue;
                    Path pathInfo = declaration.getAnnotation(Path.class);
                    jakarta.ws.rs.Path pathInfo2 = declaration.getAnnotation(jakarta.ws.rs.Path.class);
                    if (pathInfo != null || pathInfo2 != null) {
                        RootResource rootResource = new RootResource(element, this.jaxrsContext);
                        this.jaxrsContext.add(rootResource);
                        for (ResourceMethod resourceMethod : rootResource.getResourceMethods(true)) {
                            this.addReferencedDataTypeDefinitions(resourceMethod, contextStack);
                        }
                    }
                    Provider providerInfo = declaration.getAnnotation(Provider.class);
                    jakarta.ws.rs.ext.Provider providerInfo2 = declaration.getAnnotation(jakarta.ws.rs.ext.Provider.class);
                    if (providerInfo != null || providerInfo2 != null) {
                        this.jaxrsContext.addJAXRSProvider(element);
                    }
                    javax.ws.rs.ApplicationPath applicationPathInfo = declaration.getAnnotation(javax.ws.rs.ApplicationPath.class);
                    ApplicationPath applicationPathInfo2 = declaration.getAnnotation(ApplicationPath.class);
                    if (applicationPathInfo == null && applicationPathInfo2 == null) continue;
                    relativeContextPath = applicationPathInfo != null ? applicationPathInfo.value() : applicationPathInfo2.value();
                }
                catch (RuntimeException e) {
                    if (e.getClass().getName().endsWith("CompletionFailure")) {
                        throw new CompletionFailureException(contextStack, (Throwable)e);
                    }
                    throw e;
                }
                finally {
                    contextStack.pop();
                }
            }
        }
        relativeContextPath = this.config.getString("application[@path]", relativeContextPath);
        relativeContextPath = JaxrsModule.sanitizeContextPath(relativeContextPath);
        this.jaxrsContext.setRelativeContextPath(relativeContextPath);
        this.jaxrsContext.setGroupingStrategy(this.getGroupingStrategy());
        this.jaxrsContext.setPathSortStrategy(this.getPathSortStrategy());
        if (this.jaxrsContext.getRootResources().size() > 0) {
            this.enunciate.addArtifact((Artifact)new JaxrsRootResourceClassListArtifact(this.jaxrsContext));
        }
        if (this.jaxrsContext.getProviders().size() > 0) {
            this.enunciate.addArtifact((Artifact)new JaxrsProviderClassListArtifact(this.jaxrsContext));
        }
    }

    public static String sanitizeContextPath(String relativeContextPath) {
        while (relativeContextPath.startsWith("/")) {
            relativeContextPath = relativeContextPath.substring(1);
        }
        while (relativeContextPath.endsWith("/")) {
            relativeContextPath = relativeContextPath.substring(0, relativeContextPath.length() - 1);
        }
        return relativeContextPath;
    }

    protected void addReferencedDataTypeDefinitions(ResourceMethod resourceMethod, LinkedList<Element> contextStack) {
        List<? extends ResponseCode> statusCodes;
        ResourceRepresentationMetadata outputPayload;
        if (AnnotationUtils.isIgnored((Element)((Object)resourceMethod))) {
            return;
        }
        ResourceEntityParameter ep = resourceMethod.getEntityParameter();
        if (ep != null) {
            Set<MediaType> consumesMt = resourceMethod.getConsumesMediaTypes();
            TreeSet<String> consumes = new TreeSet<String>();
            for (MediaType mediaType : consumesMt) {
                consumes.add(mediaType.getMediaType());
            }
            contextStack.push(ep.getDelegate());
            TypeMirror type = ep.getType();
            contextStack.push((Element)((Object)resourceMethod));
            try {
                for (MediaTypeDefinitionModule mediaTypeModule : this.mediaTypeModules) {
                    mediaTypeModule.addDataTypeDefinitions(type, consumes, contextStack);
                }
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException.getClass().getName().endsWith("CompletionFailure")) {
                    throw new CompletionFailureException(contextStack, (Throwable)runtimeException);
                }
                throw runtimeException;
            }
            finally {
                contextStack.pop();
            }
        }
        if ((outputPayload = resourceMethod.getRepresentationMetadata()) != null) {
            TypeMirror type = outputPayload.getDelegate();
            Set<MediaType> producesMt = resourceMethod.getProducesMediaTypes();
            TreeSet<String> treeSet = new TreeSet<String>();
            for (MediaType mediaType : producesMt) {
                treeSet.add(mediaType.getMediaType());
            }
            contextStack.push((Element)((Object)resourceMethod));
            try {
                for (MediaTypeDefinitionModule mediaTypeModule : this.mediaTypeModules) {
                    mediaTypeModule.addDataTypeDefinitions(type, treeSet, contextStack);
                }
            }
            catch (RuntimeException e) {
                if (e.getClass().getName().endsWith("CompletionFailure")) {
                    throw new CompletionFailureException(contextStack, (Throwable)e);
                }
                throw e;
            }
            finally {
                contextStack.pop();
            }
        }
        if ((statusCodes = resourceMethod.getStatusCodes()) != null) {
            for (ResponseCode responseCode : statusCodes) {
                DecoratedTypeMirror type = responseCode.getType();
                if (type == null) continue;
                Set<MediaType> producesMt = resourceMethod.getProducesMediaTypes();
                TreeSet<String> produces = new TreeSet<String>();
                for (MediaType mediaType : producesMt) {
                    produces.add(mediaType.getMediaType());
                }
                contextStack.push((Element)((Object)resourceMethod));
                try {
                    for (MediaTypeDefinitionModule mediaTypeModule : this.mediaTypeModules) {
                        mediaTypeModule.addDataTypeDefinitions((TypeMirror)type, produces, contextStack);
                    }
                }
                catch (RuntimeException e) {
                    if (e.getClass().getName().endsWith("CompletionFailure")) {
                        throw new CompletionFailureException(contextStack, (Throwable)e);
                    }
                    throw e;
                }
                finally {
                    contextStack.pop();
                }
            }
        }
    }

    public EnunciateJaxrsContext.GroupingStrategy getGroupingStrategy() {
        String groupBy = this.config.getString("[@groupBy]", "class");
        if ("class".equals(groupBy)) {
            return EnunciateJaxrsContext.GroupingStrategy.resource_class;
        }
        if ("path".equals(groupBy)) {
            return EnunciateJaxrsContext.GroupingStrategy.path;
        }
        if ("annotation".equals(groupBy)) {
            return EnunciateJaxrsContext.GroupingStrategy.annotation;
        }
        throw new EnunciateException("Unknown grouping strategy: " + groupBy);
    }

    public boolean internal(ClassFile classFile) {
        String classname = classFile.getName();
        return classname.startsWith("org.glassfish.jersey") || classname.startsWith("com.sun.jersey") || classname.startsWith("org.jboss.resteasy") || classname.startsWith("org.apache.cxf");
    }

    public boolean typeDetected(ClassFile classFile) {
        return this.annotationNames(classFile).anyMatch(classAnnotation -> Path.class.getName().equals(classAnnotation) || jakarta.ws.rs.Path.class.getName().equals(classAnnotation) || Provider.class.getName().equals(classAnnotation) || jakarta.ws.rs.ext.Provider.class.getName().equals(classAnnotation) || javax.ws.rs.ApplicationPath.class.getName().equals(classAnnotation) || ApplicationPath.class.getName().equals(classAnnotation));
    }

    public class MediaTypeDependencySpec
    implements DependencySpec {
        public boolean accept(EnunciateModule module) {
            if (module instanceof MediaTypeDefinitionModule) {
                MediaTypeDefinitionModule definitionModule = (MediaTypeDefinitionModule)module;
                JaxrsModule.this.mediaTypeModules.add(definitionModule);
                definitionModule.setDefaultDataTypeDetectionStrategy(ApiRegistryProviderModule.DataTypeDetectionStrategy.passive);
                return true;
            }
            return false;
        }

        public boolean isFulfilled() {
            return true;
        }

        public String toString() {
            return "media type definition modules";
        }
    }
}

