/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs.api.impl;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.Styles;
import com.webcohesion.enunciate.api.resources.Parameter;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceParameter;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceParameterConstraints;
import com.webcohesion.enunciate.util.AnnotationUtils;
import com.webcohesion.enunciate.util.BeanValidationUtils;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public class ParameterImpl
implements Parameter {
    private final ResourceParameter param;
    private final ApiRegistrationContext registrationContext;

    public ParameterImpl(ResourceParameter param, ApiRegistrationContext registrationContext) {
        this.param = param;
        this.registrationContext = registrationContext;
    }

    public String getName() {
        return this.param.getParameterName();
    }

    public String getDescription() {
        return this.param.getJavaDoc(this.registrationContext.getTagHandler()).toString();
    }

    public String getTypeLabel() {
        return this.param.getTypeName();
    }

    public String getTypeName() {
        return this.param.getDataType().name;
    }

    public String getTypeFormat() {
        String format = AnnotationUtils.getJsonStringFormat((Element)((Object)this.param));
        if (format == null) {
            format = this.param.getDataType().format;
        }
        return format;
    }

    public String getDefaultValue() {
        return this.param.getDefaultValue();
    }

    public String getConstraints() {
        String validationConstraints = BeanValidationUtils.describeConstraints((Element)((Object)this.param), (boolean)false, (boolean)false, (String)this.getDefaultValue(), (DecoratedProcessingEnvironment)this.param.getContext().getContext().getContext().getProcessingEnvironment());
        if (validationConstraints != null && !validationConstraints.isEmpty()) {
            return validationConstraints;
        }
        ResourceParameterConstraints constraints = this.param.getConstraints();
        if (constraints != null && constraints.getType() != null) {
            switch (constraints.getType()) {
                case ENUMERATION: {
                    StringBuilder builder = new StringBuilder();
                    Iterator<String> it = ((ResourceParameterConstraints.Enumeration)constraints).getValues().iterator();
                    while (it.hasNext()) {
                        String next = it.next();
                        builder.append('\"').append(next).append('\"');
                        if (!it.hasNext()) continue;
                        builder.append(" or ");
                    }
                    return builder.toString();
                }
                case PRIMITIVE: {
                    return ((ResourceParameterConstraints.Primitive)constraints).getKind().name().toLowerCase();
                }
                case REGEX: {
                    return "regex: " + ((ResourceParameterConstraints.Regex)constraints).getRegex();
                }
            }
        }
        return null;
    }

    public Set<String> getConstraintValues() {
        ResourceParameterConstraints constraints = this.param.getConstraints();
        if (constraints != null && constraints.getType() != null) {
            switch (constraints.getType()) {
                case UNBOUND_STRING: {
                    return null;
                }
                case ENUMERATION: {
                    return ((ResourceParameterConstraints.Enumeration)constraints).getValues();
                }
                case PRIMITIVE: {
                    return null;
                }
                case REGEX: {
                    return null;
                }
            }
        }
        return null;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)this.param.getAnnotation(annotationType);
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.param.getAnnotations();
    }

    public boolean isMultivalued() {
        return this.param.isMultivalued();
    }

    public JavaDoc getJavaDoc() {
        return this.param.getJavaDoc(this.registrationContext.getTagHandler());
    }

    public Set<String> getStyles() {
        return Styles.gatherStyles((Element)((Object)this.param), (Map)this.param.getContext().getContext().getContext().getConfiguration().getAnnotationStyles());
    }
}

