/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs.model;

import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedExecutableElement;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.javac.decorations.type.TypeVariableContext;
import com.webcohesion.enunciate.modules.jaxrs.EnunciateJaxrsContext;
import com.webcohesion.enunciate.modules.jaxrs.model.PathContext;
import com.webcohesion.enunciate.modules.jaxrs.model.PathSegment;
import com.webcohesion.enunciate.modules.jaxrs.model.Resource;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceParameter;
import com.webcohesion.enunciate.modules.jaxrs.model.SubResource;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class SubResourceLocator
extends DecoratedExecutableElement
implements PathContext {
    private String path;
    private final List<PathSegment> pathComponents;
    private final SubResource resource;
    private final Resource parent;
    private final List<ResourceParameter> resourceParameters;
    private final VariableElement entityParameter;
    private final EnunciateJaxrsContext context;

    public SubResourceLocator(ExecutableElement delegate, Resource parent, TypeVariableContext variableContext, EnunciateJaxrsContext context) {
        super(delegate, context.getContext().getProcessingEnvironment());
        SubResource resource;
        this.context = context;
        this.parent = parent;
        Path p = delegate.getAnnotation(Path.class);
        if (p != null) {
            this.path = p.value();
        }
        if (this.path == null) {
            throw new IllegalArgumentException("A subresource locator must specify a path with the @jakarta.ws.rs.Path annotation.");
        }
        this.pathComponents = Resource.extractPathComponents(this.path);
        TypeMirror returnType = delegate.getReturnType();
        if (returnType instanceof DeclaredType && ((DeclaredType)returnType).asElement() != null) {
            List<? extends TypeMirror> classTypes;
            TypeElement declaration = (TypeElement)((DeclaredType)returnType).asElement();
            resource = Class.class.getName().equals(declaration.getQualifiedName().toString()) ? ((classTypes = ((DeclaredType)returnType).getTypeArguments()) != null && classTypes.size() > 0 ? ((returnType = classTypes.get(0)) instanceof DeclaredType && ((DeclaredType)returnType).asElement() != null ? ((resource = this.findRecursiveSubResource(declaration = (TypeElement)((DeclaredType)returnType).asElement(), this.getPath())) == null ? new SubResource(declaration, this.getPath(), this, variableContext, context) : resource) : new SubResource((TypeElement)TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)context.getContext().getProcessingEnvironment()).asElement(), this.getPath(), this, variableContext, context)) : new SubResource((TypeElement)TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)context.getContext().getProcessingEnvironment()).asElement(), this.getPath(), this, variableContext, context)) : ((resource = this.findRecursiveSubResource(declaration, this.getPath())) == null ? new SubResource(declaration, this.getPath(), this, variableContext, context) : resource);
        } else {
            resource = new SubResource((TypeElement)TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)context.getContext().getProcessingEnvironment()).asElement(), this.getPath(), this, variableContext, context);
        }
        this.resource = resource;
        VariableElement entityParameter = null;
        ArrayList<ResourceParameter> resourceParameters = new ArrayList<ResourceParameter>();
        for (VariableElement variableElement : delegate.getParameters()) {
            if (ResourceParameter.isResourceParameter(variableElement, context)) {
                resourceParameters.add(new ResourceParameter(variableElement, this));
                continue;
            }
            entityParameter = variableElement;
        }
        this.entityParameter = entityParameter;
        this.resourceParameters = resourceParameters;
    }

    private SubResource findRecursiveSubResource(TypeElement declaration, String path) {
        LinkedList<SubResource> ancestorResources = SubResource.ANCESTOR_DECLARATIONS.get();
        for (SubResource ancestorResource : ancestorResources) {
            if (!ancestorResource.getQualifiedName().equals(declaration.getQualifiedName()) || !ancestorResource.getPath().equals(path)) continue;
            return ancestorResource;
        }
        return null;
    }

    @Override
    public List<PathSegment> getPathComponents() {
        ArrayList<PathSegment> components = new ArrayList<PathSegment>();
        Resource parent = this.getParent();
        if (parent != null) {
            components.addAll(parent.getPathComponents());
        }
        components.addAll(this.pathComponents);
        return components;
    }

    @Override
    public EnunciateJaxrsContext getContext() {
        return this.context;
    }

    public String getPath() {
        return this.path;
    }

    public SubResource getResource() {
        return this.resource;
    }

    public Resource getParent() {
        return this.parent;
    }

    public Set<ResourceParameter> getResourceParameters() {
        TreeSet<ResourceParameter> resourceParams = new TreeSet<ResourceParameter>(this.resourceParameters);
        resourceParams.addAll(this.getParent().getResourceParameters());
        return resourceParams;
    }

    public VariableElement getEntityParameter() {
        return this.entityParameter;
    }
}

