/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxws.model;

import com.webcohesion.enunciate.modules.jaxb.model.ImplicitChildElement;
import com.webcohesion.enunciate.modules.jaxb.model.ImplicitRootElement;
import com.webcohesion.enunciate.modules.jaxws.model.WebMessage;
import com.webcohesion.enunciate.modules.jaxws.model.WebMessagePart;
import com.webcohesion.enunciate.modules.jaxws.model.WebMethod;
import com.webcohesion.enunciate.modules.jaxws.model.WebParam;
import com.webcohesion.enunciate.modules.jaxws.model.WebResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.lang.model.type.TypeKind;
import javax.xml.namespace.QName;

public class ResponseWrapper
implements WebMessage,
WebMessagePart,
ImplicitRootElement {
    private WebMethod webMethod;

    public ResponseWrapper(WebMethod webMethod) {
        this.webMethod = webMethod;
    }

    @Override
    public WebMethod getWebMethod() {
        return this.webMethod;
    }

    public String getResponseBeanName() {
        Object capitalizedName = this.webMethod.getSimpleName().toString();
        capitalizedName = Character.toString(((String)capitalizedName).charAt(0)).toUpperCase() + ((String)capitalizedName).substring(1);
        Object responseBeanName = this.webMethod.getDeclaringEndpointInterface().getPackage().getQualifiedName() + ".jaxws." + (String)capitalizedName + "Response";
        javax.xml.ws.ResponseWrapper annotation = (javax.xml.ws.ResponseWrapper)this.webMethod.getAnnotation(javax.xml.ws.ResponseWrapper.class);
        if (annotation != null && annotation.className() != null && !"".equals(annotation.className())) {
            responseBeanName = annotation.className();
        }
        return responseBeanName;
    }

    public String getElementName() {
        Object name = this.webMethod.getOperationName() + "Response";
        javax.xml.ws.ResponseWrapper annotation = (javax.xml.ws.ResponseWrapper)this.webMethod.getAnnotation(javax.xml.ws.ResponseWrapper.class);
        if (annotation != null && annotation.localName() != null && !"".equals(annotation.localName())) {
            name = annotation.localName();
        }
        return name;
    }

    public String getTargetNamespace() {
        return this.getElementNamespace();
    }

    public String getElementNamespace() {
        String namespace = this.webMethod.getDeclaringEndpointInterface().getTargetNamespace();
        javax.xml.ws.ResponseWrapper annotation = (javax.xml.ws.ResponseWrapper)this.webMethod.getAnnotation(javax.xml.ws.ResponseWrapper.class);
        if (annotation != null && annotation.targetNamespace() != null && !"".equals(annotation.targetNamespace())) {
            namespace = annotation.targetNamespace();
        }
        return namespace;
    }

    public String getElementDocs() {
        String docs = "doc/lit response wrapper for operation \"" + this.webMethod.getOperationName() + "\".";
        String methodDocs = this.webMethod.getJavaDoc().toString();
        if (methodDocs.trim().length() > 0) {
            docs = docs + " (" + methodDocs.trim() + ")";
        }
        return docs;
    }

    @Override
    public WebMessagePart.ParticleType getParticleType() {
        return WebMessagePart.ParticleType.ELEMENT;
    }

    @Override
    public QName getParticleQName() {
        return new QName(this.getElementNamespace(), this.getElementName());
    }

    @Override
    public boolean isImplicitSchemaElement() {
        return true;
    }

    public QName getTypeQName() {
        return null;
    }

    public Collection<ImplicitChildElement> getChildElements() {
        WebResult webResult;
        ArrayList<ImplicitChildElement> childElements = new ArrayList<ImplicitChildElement>();
        if (this.webMethod.getReturnType().getKind() != TypeKind.VOID && !(webResult = this.webMethod.getWebResult()).isHeader()) {
            childElements.add(webResult);
        }
        for (WebParam webParam : this.webMethod.getWebParameters()) {
            if (!webParam.isOutput() || webParam.isHeader()) continue;
            childElements.add(webParam);
        }
        return childElements;
    }

    @Override
    public Collection<WebMessagePart> getParts() {
        return new ArrayList<WebMessagePart>(Arrays.asList(this));
    }

    @Override
    public boolean isInput() {
        return false;
    }

    @Override
    public boolean isOutput() {
        return true;
    }

    @Override
    public boolean isHeader() {
        return false;
    }

    @Override
    public boolean isFault() {
        return false;
    }

    @Override
    public String getMessageName() {
        return this.webMethod.getDeclaringEndpointInterface().getSimpleName() + "." + this.webMethod.getSimpleName() + "Response";
    }

    @Override
    public String getMessageDocs() {
        String docs = "response message for operation \"" + this.webMethod.getOperationName() + "\".";
        String methodDocs = this.webMethod.getJavaDoc().toString();
        if (methodDocs.trim().length() > 0) {
            docs = docs + " (" + methodDocs.trim() + ")";
        }
        return docs;
    }

    @Override
    public String getPartDocs() {
        return null;
    }

    @Override
    public String getPartName() {
        return "parameters";
    }
}

