/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxws.model;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedExecutableElement;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeVariableContext;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.metadata.ClientName;
import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.model.util.MapType;
import com.webcohesion.enunciate.modules.jaxws.EnunciateJaxwsContext;
import com.webcohesion.enunciate.modules.jaxws.model.EndpointInterface;
import com.webcohesion.enunciate.modules.jaxws.model.HttpHeader;
import com.webcohesion.enunciate.modules.jaxws.model.RPCInputMessage;
import com.webcohesion.enunciate.modules.jaxws.model.RPCOutputMessage;
import com.webcohesion.enunciate.modules.jaxws.model.RequestWrapper;
import com.webcohesion.enunciate.modules.jaxws.model.ResponseWrapper;
import com.webcohesion.enunciate.modules.jaxws.model.WebFault;
import com.webcohesion.enunciate.modules.jaxws.model.WebMessage;
import com.webcohesion.enunciate.modules.jaxws.model.WebMessagePart;
import com.webcohesion.enunciate.modules.jaxws.model.WebParam;
import com.webcohesion.enunciate.modules.jaxws.model.WebResult;
import com.webcohesion.enunciate.util.AnnotationUtils;
import jakarta.jws.Oneway;
import jakarta.jws.soap.SOAPBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class WebMethod
extends DecoratedExecutableElement
implements Comparable<WebMethod>,
HasFacets {
    private final jakarta.jws.WebMethod annotation;
    private final boolean oneWay;
    private final EndpointInterface endpointInterface;
    private final DecoratedTypeMirror returnType;
    private final WebResult webResult;
    private final Collection<WebParam> webParams;
    private final Collection<WebFault> webFaults;
    private final Collection<WebMessage> messages;
    private final RequestWrapper requestWrapper;
    private final ResponseWrapper responseWrapper;
    private final Set<Facet> facets = new TreeSet<Facet>();
    private final EnunciateJaxwsContext context;

    public WebMethod(ExecutableElement delegate, EndpointInterface endpointInterface, EnunciateJaxwsContext context, TypeVariableContext variableContext) {
        super(delegate, context.getContext().getProcessingEnvironment());
        this.context = context;
        TypeMirror type = variableContext.resolveTypeVariables(super.getReturnType(), (ProcessingEnvironment)this.env);
        MapType mapType = MapType.findMapType((TypeMirror)type, (EnunciateJaxbContext)this.context.getJaxbContext());
        if (mapType != null) {
            type = mapType;
        }
        this.returnType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)type, (DecoratedProcessingEnvironment)this.env);
        this.annotation = (jakarta.jws.WebMethod)this.getAnnotation(jakarta.jws.WebMethod.class);
        this.oneWay = this.getAnnotation(Oneway.class) != null;
        this.endpointInterface = endpointInterface;
        this.webResult = new WebResult((TypeMirror)this.getReturnType(), this, context);
        List parameters = this.getParameters();
        ArrayList<WebParam> webParameters = new ArrayList<WebParam>(parameters.size());
        int parameterIndex = 0;
        for (Object parameter : parameters) {
            webParameters.add(new WebParam((VariableElement)parameter, this, parameterIndex++, context, variableContext));
        }
        this.webParams = webParameters;
        ArrayList<WebFault> webFaults = new ArrayList<WebFault>();
        for (TypeMirror referenceType : this.getThrownTypes()) {
            if (!(referenceType instanceof DeclaredType)) {
                throw new EnunciateException("Method " + this.getSimpleName() + " of " + endpointInterface.getQualifiedName() + ": Thrown type must be a declared type.");
            }
            TypeElement declaration = (TypeElement)((DeclaredType)referenceType).asElement();
            if (declaration == null) {
                throw new EnunciateException("Method " + this.getSimpleName() + " of " + endpointInterface.getQualifiedName() + ": unknown declaration for " + referenceType);
            }
            if (declaration.getQualifiedName().toString().startsWith("java.")) continue;
            webFaults.add(new WebFault(declaration, (DecoratedTypeMirror)referenceType, context));
        }
        this.webFaults = webFaults;
        ArrayList<WebMessage> messages = new ArrayList<WebMessage>();
        SOAPBinding.Style bindingStyle = this.getSoapBindingStyle();
        for (WebParam webParam : webParameters) {
            if (!webParam.isHeader()) continue;
            messages.add(webParam);
        }
        if (this.webResult.isHeader()) {
            messages.add(this.webResult);
        }
        RequestWrapper requestWrapper = null;
        ResponseWrapper responseWrapper = null;
        if (bindingStyle == SOAPBinding.Style.DOCUMENT) {
            SOAPBinding.ParameterStyle parameterStyle = this.getSoapParameterStyle();
            if (parameterStyle == SOAPBinding.ParameterStyle.WRAPPED) {
                requestWrapper = new RequestWrapper(this);
                messages.add(requestWrapper);
                if (!this.isOneWay()) {
                    responseWrapper = new ResponseWrapper(this);
                    messages.add(responseWrapper);
                }
                messages.addAll(webFaults);
            } else {
                for (WebParam webParam : webParameters) {
                    if (webParam.isHeader()) continue;
                    messages.add(webParam);
                }
                if (!this.isOneWay() && this.getReturnType().getKind() != TypeKind.VOID && !this.webResult.isHeader()) {
                    messages.add(this.webResult);
                }
                messages.addAll(webFaults);
            }
        } else {
            messages.add(new RPCInputMessage(this));
            messages.add(new RPCOutputMessage(this));
            messages.addAll(webFaults);
        }
        this.messages = messages;
        this.requestWrapper = requestWrapper;
        this.responseWrapper = responseWrapper;
        this.facets.addAll(Facet.gatherFacets((Element)delegate, (EnunciateContext)context.getContext()));
        this.facets.addAll(endpointInterface.getFacets());
    }

    public EnunciateJaxwsContext getContext() {
        return this.context;
    }

    public String getClientSimpleName() {
        String clientSimpleName = this.getSimpleName().toString();
        ClientName clientName = (ClientName)this.getAnnotation(ClientName.class);
        if (clientName != null) {
            clientSimpleName = clientName.value();
        }
        return clientSimpleName;
    }

    public DecoratedTypeMirror getReturnType() {
        return this.returnType;
    }

    public WebResult getWebResult() {
        return this.webResult;
    }

    public Collection<WebParam> getWebParameters() {
        return this.webParams;
    }

    public Collection<WebFault> getWebFaults() {
        return this.webFaults;
    }

    public Collection<HttpHeader> getHttpRequestHeaders() {
        ArrayList<HttpHeader> extraParameters = new ArrayList<HttpHeader>();
        JavaDoc localDoc = new JavaDoc(this.getDocComment(), null, null, this.env);
        JavaDoc.JavaDocTagList doclets = (JavaDoc.JavaDocTagList)localDoc.get((Object)"RequestHeader");
        if (doclets != null) {
            for (Object doclet : doclets) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                Object header = firstspace > 0 ? ((String)doclet).substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < ((String)doclet).length() ? ((String)doclet).substring(firstspace + 1) : "";
                extraParameters.add(new HttpHeader((String)header, doc));
            }
        }
        List inheritedDoclets = AnnotationUtils.getJavaDocTags((String)"RequestHeader", (Element)((Object)this.getDeclaringEndpointInterface()));
        for (JavaDoc.JavaDocTagList inheritedDoclet : inheritedDoclets) {
            for (String doclet : inheritedDoclet) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                String header = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                extraParameters.add(new HttpHeader(header, doc));
            }
        }
        RequestHeaders requestHeaders = (RequestHeaders)this.getAnnotation(RequestHeaders.class);
        if (requestHeaders != null) {
            for (RequestHeader header : requestHeaders.value()) {
                extraParameters.add(new HttpHeader(header.name(), header.description()));
            }
        }
        List inheritedRequestHeaders = AnnotationUtils.getAnnotations(RequestHeaders.class, (Element)((Object)this.getDeclaringEndpointInterface()), (boolean)true);
        for (RequestHeaders inheritedRequestHeader : inheritedRequestHeaders) {
            for (RequestHeader header : inheritedRequestHeader.value()) {
                extraParameters.add(new HttpHeader(header.name(), header.description()));
            }
        }
        return extraParameters;
    }

    public Collection<WebMessage> getMessages() {
        return this.messages;
    }

    public Collection<WebMessage> getInputMessages() {
        ArrayList<WebMessage> inputMessages = new ArrayList<WebMessage>();
        for (WebMessage message : this.getMessages()) {
            if (!message.isInput()) continue;
            inputMessages.add(message);
        }
        return inputMessages;
    }

    public Collection<WebMessage> getOutputMessages() {
        ArrayList<WebMessage> outputMessages = new ArrayList<WebMessage>();
        for (WebMessage message : this.getMessages()) {
            if (!message.isOutput()) continue;
            outputMessages.add(message);
        }
        return outputMessages;
    }

    public RequestWrapper getRequestWrapper() {
        return this.requestWrapper;
    }

    public ResponseWrapper getResponseWrapper() {
        return this.responseWrapper;
    }

    public Set<String> getReferencedNamespaces() {
        HashSet<String> namespaces = new HashSet<String>();
        Collection<WebMessage> messages = this.getMessages();
        for (WebMessage message : messages) {
            for (WebMessagePart part : message.getParts()) {
                if (!part.isImplicitSchemaElement()) continue;
                namespaces.add(part.getParticleQName().getNamespaceURI());
            }
        }
        return namespaces;
    }

    public String getOperationName() {
        String operationName = this.getSimpleName().toString();
        if (this.annotation != null && !"".equals(this.annotation.operationName())) {
            return this.annotation.operationName();
        }
        return operationName;
    }

    public String getAction() {
        String action = "";
        if (this.annotation != null) {
            action = this.annotation.action();
        }
        return action;
    }

    public boolean isOneWay() {
        return this.oneWay;
    }

    public SOAPBinding.Style getSoapBindingStyle() {
        SOAPBinding.Style style = this.getDeclaringEndpointInterface().getSoapBindingStyle();
        SOAPBinding bindingInfo = (SOAPBinding)this.getAnnotation(SOAPBinding.class);
        if (bindingInfo != null) {
            style = bindingInfo.style();
        }
        return style;
    }

    public EndpointInterface getDeclaringEndpointInterface() {
        return this.endpointInterface;
    }

    public SOAPBinding.Use getSoapUse() {
        SOAPBinding.Use use = this.getDeclaringEndpointInterface().getSoapUse();
        SOAPBinding bindingInfo = (SOAPBinding)this.getAnnotation(SOAPBinding.class);
        if (bindingInfo != null) {
            use = bindingInfo.use();
        }
        return use;
    }

    public SOAPBinding.ParameterStyle getSoapParameterStyle() {
        SOAPBinding.ParameterStyle style = this.getDeclaringEndpointInterface().getSoapParameterStyle();
        SOAPBinding bindingInfo = (SOAPBinding)this.getAnnotation(SOAPBinding.class);
        if (bindingInfo != null) {
            style = bindingInfo.parameterStyle();
        }
        return style;
    }

    public boolean isDocLitWrapped() {
        return this.getSoapBindingStyle() == SOAPBinding.Style.DOCUMENT && this.getSoapUse() == SOAPBinding.Use.LITERAL && this.getSoapParameterStyle() == SOAPBinding.ParameterStyle.WRAPPED;
    }

    @Override
    public int compareTo(WebMethod webMethod) {
        return this.getOperationName().compareTo(webMethod.getOperationName());
    }

    public Set<Facet> getFacets() {
        return this.facets;
    }
}

