/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.api.impl;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.datatype.CustomMediaTypeDescriptor;
import com.webcohesion.enunciate.api.resources.Example;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.metadata.DocumentationExample;
import com.webcohesion.enunciate.modules.spring_web.api.impl.RequestEntityImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.ResponseEntityImpl;
import com.webcohesion.enunciate.modules.spring_web.model.RequestMapping;
import com.webcohesion.enunciate.modules.spring_web.model.RequestParameter;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceEntityParameter;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceRepresentationMetadata;
import com.webcohesion.enunciate.modules.spring_web.model.ResponseCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpStatus;

public class MethodExampleImpl
implements Example {
    private final String httpMethod;
    private final RequestMapping resourceMethod;
    private final MediaTypeDescriptor requestDescriptor;
    private final MediaTypeDescriptor responseDescriptor;

    public MethodExampleImpl(String httpMethod, RequestMapping resourceMethod, ApiRegistrationContext registrationContext) {
        this.httpMethod = httpMethod;
        this.resourceMethod = resourceMethod;
        CustomMediaTypeDescriptor requestDescriptor = null;
        ResourceEntityParameter entityParameter = this.resourceMethod.getEntityParameter();
        if (entityParameter != null) {
            RequestEntityImpl entity = new RequestEntityImpl(this.resourceMethod, entityParameter, registrationContext);
            List<? extends MediaTypeDescriptor> mediaTypes = entity.getMediaTypes();
            Collections.sort(mediaTypes, new Comparator<MediaTypeDescriptor>(){

                @Override
                public int compare(MediaTypeDescriptor d1, MediaTypeDescriptor d2) {
                    return new Float(d2.getQualityOfSourceFactor()).compareTo(Float.valueOf(d1.getQualityOfSourceFactor()));
                }
            });
            MediaTypeDescriptor mediaTypeDescriptor = requestDescriptor = mediaTypes.isEmpty() ? null : mediaTypes.get(0);
        }
        if (requestDescriptor == null) {
            ArrayList<String> consumes = new ArrayList<String>();
            consumes.addAll(this.resourceMethod.getConsumesMediaTypes());
            requestDescriptor = consumes.isEmpty() ? null : new CustomMediaTypeDescriptor((String)consumes.get(0));
        }
        this.requestDescriptor = requestDescriptor;
        MediaTypeDescriptor responseDescriptor = null;
        ResourceRepresentationMetadata representationMetadata = this.resourceMethod.getRepresentationMetadata();
        if (representationMetadata != null) {
            ResponseEntityImpl entity = new ResponseEntityImpl(this.resourceMethod, representationMetadata, registrationContext);
            List<? extends MediaTypeDescriptor> mediaTypes = entity.getMediaTypes();
            Collections.sort(mediaTypes, new Comparator<MediaTypeDescriptor>(){

                @Override
                public int compare(MediaTypeDescriptor d1, MediaTypeDescriptor d2) {
                    return new Float(d2.getQualityOfSourceFactor()).compareTo(Float.valueOf(d1.getQualityOfSourceFactor()));
                }
            });
            responseDescriptor = mediaTypes.isEmpty() ? null : mediaTypes.get(0);
        }
        this.responseDescriptor = responseDescriptor;
    }

    public String getRequestLang() {
        if (this.requestDescriptor == null) {
            return null;
        }
        String lang = "txt";
        com.webcohesion.enunciate.api.datatype.Example example = this.requestDescriptor.getExample();
        if (example != null) {
            lang = example.getLang();
        }
        return lang;
    }

    public String getRequestHeaders() {
        String contextPath = this.resourceMethod.getContext().getRelativeContextPath();
        if (!StringUtils.isEmpty((String)contextPath)) {
            contextPath = "/" + contextPath;
        }
        String fullpath = contextPath + this.resourceMethod.getFullpath();
        JavaDoc.JavaDocTagList pathExample = (JavaDoc.JavaDocTagList)this.resourceMethod.getJavaDoc().get((Object)"pathExample");
        if (pathExample != null && !pathExample.isEmpty()) {
            fullpath = (String)pathExample.get(0);
        }
        StringBuilder builder = new StringBuilder(this.httpMethod).append(' ').append(fullpath).append("\n");
        if (this.requestDescriptor != null) {
            builder.append("Content-Type: ").append(this.requestDescriptor.getMediaType()).append("\n");
        }
        if (this.responseDescriptor != null) {
            builder.append("Accept: ").append(this.responseDescriptor.getMediaType()).append("\n");
        }
        Set<RequestParameter> resourceParameters = this.resourceMethod.getRequestParameters();
        for (RequestParameter resourceParameter : resourceParameters) {
            if (!"header".equalsIgnoreCase(resourceParameter.getTypeName()) || "content-type".equalsIgnoreCase(resourceParameter.getParameterName()) && this.requestDescriptor != null || "accept".equalsIgnoreCase(resourceParameter.getParameterName()) && this.responseDescriptor != null) continue;
            String exampleValue = resourceParameter.getDefaultValue() != null ? resourceParameter.getDefaultValue() : "...";
            DocumentationExample documentationExample = (DocumentationExample)resourceParameter.getAnnotation(DocumentationExample.class);
            if (documentationExample != null) {
                if (documentationExample.exclude()) continue;
                exampleValue = documentationExample.value();
            }
            builder.append(resourceParameter.getParameterName()).append(": ").append(exampleValue).append('\n');
        }
        return builder.toString();
    }

    public String getRequestBody() {
        if (this.requestDescriptor == null) {
            return null;
        }
        String body = "...";
        com.webcohesion.enunciate.api.datatype.Example example = this.requestDescriptor.getExample();
        if (example != null) {
            body = example.getBody();
        }
        return body;
    }

    public String getResponseLang() {
        if (this.responseDescriptor == null) {
            return null;
        }
        String lang = "txt";
        com.webcohesion.enunciate.api.datatype.Example example = this.responseDescriptor.getExample();
        if (example != null) {
            lang = example.getLang();
        }
        return lang;
    }

    public String getResponseHeaders() {
        String message;
        int responseCode = "POST".equalsIgnoreCase(this.httpMethod) ? 201 : ("PUT".equalsIgnoreCase(this.httpMethod) ? 204 : ("DELETE".equalsIgnoreCase(this.httpMethod) ? 204 : 200));
        List<? extends ResponseCode> statusCodes = this.resourceMethod.getStatusCodes();
        if (statusCodes != null && !statusCodes.isEmpty()) {
            for (ResponseCode responseCode2 : statusCodes) {
                if (responseCode2.getCode() < 200 || responseCode2.getCode() >= 400) continue;
                responseCode = responseCode2.getCode();
                break;
            }
        }
        try {
            message = HttpStatus.valueOf((int)responseCode).getReasonPhrase();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            message = "Custom Message";
        }
        StringBuilder stringBuilder = new StringBuilder("HTTP/1.1 ").append(responseCode).append(' ').append(message).append("\n");
        if (this.responseDescriptor != null) {
            stringBuilder.append("Content-Type: ").append(this.responseDescriptor.getMediaType()).append("\n");
        }
        for (String responseHeader : this.resourceMethod.getResponseHeaders().keySet()) {
            if ("content-type".equalsIgnoreCase(responseHeader) && this.responseDescriptor != null) continue;
            stringBuilder.append(responseHeader).append(": ").append("...").append("\n");
        }
        return stringBuilder.toString();
    }

    public String getResponseBody() {
        if (this.responseDescriptor == null) {
            return null;
        }
        String body = "...";
        com.webcohesion.enunciate.api.datatype.Example example = this.responseDescriptor.getExample();
        if (example != null) {
            body = example.getBody();
        }
        return body;
    }
}

