/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.api.impl;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.datatype.BaseType;
import com.webcohesion.enunciate.api.datatype.CustomDataTypeReference;
import com.webcohesion.enunciate.api.datatype.CustomMediaTypeDescriptor;
import com.webcohesion.enunciate.api.datatype.CustomSyntax;
import com.webcohesion.enunciate.api.datatype.DataType;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Example;
import com.webcohesion.enunciate.api.datatype.Syntax;
import com.webcohesion.enunciate.api.resources.Entity;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.metadata.DocumentationExample;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import com.webcohesion.enunciate.modules.spring_web.api.impl.MediaTypeDescriptorImpl;
import com.webcohesion.enunciate.modules.spring_web.model.RequestMapping;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceRepresentationMetadata;
import com.webcohesion.enunciate.util.ExampleUtils;
import com.webcohesion.enunciate.util.TypeHintUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class ResponseEntityImpl
implements Entity {
    private RequestMapping requestMapping;
    private ResourceRepresentationMetadata responseMetadata;
    private final ApiRegistrationContext registrationContext;

    public ResponseEntityImpl(RequestMapping requestMapping, ResourceRepresentationMetadata responseMetadata, ApiRegistrationContext registrationContext) {
        this.requestMapping = requestMapping;
        this.responseMetadata = responseMetadata;
        this.registrationContext = registrationContext;
    }

    public String getDescription() {
        return this.responseMetadata.getDocValue(this.registrationContext.getTagHandler());
    }

    public List<? extends MediaTypeDescriptor> getMediaTypes() {
        Set<String> produces = this.requestMapping.getProducesMediaTypes();
        ArrayList<MediaTypeDescriptorImpl> mts = new ArrayList<MediaTypeDescriptorImpl>(produces.size());
        for (String mt : produces) {
            Syntax syntax2;
            boolean descriptorFound = false;
            DecoratedTypeMirror type = (DecoratedTypeMirror)this.responseMetadata.getDelegate();
            for (Syntax syntax2 : this.requestMapping.getContext().getContext().getApiRegistry().getSyntaxes(this.registrationContext)) {
                MediaTypeDescriptor descriptor = syntax2.findMediaTypeDescriptor(mt, type);
                if (descriptor == null) continue;
                mts.add(new MediaTypeDescriptorImpl(descriptor, this.loadExample(syntax2, descriptor)));
                descriptorFound = true;
            }
            if (descriptorFound) continue;
            CustomMediaTypeDescriptor descriptor = new CustomMediaTypeDescriptor(mt);
            descriptor.setDataType((DataTypeReference)new CustomDataTypeReference(BaseType.fromType((TypeMirror)this.responseMetadata.getDelegate())));
            syntax2 = new CustomSyntax(descriptor);
            descriptor.setExample(this.loadExample(syntax2, (MediaTypeDescriptor)descriptor));
            mts.add((MediaTypeDescriptorImpl)descriptor);
        }
        return mts;
    }

    protected Example loadExample(Syntax syntax, MediaTypeDescriptor descriptor) {
        Example example = ExampleUtils.loadCustomExample((Syntax)syntax, (String)"responseExample", (DecoratedElement)this.requestMapping, (EnunciateContext)this.requestMapping.getContext().getContext());
        if (example == null) {
            List dataTypes;
            Element element;
            TypeMirror typeHint;
            DocumentationExample documentationExample;
            String tag;
            example = descriptor.getExample();
            JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.requestMapping.getJavaDoc().get((Object)"documentationType");
            if (tags != null && tags.size() > 0 && !(tag = ((String)tags.get(0)).trim()).isEmpty()) {
                TypeElement typeElement = this.requestMapping.getContext().getContext().getProcessingEnvironment().getElementUtils().getTypeElement(tag);
                if (typeElement != null) {
                    List dataTypes2 = syntax.findDataTypes(typeElement.getQualifiedName().toString());
                    if (dataTypes2 != null && !dataTypes2.isEmpty()) {
                        example = ((DataType)dataTypes2.get(0)).getExample();
                    }
                } else {
                    this.requestMapping.getContext().getContext().getLogger().warn("Invalid documentation type %s.", new Object[]{tag});
                }
            }
            if ((documentationExample = (DocumentationExample)this.requestMapping.getAnnotation(DocumentationExample.class)) != null && (typeHint = TypeHintUtils.getTypeHint((TypeHint)documentationExample.type(), (DecoratedProcessingEnvironment)this.requestMapping.getContext().getContext().getProcessingEnvironment(), null)) instanceof DeclaredType && (element = ((DeclaredType)typeHint).asElement()) instanceof TypeElement && (dataTypes = syntax.findDataTypes(((TypeElement)element).getQualifiedName().toString())) != null && !dataTypes.isEmpty()) {
                example = ((DataType)dataTypes.get(0)).getExample();
            }
        }
        return example;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return null;
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return Collections.emptyMap();
    }

    public JavaDoc getJavaDoc() {
        return JavaDoc.EMPTY;
    }

    public boolean isRequired() {
        return true;
    }
}

