/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.InterfaceDescriptionFile;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.TypeElementComparator;
import com.webcohesion.enunciate.module.EnunciateModuleContext;
import com.webcohesion.enunciate.modules.spring_web.api.impl.AnnotationBasedResourceGroupImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.PathBasedResourceGroupImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.ResourceClassResourceGroupImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.ResourceImpl;
import com.webcohesion.enunciate.modules.spring_web.model.RequestMapping;
import com.webcohesion.enunciate.modules.spring_web.model.SpringController;
import com.webcohesion.enunciate.modules.spring_web.model.SpringControllerAdvice;
import com.webcohesion.enunciate.util.AnnotationUtils;
import com.webcohesion.enunciate.util.PathSortStrategy;
import com.webcohesion.enunciate.util.ResourceComparator;
import com.webcohesion.enunciate.util.ResourceGroupComparator;
import com.webcohesion.enunciate.util.SortedList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;

public class EnunciateSpringWebContext
extends EnunciateModuleContext {
    private final Set<SpringController> controllers;
    private final Set<SpringControllerAdvice> advice;
    private String relativeContextPath = "";
    private GroupingStrategy groupingStrategy = GroupingStrategy.resource_class;
    private InterfaceDescriptionFile wadlFile = null;
    private PathSortStrategy pathSortStrategy = PathSortStrategy.breadth_first;
    private final boolean disableExamples;

    public EnunciateSpringWebContext(EnunciateContext context, boolean disableExamples) {
        super(context);
        this.disableExamples = disableExamples;
        this.controllers = new TreeSet<SpringController>((Comparator<SpringController>)new TypeElementComparator());
        this.advice = new TreeSet<SpringControllerAdvice>((Comparator<SpringControllerAdvice>)new TypeElementComparator());
    }

    public EnunciateContext getContext() {
        return this.context;
    }

    public Set<SpringController> getControllers() {
        return this.controllers;
    }

    public Set<SpringControllerAdvice> getAdvice() {
        return this.advice;
    }

    public void add(SpringController controller) {
        this.controllers.add(controller);
        this.debug("Added %s as a Spring controller.", new Object[]{controller.getQualifiedName()});
    }

    public void add(SpringControllerAdvice advice) {
        this.advice.add(advice);
        this.debug("Added %s as Spring controller advice.", new Object[]{advice.getQualifiedName()});
    }

    public boolean isIncludeResourceGroupName() {
        return this.groupingStrategy != GroupingStrategy.path;
    }

    public boolean isDisableExamples() {
        return this.disableExamples;
    }

    public String getRelativeContextPath() {
        return this.relativeContextPath;
    }

    public void setRelativeContextPath(String relativeContextPath) {
        this.relativeContextPath = relativeContextPath;
    }

    public void setGroupingStrategy(GroupingStrategy groupingStrategy) {
        this.groupingStrategy = groupingStrategy;
    }

    public PathSortStrategy getPathSortStrategy() {
        return this.pathSortStrategy;
    }

    public void setPathSortStrategy(PathSortStrategy pathSortStrategy) {
        this.pathSortStrategy = pathSortStrategy;
    }

    public InterfaceDescriptionFile getWadlFile() {
        return this.wadlFile;
    }

    public void setWadlFile(InterfaceDescriptionFile wadlFile) {
        this.wadlFile = wadlFile;
    }

    public List<ResourceGroup> getResourceGroups(ApiRegistrationContext registrationContext) {
        List<ResourceGroup> resourceGroups = this.groupingStrategy == GroupingStrategy.path ? this.getResourceGroupsByPath(registrationContext) : (this.groupingStrategy == GroupingStrategy.annotation ? this.getResourceGroupsByAnnotation(registrationContext) : this.getResourceGroupsByClass(registrationContext));
        Collections.sort(resourceGroups, new Comparator<ResourceGroup>(){

            @Override
            public int compare(ResourceGroup o1, ResourceGroup o2) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
        });
        return resourceGroups;
    }

    public List<ResourceGroup> getResourceGroupsByClass(ApiRegistrationContext registrationContext) {
        ArrayList<ResourceGroup> resourceGroups = new ArrayList<ResourceGroup>();
        TreeSet<String> slugs = new TreeSet<String>();
        FacetFilter facetFilter = registrationContext.getFacetFilter();
        for (SpringController springController : this.controllers) {
            if (springController.getRequestMappings().stream().noneMatch(arg_0 -> ((FacetFilter)facetFilter).accept(arg_0))) continue;
            String slug = springController.getSimpleName().toString();
            if (slugs.contains(slug)) {
                slug = "";
                String[] qualifiedNameTokens = springController.getQualifiedName().toString().split("\\.");
                for (int i = qualifiedNameTokens.length - 1; i >= 0; --i) {
                    String string = slug = slug.isEmpty() ? qualifiedNameTokens[i] : slug + "_" + qualifiedNameTokens[i];
                    if (!slugs.contains(slug)) break;
                }
            }
            slugs.add(slug);
            ResourceClassResourceGroupImpl group = new ResourceClassResourceGroupImpl(springController, slug, this.relativeContextPath, registrationContext);
            if (group.getResources().isEmpty()) continue;
            resourceGroups.add(group);
        }
        Collections.sort(resourceGroups, new ResourceGroupComparator(this.pathSortStrategy));
        return resourceGroups;
    }

    public List<ResourceGroup> getResourceGroupsByPath(ApiRegistrationContext registrationContext) {
        HashMap<String, PathBasedResourceGroupImpl> resourcesByPath = new HashMap<String, PathBasedResourceGroupImpl>();
        FacetFilter facetFilter = registrationContext.getFacetFilter();
        for (SpringController springController : this.controllers) {
            for (RequestMapping method : springController.getRequestMappings()) {
                if (!facetFilter.accept((HasFacets)method)) continue;
                String path = method.getFullpath();
                PathBasedResourceGroupImpl resourceGroup = (PathBasedResourceGroupImpl)resourcesByPath.get(path);
                if (resourceGroup == null) {
                    resourceGroup = new PathBasedResourceGroupImpl(this.relativeContextPath, path, new ArrayList<Resource>());
                    resourcesByPath.put(path, resourceGroup);
                }
                resourceGroup.getResources().add(new ResourceImpl(method, resourceGroup, registrationContext));
            }
        }
        ArrayList<ResourceGroup> resourceGroups = new ArrayList<ResourceGroup>(resourcesByPath.values());
        Collections.sort(resourceGroups, new ResourceGroupComparator(this.pathSortStrategy));
        return resourceGroups;
    }

    public List<ResourceGroup> getResourceGroupsByAnnotation(ApiRegistrationContext registrationContext) {
        HashMap<String, AnnotationBasedResourceGroupImpl> resourcesByAnnotation = new HashMap<String, AnnotationBasedResourceGroupImpl>();
        FacetFilter facetFilter = registrationContext.getFacetFilter();
        for (SpringController springController : this.controllers) {
            com.webcohesion.enunciate.metadata.rs.ResourceGroup controllerAnnotation = null;
            boolean controllerAnnotationEvaluated = false;
            for (RequestMapping method : springController.getRequestMappings()) {
                AnnotationBasedResourceGroupImpl resourceGroup;
                String description;
                if (!facetFilter.accept((HasFacets)method)) continue;
                com.webcohesion.enunciate.metadata.rs.ResourceGroup annotation = AnnotationUtils.getResourceGroup((Element)((Object)method));
                if (annotation == null) {
                    if (!controllerAnnotationEvaluated) {
                        controllerAnnotation = AnnotationUtils.getResourceGroup((Element)((Object)springController));
                        controllerAnnotationEvaluated = true;
                    }
                    annotation = controllerAnnotation;
                }
                String label = annotation == null ? "Other" : annotation.value();
                String string = description = annotation == null ? null : annotation.description();
                if ("##default".equals(description)) {
                    description = null;
                }
                if ((resourceGroup = (AnnotationBasedResourceGroupImpl)resourcesByAnnotation.get(label)) == null) {
                    resourceGroup = new AnnotationBasedResourceGroupImpl(this.relativeContextPath, label, (List<Resource>)new SortedList((Comparator)new ResourceComparator(this.pathSortStrategy)), this.pathSortStrategy);
                    resourcesByAnnotation.put(label, resourceGroup);
                }
                resourceGroup.setDescriptionIfNull(description);
                resourceGroup.getResources().add(new ResourceImpl(method, resourceGroup, registrationContext));
            }
        }
        ArrayList<ResourceGroup> resourceGroups = new ArrayList<ResourceGroup>(resourcesByAnnotation.values());
        Collections.sort(resourceGroups, new ResourceGroupComparator(this.pathSortStrategy));
        return resourceGroups;
    }

    public static enum GroupingStrategy {
        path,
        annotation,
        resource_class;

    }
}

