/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.api.impl;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.datatype.BaseType;
import com.webcohesion.enunciate.api.datatype.CustomDataTypeReference;
import com.webcohesion.enunciate.api.datatype.CustomMediaTypeDescriptor;
import com.webcohesion.enunciate.api.datatype.CustomSyntax;
import com.webcohesion.enunciate.api.datatype.DataType;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Example;
import com.webcohesion.enunciate.api.datatype.Syntax;
import com.webcohesion.enunciate.api.resources.Entity;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.metadata.DocumentationExample;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import com.webcohesion.enunciate.modules.spring_web.api.impl.MediaTypeDescriptorImpl;
import com.webcohesion.enunciate.modules.spring_web.model.RequestMapping;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceEntityParameter;
import com.webcohesion.enunciate.modules.spring_web.model.formdata.FormDataMediaTypeDescriptor;
import com.webcohesion.enunciate.util.BeanValidationUtils;
import com.webcohesion.enunciate.util.ExampleUtils;
import com.webcohesion.enunciate.util.MediaTypeUtils;
import com.webcohesion.enunciate.util.TypeHintUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class RequestEntityImpl
implements Entity {
    private final RequestMapping requestMapping;
    private final ResourceEntityParameter entityParameter;
    private final ApiRegistrationContext registrationContext;

    public RequestEntityImpl(RequestMapping requestMapping, ResourceEntityParameter entityParameter, ApiRegistrationContext registrationContext) {
        this.requestMapping = requestMapping;
        this.entityParameter = entityParameter;
        this.registrationContext = registrationContext;
    }

    public String getDescription() {
        return this.entityParameter.getDocValue(this.registrationContext.getTagHandler());
    }

    public List<? extends MediaTypeDescriptor> getMediaTypes() {
        Set<String> consumes = this.requestMapping.getConsumesMediaTypes();
        ArrayList<Object> mts = new ArrayList<Object>(consumes.size());
        for (String mt : consumes) {
            Syntax syntax2;
            boolean descriptorFound = false;
            DecoratedTypeMirror type = (DecoratedTypeMirror)this.entityParameter.getType();
            for (Syntax syntax2 : this.requestMapping.getContext().getContext().getApiRegistry().getSyntaxes(this.registrationContext)) {
                MediaTypeDescriptor descriptor = syntax2.findMediaTypeDescriptor(mt, type);
                if (descriptor == null) continue;
                mts.add(new MediaTypeDescriptorImpl(descriptor, this.loadExample(syntax2, descriptor)));
                descriptorFound = true;
            }
            if (!descriptorFound && MediaTypeUtils.isUrlEncodedFormData((String)mt)) {
                mts.add(new FormDataMediaTypeDescriptor(mt, this.requestMapping, this.registrationContext));
                descriptorFound = true;
            }
            if (descriptorFound) continue;
            CustomMediaTypeDescriptor descriptor = new CustomMediaTypeDescriptor(mt);
            descriptor.setDataType((DataTypeReference)new CustomDataTypeReference(BaseType.fromType((TypeMirror)this.entityParameter.getType())));
            syntax2 = new CustomSyntax(descriptor);
            descriptor.setExample(this.loadExample(syntax2, (MediaTypeDescriptor)descriptor));
            mts.add(descriptor);
        }
        return mts;
    }

    protected Example loadExample(Syntax syntax, MediaTypeDescriptor descriptor) {
        Example example = ExampleUtils.loadCustomExample((Syntax)syntax, (String)"requestExample", (DecoratedElement)this.requestMapping, (EnunciateContext)this.requestMapping.getContext().getContext());
        if (example == null) {
            List dataTypes;
            Element element;
            TypeMirror typeHint;
            DocumentationExample documentationExample;
            example = descriptor.getExample();
            if (this.entityParameter != null && (documentationExample = (DocumentationExample)this.entityParameter.getAnnotation(DocumentationExample.class)) != null && (typeHint = TypeHintUtils.getTypeHint((TypeHint)documentationExample.type(), (DecoratedProcessingEnvironment)this.requestMapping.getContext().getContext().getProcessingEnvironment(), null)) instanceof DeclaredType && (element = ((DeclaredType)typeHint).asElement()) instanceof TypeElement && (dataTypes = syntax.findDataTypes(((TypeElement)element).getQualifiedName().toString())) != null && !dataTypes.isEmpty()) {
                example = ((DataType)dataTypes.get(0)).getExample();
            }
        }
        return example;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)this.entityParameter.getAnnotation(annotationType);
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.entityParameter.getAnnotations();
    }

    public JavaDoc getJavaDoc() {
        return this.entityParameter.getJavaDoc(this.registrationContext.getTagHandler());
    }

    public boolean isRequired() {
        return BeanValidationUtils.isNotNull((Element)this.entityParameter.getDelegate(), (ProcessingEnvironment)this.requestMapping.getContext().getContext().getProcessingEnvironment());
    }
}

