/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.model;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateLogger;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedExecutableElement;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedDeclaredType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.javac.decorations.type.TypeVariableContext;
import com.webcohesion.enunciate.javac.javadoc.DocComment;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.javac.javadoc.ParamDocComment;
import com.webcohesion.enunciate.javac.javadoc.ReturnDocComment;
import com.webcohesion.enunciate.javac.javadoc.StaticDocComment;
import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResourceLabel;
import com.webcohesion.enunciate.metadata.rs.ResponseHeader;
import com.webcohesion.enunciate.metadata.rs.ResponseHeaders;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import com.webcohesion.enunciate.metadata.rs.Warnings;
import com.webcohesion.enunciate.modules.spring_web.EnunciateSpringWebContext;
import com.webcohesion.enunciate.modules.spring_web.model.ExplicitRequestParameter;
import com.webcohesion.enunciate.modules.spring_web.model.PathContext;
import com.webcohesion.enunciate.modules.spring_web.model.PathSegment;
import com.webcohesion.enunciate.modules.spring_web.model.RequestMappingAdvice;
import com.webcohesion.enunciate.modules.spring_web.model.RequestParameter;
import com.webcohesion.enunciate.modules.spring_web.model.RequestParameterFactory;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceEntityParameter;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceParameterConstraints;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceParameterType;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceRepresentationMetadata;
import com.webcohesion.enunciate.modules.spring_web.model.ResponseCode;
import com.webcohesion.enunciate.modules.spring_web.model.SpringController;
import com.webcohesion.enunciate.modules.spring_web.model.SpringControllerAdvice;
import com.webcohesion.enunciate.modules.spring_web.model.util.RSParamDocComment;
import com.webcohesion.enunciate.modules.spring_web.model.util.ReturnWrappedDocComment;
import com.webcohesion.enunciate.util.AnnotationUtils;
import com.webcohesion.enunciate.util.JAXDocletUtil;
import com.webcohesion.enunciate.util.TypeHintUtils;
import jakarta.annotation.security.RolesAllowed;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.IncompleteAnnotationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

public class RequestMapping
extends DecoratedExecutableElement
implements HasFacets,
PathContext {
    private static final Pattern CONTEXT_PARAM_PATTERN = Pattern.compile("\\{([^\\}]+)\\}");
    private final EnunciateSpringWebContext context;
    private final List<PathSegment> pathSegments;
    private final String label;
    private final Set<String> httpMethods;
    private final Set<String> consumesMediaTypes;
    private final Set<String> producesMediaTypes;
    private final SpringController parent;
    private final Set<RequestParameter> requestParameters = new TreeSet<RequestParameter>();
    private final ResourceEntityParameter entityParameter;
    private final Map<String, Object> metaData = new HashMap<String, Object>();
    private final List<ResponseCode> statusCodes = new ArrayList<ResponseCode>();
    private final List<ResponseCode> warnings = new ArrayList<ResponseCode>();
    private final Map<String, String> responseHeaders = new HashMap<String, String>();
    private final ResourceRepresentationMetadata representationMetadata;
    private final Set<Facet> facets = new TreeSet<Facet>();

    /*
     * WARNING - void declaration
     */
    public RequestMapping(List<PathSegment> pathSegments, org.springframework.web.bind.annotation.RequestMapping mapping, ExecutableElement delegate, SpringController parent, TypeVariableContext variableContext, EnunciateSpringWebContext context) {
        super(delegate, context.getContext().getProcessingEnvironment());
        DecoratedProcessingEnvironment env;
        String[] headers;
        Object returnType;
        void var9_14;
        this.context = context;
        this.pathSegments = pathSegments;
        EnumSet<RequestMethod> httpMethods = EnumSet.allOf(RequestMethod.class);
        if (mapping.method().length > 0) {
            httpMethods.retainAll(Arrays.asList(mapping.method()));
        }
        httpMethods.retainAll(parent.getApplicableMethods());
        if (httpMethods.isEmpty()) {
            throw new IllegalStateException(parent.getQualifiedName() + "." + this.getSimpleName() + ": no applicable request methods.");
        }
        this.httpMethods = new TreeSet<String>();
        for (RequestMethod requestMethod : httpMethods) {
            this.httpMethods.add(requestMethod.name());
        }
        Set<Object> consumes = new TreeSet();
        if (mapping.consumes().length > 0) {
            for (String mediaType : mapping.consumes()) {
                if (mediaType.startsWith("!")) continue;
                int colonIndex = mediaType.indexOf(59);
                if (colonIndex > 0) {
                    mediaType = mediaType.substring(0, colonIndex);
                }
                consumes.add(mediaType);
            }
            if (consumes.isEmpty()) {
                consumes.add("*/*");
            }
        } else {
            consumes = parent.getConsumesMime();
        }
        this.consumesMediaTypes = consumes;
        TreeSet<String> treeSet = new TreeSet<String>();
        if (mapping.produces().length > 0) {
            for (String mediaType : mapping.produces()) {
                if (mediaType.startsWith("!")) continue;
                int colonIndex = mediaType.indexOf(59);
                if (colonIndex > 0) {
                    mediaType = mediaType.substring(0, colonIndex);
                }
                treeSet.add(mediaType);
            }
            if (treeSet.isEmpty()) {
                treeSet.add("*/*");
            }
        } else {
            Set<String> set = parent.getProducesMime();
        }
        this.producesMediaTypes = var9_14;
        String label = null;
        ResourceLabel resourceLabel = delegate.getAnnotation(ResourceLabel.class);
        if (resourceLabel != null && "##default".equals(label = resourceLabel.value())) {
            label = null;
        }
        ResourceEntityParameter entityParameter = null;
        ResourceRepresentationMetadata outputPayload = null;
        Set<SpringControllerAdvice> advice = this.context.getAdvice();
        for (SpringControllerAdvice controllerAdvice : advice) {
            List<RequestMappingAdvice> requestAdvice = controllerAdvice.findRequestMappingAdvice(this);
            for (RequestMappingAdvice mappingAdvice : requestAdvice) {
                entityParameter = mappingAdvice.getEntityParameter();
                outputPayload = mappingAdvice.getRepresentationMetadata();
                this.requestParameters.addAll(mappingAdvice.getRequestParameters());
                this.statusCodes.addAll(mappingAdvice.getStatusCodes());
                this.warnings.addAll(mappingAdvice.getWarnings());
                this.responseHeaders.putAll(mappingAdvice.getResponseHeaders());
            }
        }
        for (VariableElement parameterDeclaration : this.getParameters()) {
            if (AnnotationUtils.isIgnored((Element)parameterDeclaration)) continue;
            if (this.isImplicitUntypedRequestBody(parameterDeclaration.asType()) && entityParameter == null) {
                DecoratedProcessingEnvironment env2 = context.getContext().getProcessingEnvironment();
                entityParameter = new ResourceEntityParameter((Element)((Object)this), (TypeMirror)TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)env2), env2);
                continue;
            }
            if (parameterDeclaration.getAnnotation(RequestBody.class) != null) {
                entityParameter = new ResourceEntityParameter(parameterDeclaration, variableContext, context);
                continue;
            }
            this.requestParameters.addAll(RequestParameterFactory.getRequestParameters((ExecutableElement)((Object)this), parameterDeclaration, this));
        }
        TypeHint hintInfo = (TypeHint)this.getAnnotation(TypeHint.class);
        JavaDoc localDoc = new JavaDoc(this.getDocComment(), null, null, this.env);
        if (hintInfo != null) {
            returnType = (DecoratedTypeMirror)TypeHintUtils.getTypeHint((TypeHint)hintInfo, (DecoratedProcessingEnvironment)this.env, null);
            if (returnType != null) {
                returnType.setDeferredDocComment((DocComment)new ReturnDocComment((DecoratedExecutableElement)this));
            }
        } else {
            Iterator returnWrapped;
            boolean returnsResponseBody;
            returnType = (DecoratedTypeMirror)this.getReturnType();
            if (returnType instanceof DecoratedDeclaredType && (returnType.isInstanceOf(Callable.class) || returnType.isInstanceOf("org.springframework.web.context.request.async.DeferredResult") || returnType.isInstanceOf("org.springframework.util.concurrent.ListenableFuture"))) {
                List typeArgs = ((DecoratedDeclaredType)returnType).getTypeArguments();
                returnType = typeArgs != null && typeArgs.size() == 1 ? (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)((TypeMirror)typeArgs.get(0)), (DecoratedProcessingEnvironment)this.env) : TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)this.env);
            }
            boolean bl = returnsResponseBody = this.getAnnotation(ResponseBody.class) != null || AnnotationUtils.getMetaAnnotation(ResponseBody.class, (Element)((Object)parent)) != null;
            if (returnType instanceof DecoratedDeclaredType && returnType.isInstanceOf("org.springframework.http.HttpEntity")) {
                DecoratedDeclaredType entity = (DecoratedDeclaredType)returnType;
                List typeArgs = entity.getTypeArguments();
                returnType = typeArgs != null && typeArgs.size() == 1 ? (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)((TypeMirror)typeArgs.get(0)), (DecoratedProcessingEnvironment)this.env) : TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)this.env);
            } else if (!returnsResponseBody) {
                returnType = TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)this.env);
            }
            if (returnType.isInstanceOf("org.springframework.core.io.Resource") || this.isImplicitUntypedEntityBody((DecoratedTypeMirror<?>)returnType)) {
                returnType = TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)this.env);
            }
            if ((returnWrapped = JAXDocletUtil.getReturnWrapped((String)this.getDocComment(), (DecoratedProcessingEnvironment)this.env, (EnunciateLogger)this.getContext().getContext().getLogger())) != null) {
                returnWrapped.setDeferredDocComment((DocComment)new ReturnWrappedDocComment(this));
                returnType = returnWrapped;
            }
            returnType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)variableContext.resolveTypeVariables((TypeMirror)returnType, (ProcessingEnvironment)this.env), (DecoratedProcessingEnvironment)this.env);
            returnType.setDeferredDocComment((DocComment)new ReturnDocComment((DecoratedExecutableElement)this));
        }
        outputPayload = returnType == null || returnType.isVoid() || returnType.isInstanceOf(Void.class) ? outputPayload : new ResourceRepresentationMetadata((DecoratedTypeMirror)returnType);
        JavaDoc.JavaDocTagList doclets = (JavaDoc.JavaDocTagList)localDoc.get((Object)"RequestHeader");
        if (doclets != null) {
            for (Object doclet : doclets) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                Object header = firstspace > 0 ? ((String)doclet).substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < ((String)doclet).length() ? ((String)doclet).substring(firstspace + 1) : "";
                this.requestParameters.add(new ExplicitRequestParameter((ExecutableElement)((Object)this), doc, (String)header, ResourceParameterType.HEADER, context));
            }
        }
        List inheritedDoclets = AnnotationUtils.getJavaDocTags((String)"RequestHeader", (Element)((Object)parent));
        for (JavaDoc.JavaDocTagList inheritedDoclet : inheritedDoclets) {
            for (String doclet : inheritedDoclet) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                String header = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                this.requestParameters.add(new ExplicitRequestParameter((ExecutableElement)((Object)this), doc, header, ResourceParameterType.HEADER, context));
            }
        }
        RequestHeaders requestHeaders = (RequestHeaders)this.getAnnotation(RequestHeaders.class);
        if (requestHeaders != null) {
            for (RequestHeader header : requestHeaders.value()) {
                this.requestParameters.add(new ExplicitRequestParameter((ExecutableElement)((Object)this), header.description(), header.name(), ResourceParameterType.HEADER, context));
            }
        }
        List inheritedRequestHeaders = AnnotationUtils.getAnnotations(RequestHeaders.class, (Element)((Object)parent), (boolean)true);
        for (RequestHeaders inheritedRequestHeader : inheritedRequestHeaders) {
            for (RequestHeader requestHeader : inheritedRequestHeader.value()) {
                this.requestParameters.add(new ExplicitRequestParameter((ExecutableElement)((Object)this), requestHeader.description(), requestHeader.name(), ResourceParameterType.HEADER, context));
            }
        }
        for (String header : headers = mapping.headers()) {
            if (RequestMapping.contains(this.requestParameters, header, ResourceParameterType.HEADER)) continue;
            this.requestParameters.add(new ExplicitRequestParameter((ExecutableElement)((Object)this), "", header, ResourceParameterType.HEADER, false, ResourceParameterConstraints.REQUIRED, context));
        }
        StatusCodes codes = (StatusCodes)this.getAnnotation(StatusCodes.class);
        if (codes != null) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseCode responseCode : codes.value()) {
                ResponseCode rc2 = new ResponseCode(this);
                rc2.setCode(responseCode.code());
                rc2.setCondition(responseCode.condition());
                for (ResponseHeader responseHeader : responseCode.additionalHeaders()) {
                    rc2.setAdditionalHeader(responseHeader.name(), responseHeader.description());
                }
                rc2.setType((DecoratedTypeMirror)TypeHintUtils.getTypeHint((TypeHint)responseCode.type(), (DecoratedProcessingEnvironment)this.env, null));
                this.statusCodes.add(rc2);
            }
        }
        List inheritedStatusCodes = AnnotationUtils.getAnnotations(StatusCodes.class, (Element)((Object)parent), (boolean)true);
        for (StatusCodes inheritedStatusCode : inheritedStatusCodes) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseCode code : inheritedStatusCode.value()) {
                ResponseCode rc3 = new ResponseCode(this);
                rc3.setCode(code.code());
                rc3.setCondition(code.condition());
                for (ResponseHeader header : code.additionalHeaders()) {
                    rc3.setAdditionalHeader(header.name(), header.description());
                }
                rc3.setType((DecoratedTypeMirror)TypeHintUtils.getTypeHint((TypeHint)code.type(), (DecoratedProcessingEnvironment)this.env, null));
                this.statusCodes.add(rc3);
            }
        }
        doclets = (JavaDoc.JavaDocTagList)localDoc.get((Object)"HTTP");
        if (doclets != null) {
            for (String doclet : doclets) {
                int n = JavaDoc.indexOfFirstWhitespace((String)doclet);
                String code = n > 0 ? doclet.substring(0, n) : doclet;
                String doc = n > 0 && n + 1 < doclet.length() ? doclet.substring(n + 1) : "";
                try {
                    ResponseCode rc4 = new ResponseCode(this);
                    rc4.setCode(Integer.parseInt(code));
                    rc4.setCondition(doc);
                    this.statusCodes.add(rc4);
                }
                catch (NumberFormatException rc4) {}
            }
        }
        inheritedDoclets = AnnotationUtils.getJavaDocTags((String)"HTTP", (Element)((Object)parent));
        for (JavaDoc.JavaDocTagList inheritedDoclet : inheritedDoclets) {
            for (String doclet : inheritedDoclet) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                String code = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                try {
                    ResponseCode responseCode = new ResponseCode(this);
                    responseCode.setCode(Integer.parseInt(code));
                    responseCode.setCondition(doc);
                    this.statusCodes.add(responseCode);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        this.processResponseStatus();
        Warnings warningInfo = (Warnings)this.getAnnotation(Warnings.class);
        if (warningInfo != null) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseCode code : warningInfo.value()) {
                ResponseCode rc6 = new ResponseCode(this);
                rc6.setCode(code.code());
                rc6.setCondition(code.condition());
                this.warnings.add(rc6);
            }
        }
        List inheritedWarnings = AnnotationUtils.getAnnotations(Warnings.class, (Element)((Object)parent), (boolean)true);
        for (Warnings inheritedWarning : inheritedWarnings) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseCode responseCode : inheritedWarning.value()) {
                ResponseCode rc7 = new ResponseCode(this);
                rc7.setCode(responseCode.code());
                rc7.setCondition(responseCode.condition());
                this.warnings.add(rc7);
            }
        }
        doclets = (JavaDoc.JavaDocTagList)localDoc.get((Object)"HTTPWarning");
        if (doclets != null) {
            for (String doclet : doclets) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                String code = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                try {
                    ResponseCode responseCode = new ResponseCode(this);
                    responseCode.setCode(Integer.parseInt(code));
                    responseCode.setCondition(doc);
                    this.warnings.add(responseCode);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        inheritedDoclets = AnnotationUtils.getJavaDocTags((String)"HTTPWarning", (Element)((Object)parent));
        for (JavaDoc.JavaDocTagList inheritedDoclet : inheritedDoclets) {
            for (String doclet : inheritedDoclet) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                String string = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                try {
                    ResponseCode rc9 = new ResponseCode(this);
                    rc9.setCode(Integer.parseInt(string));
                    rc9.setCondition(doc);
                    this.warnings.add(rc9);
                }
                catch (NumberFormatException rc9) {}
            }
        }
        ResponseHeaders responseHeaders = (ResponseHeaders)this.getAnnotation(ResponseHeaders.class);
        if (responseHeaders != null) {
            for (ResponseHeader header : responseHeaders.value()) {
                this.responseHeaders.put(header.name(), header.description());
            }
        }
        List inheritedResponseHeaders = AnnotationUtils.getAnnotations(ResponseHeaders.class, (Element)((Object)parent), (boolean)true);
        for (ResponseHeaders inheritedResponseHeader : inheritedResponseHeaders) {
            for (ResponseHeader header : inheritedResponseHeader.value()) {
                this.responseHeaders.put(header.name(), header.description());
            }
        }
        doclets = (JavaDoc.JavaDocTagList)localDoc.get((Object)"ResponseHeader");
        if (doclets != null) {
            for (String doclet : doclets) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)doclet);
                String string = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                this.responseHeaders.put(string, doc);
            }
        }
        inheritedDoclets = AnnotationUtils.getJavaDocTags((String)"ResponseHeader", (Element)((Object)parent));
        for (JavaDoc.JavaDocTagList inheritedDoclet : inheritedDoclets) {
            for (String string : inheritedDoclet) {
                int firstspace = JavaDoc.indexOfFirstWhitespace((String)string);
                String header = firstspace > 0 ? string.substring(0, firstspace) : string;
                String doc = firstspace > 0 && firstspace + 1 < string.length() ? string.substring(firstspace + 1) : "";
                this.responseHeaders.put(header, doc);
            }
        }
        if (outputPayload == null && this.getJavaDoc().get((Object)"responseExample") != null) {
            env = context.getContext().getProcessingEnvironment();
            outputPayload = new ResourceRepresentationMetadata((TypeMirror)TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)env), (DocComment)new StaticDocComment(""));
        }
        if (entityParameter == null && this.getJavaDoc().get((Object)"requestExample") != null) {
            env = context.getContext().getProcessingEnvironment();
            entityParameter = new ResourceEntityParameter((Element)((Object)this), (TypeMirror)TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)env), env);
        }
        this.entityParameter = entityParameter;
        this.label = label;
        this.parent = parent;
        this.representationMetadata = outputPayload;
        this.facets.addAll(Facet.gatherFacets((Element)delegate, (EnunciateContext)context.getContext()));
        this.facets.addAll(parent.getFacets());
    }

    private static boolean contains(Set<RequestParameter> requestParameters, String name, ResourceParameterType type) {
        String typeName = type.name().toLowerCase();
        for (RequestParameter requestParameter : requestParameters) {
            if (!name.equals(requestParameter.getParameterName()) || !typeName.equals(requestParameter.getTypeName()) && !"custom".equals(requestParameter.getTypeName())) continue;
            return true;
        }
        return false;
    }

    private boolean hasStatusCode(int value) {
        for (ResponseCode rc : this.statusCodes) {
            if (rc.getCode() != value) continue;
            return true;
        }
        return false;
    }

    private void processResponseStatus() {
        ResponseStatus responseStatus = (ResponseStatus)this.getAnnotation(ResponseStatus.class);
        if (responseStatus == null) {
            return;
        }
        HttpStatus code = responseStatus.value();
        if (code == HttpStatus.INTERNAL_SERVER_ERROR) {
            try {
                code = responseStatus.code();
            }
            catch (IncompleteAnnotationException incompleteAnnotationException) {
                // empty catch block
            }
        }
        if (this.hasStatusCode(code.value())) {
            return;
        }
        ResponseCode rc = new ResponseCode(this);
        rc.setCode(code.value());
        String reason = responseStatus.reason();
        if (!reason.isEmpty()) {
            rc.setCondition(reason);
        }
        this.statusCodes.add(rc);
    }

    protected ParamDocComment createParamDocComment(VariableElement param) {
        return new RSParamDocComment(this, param.getSimpleName().toString());
    }

    @Override
    public EnunciateSpringWebContext getContext() {
        return this.context;
    }

    public Set<String> getHttpMethods() {
        return this.httpMethods;
    }

    @Override
    public List<PathSegment> getPathSegments() {
        return this.pathSegments;
    }

    @Override
    public boolean isUrlEncodedFormPost() {
        return this.httpMethods.contains("POST") && this.consumesMediaTypes.contains("application/x-www-form-urlencoded");
    }

    public String getFullpath() {
        StringBuilder builder = new StringBuilder();
        for (PathSegment pathSegment : this.getPathSegments()) {
            builder.append(pathSegment.getValue());
        }
        return builder.toString();
    }

    public String getServletPattern() {
        StringBuilder builder = new StringBuilder();
        String fullPath = this.getFullpath();
        Matcher pathParamMatcher = CONTEXT_PARAM_PATTERN.matcher(fullPath);
        if (pathParamMatcher.find()) {
            builder.append(fullPath, 0, pathParamMatcher.start()).append("*");
        } else {
            builder.append(fullPath);
        }
        return builder.toString();
    }

    public String getLabel() {
        return this.label;
    }

    public SpringController getParent() {
        return this.parent;
    }

    public Set<String> getConsumesMediaTypes() {
        return this.consumesMediaTypes;
    }

    public Set<String> getProducesMediaTypes() {
        return this.producesMediaTypes;
    }

    public Set<RequestParameter> getRequestParameters() {
        return this.requestParameters;
    }

    public ResourceEntityParameter getEntityParameter() {
        return this.entityParameter;
    }

    public ResourceRepresentationMetadata getRepresentationMetadata() {
        return this.representationMetadata;
    }

    public List<? extends ResponseCode> getStatusCodes() {
        return this.statusCodes;
    }

    public List<? extends ResponseCode> getWarnings() {
        return this.warnings;
    }

    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.metaData);
    }

    public void putMetaData(String name, Object data) {
        this.metaData.put(name, data);
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Set<Facet> getFacets() {
        return this.facets;
    }

    public Set<String> getSecurityRoles() {
        SpringController parent;
        TreeSet<String> roles = new TreeSet<String>();
        RolesAllowed rolesAllowed = (RolesAllowed)this.getAnnotation(RolesAllowed.class);
        if (rolesAllowed != null) {
            Collections.addAll(roles, rolesAllowed.value());
        }
        if ((parent = this.getParent()) != null) {
            roles.addAll(parent.getSecurityRoles());
        }
        return roles;
    }

    private boolean isImplicitUntypedRequestBody(TypeMirror parameterType) {
        DecoratedTypeMirror type = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)parameterType, (DecoratedProcessingEnvironment)this.env);
        return this.isImplicitUntypedEntityBody(type) || type.isInstanceOf("jakarta.servlet.ServletRequest") || type.isInstanceOf("jakarta.servlet.http.HttpServletRequest");
    }

    private boolean isImplicitUntypedEntityBody(DecoratedTypeMirror<?> type) {
        return type.isInstanceOf(InputStream.class) || type.isInstanceOf(Reader.class);
    }
}

