/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.model.formdata;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.datatype.BaseType;
import com.webcohesion.enunciate.api.datatype.CustomDataTypeReference;
import com.webcohesion.enunciate.api.datatype.DataType;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Example;
import com.webcohesion.enunciate.api.datatype.Namespace;
import com.webcohesion.enunciate.api.datatype.Property;
import com.webcohesion.enunciate.api.datatype.Syntax;
import com.webcohesion.enunciate.api.datatype.Value;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.modules.spring_web.model.RequestMapping;
import com.webcohesion.enunciate.modules.spring_web.model.RequestParameter;
import com.webcohesion.enunciate.util.MediaTypeUtils;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.apache.commons.lang3.StringUtils;

public class FormDataMediaTypeDescriptor
implements MediaTypeDescriptor {
    private String mediaType;
    private final RequestMapping method;
    private final ApiRegistrationContext registrationContext;

    public FormDataMediaTypeDescriptor(String mediaType, RequestMapping method, ApiRegistrationContext registrationContext) {
        this.mediaType = mediaType;
        this.method = method;
        this.registrationContext = registrationContext;
    }

    public String getMediaType() {
        return "application/x-www-form-urlencoded";
    }

    public DataTypeReference getDataType() {
        return null;
    }

    public DataType getAnonymousDataType() {
        return new FormDataType();
    }

    public String getSyntax() {
        return null;
    }

    public float getQualityOfSourceFactor() {
        return 1.0f;
    }

    public RequestMapping getMethod() {
        return this.method;
    }

    private String getLabel() {
        return this.method.getLabel() + " Data";
    }

    private String getSlug() {
        return this.method.getSimpleNameString() + "_data";
    }

    public Example getExample() {
        return MediaTypeUtils.isMultipartFormData((String)this.mediaType) ? new MultipartFormEncodedExample() : new UrlEncodedExample();
    }

    private class FormDataType
    implements DataType {
        private FormDataType() {
        }

        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return (A)FormDataMediaTypeDescriptor.this.method.getAnnotation(annotationType);
        }

        public Map<String, AnnotationMirror> getAnnotations() {
            return FormDataMediaTypeDescriptor.this.method.getAnnotations();
        }

        public Set<String> getStyles() {
            return Collections.emptySet();
        }

        public String getLabel() {
            return FormDataMediaTypeDescriptor.this.getLabel();
        }

        public String getSlug() {
            return FormDataMediaTypeDescriptor.this.getSlug();
        }

        public String getDescription() {
            return FormDataMediaTypeDescriptor.this.method.getJavaDoc(FormDataMediaTypeDescriptor.this.registrationContext.getTagHandler()).toString();
        }

        public String getDeprecated() {
            return null;
        }

        public Namespace getNamespace() {
            return null;
        }

        public Syntax getSyntax() {
            return null;
        }

        public BaseType getBaseType() {
            return BaseType.object;
        }

        public List<DataTypeReference> getSupertypes() {
            return Collections.emptyList();
        }

        public Set<DataTypeReference> getInterfaces() {
            return Collections.emptySet();
        }

        public List<DataTypeReference> getSubtypes() {
            return Collections.emptyList();
        }

        public String getSince() {
            return null;
        }

        public List<String> getSeeAlso() {
            return Collections.emptyList();
        }

        public String getVersion() {
            return null;
        }

        public boolean isAbstract() {
            return false;
        }

        public Example getExample() {
            return FormDataMediaTypeDescriptor.this.getExample();
        }

        public List<? extends Value> getValues() {
            return null;
        }

        public Property findProperty(String name) {
            return this.getProperties().stream().filter(p -> StringUtils.equals((CharSequence)p.getName(), (CharSequence)name)).findFirst().get();
        }

        public List<? extends Property> getProperties() {
            return FormDataMediaTypeDescriptor.this.method.getRequestParameters().stream().filter(param -> StringUtils.equals((CharSequence)"form", (CharSequence)param.getTypeName())).map(x$0 -> new ParameterProperty((RequestParameter)x$0)).collect(Collectors.toList());
        }

        public Value findValue(String name) {
            return null;
        }

        public Map<String, String> getPropertyMetadata() {
            return Collections.emptyMap();
        }

        public JavaDoc getJavaDoc() {
            return FormDataMediaTypeDescriptor.this.method.getJavaDoc(FormDataMediaTypeDescriptor.this.registrationContext.getTagHandler());
        }

        public Element getJavaElement() {
            return FormDataMediaTypeDescriptor.this.method;
        }

        public Set<Facet> getFacets() {
            return FormDataMediaTypeDescriptor.this.method.getFacets();
        }
    }

    private class MultipartFormEncodedExample
    implements Example {
        private MultipartFormEncodedExample() {
        }

        public String getLang() {
            return "txt";
        }

        public String getBody() {
            return FormDataMediaTypeDescriptor.this.method.getRequestParameters().stream().filter(param -> StringUtils.equals((CharSequence)"form", (CharSequence)param.getTypeName())).map(param -> "-----boundary\nContent-Disposition: form-data; name=\"" + param.getParameterName() + "\"\n\n...").collect(Collectors.joining("\n"));
        }
    }

    private class UrlEncodedExample
    implements Example {
        private UrlEncodedExample() {
        }

        public String getLang() {
            return "txt";
        }

        public String getBody() {
            return FormDataMediaTypeDescriptor.this.method.getRequestParameters().stream().filter(param -> StringUtils.equals((CharSequence)"form", (CharSequence)param.getTypeName())).map(param -> param.getParameterName() + "=...").collect(Collectors.joining("&"));
        }
    }

    private class ParameterProperty
    implements Property {
        private final RequestParameter parameter;

        public ParameterProperty(RequestParameter parameter) {
            this.parameter = parameter;
        }

        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return (A)this.parameter.getAnnotation(annotationType);
        }

        public Map<String, AnnotationMirror> getAnnotations() {
            return this.parameter.getAnnotations();
        }

        public Set<String> getStyles() {
            return Collections.emptySet();
        }

        public String getName() {
            return this.parameter.getParameterName();
        }

        public String getDescription() {
            return this.getJavaDoc().toString();
        }

        public DataTypeReference getDataType() {
            return new CustomDataTypeReference(BaseType.string);
        }

        public String getDeprecated() {
            return null;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isReadOnly() {
            return false;
        }

        public JavaDoc getJavaDoc() {
            return this.parameter.getJavaDoc(FormDataMediaTypeDescriptor.this.registrationContext.getTagHandler());
        }

        public String getSince() {
            return null;
        }

        public Set<Facet> getFacets() {
            return FormDataMediaTypeDescriptor.this.method.getFacets();
        }
    }
}

