/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.swagger;

import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.modules.swagger.SwaggerMethod;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class SwaggerResource {
    private final ResourceGroup resourceGroup;
    private final Set<SwaggerMethod> methods = new TreeSet<SwaggerMethod>(Comparator.comparing(SwaggerMethod::getHttpMethod));

    public SwaggerResource(ResourceGroup resourceGroup) {
        this.resourceGroup = resourceGroup;
    }

    public ResourceGroup getResourceGroup() {
        return this.resourceGroup;
    }

    public Set<Method> getMethods() {
        return Collections.unmodifiableSet(this.methods);
    }

    public void addMethod(Method method) {
        this.methods.stream().filter(sm -> StringUtils.equals((CharSequence)sm.getHttpMethod(), (CharSequence)method.getHttpMethod())).findAny().ifPresentOrElse(existing -> existing.merge(method), () -> this.methods.add(new SwaggerMethod(method)));
    }

    public String getLabel() {
        return this.resourceGroup.getLabel();
    }

    public String getDeprecated() {
        return this.resourceGroup.getDeprecated();
    }
}

