/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.swagger;

import com.webcohesion.enunciate.api.resources.Entity;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.StatusCode;
import com.webcohesion.enunciate.modules.swagger.SwaggerResponse;
import com.webcohesion.enunciate.util.freemarker.FreemarkerUtil;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ResponsesOfMethod
implements TemplateMethodModelEx {
    private static final Set<String> DEFAULT_201_METHODS = new TreeSet<String>(Collections.singletonList("POST"));
    private static final Set<String> DEFAULT_204_METHODS = new TreeSet<String>(Arrays.asList("PATCH", "PUT", "DELETE"));

    public Object exec(List list) throws TemplateModelException {
        if (list.size() < 1) {
            throw new TemplateModelException("The responsesOf method must have a parameter.");
        }
        TemplateModel from = (TemplateModel)list.get(0);
        Object unwrapped = FreemarkerUtil.unwrap((TemplateModel)from);
        if (unwrapped instanceof Method) {
            Method method = (Method)unwrapped;
            TreeSet<SwaggerResponse> responses = new TreeSet<SwaggerResponse>(Comparator.comparingInt(SwaggerResponse::getCode));
            List successHeaders = method.getResponseHeaders();
            Entity responseEntity = method.getResponseEntity();
            boolean successResponseFound = false;
            if (method.getResponseCodes() != null) {
                for (StatusCode code : method.getResponseCodes()) {
                    boolean successResponse = code.getCode() >= 200 && code.getCode() < 300;
                    List headers = successResponse ? successHeaders : Collections.emptyList();
                    responses.add(new SwaggerResponse(code.getCode(), code.getMediaTypes(), headers, code.getCondition()));
                    successResponseFound |= successResponse;
                }
            }
            if (!successResponseFound) {
                int code = DEFAULT_201_METHODS.contains(method.getHttpMethod().toUpperCase()) ? 201 : (DEFAULT_204_METHODS.contains(method.getHttpMethod().toUpperCase()) ? 204 : 200);
                String description = responseEntity != null ? responseEntity.getDescription() : "Success";
                responses.add(new SwaggerResponse(code, responseEntity != null ? responseEntity.getMediaTypes() : Collections.emptyList(), successHeaders, description));
            }
            return responses;
        }
        throw new TemplateModelException("No responses for: " + unwrapped);
    }
}

