/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.swagger;

import com.webcohesion.enunciate.api.resources.Entity;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.lang.model.element.AnnotationMirror;

public class SwaggerEntity
implements Entity {
    private final List<Entity> delegates;

    public SwaggerEntity(List<Entity> delegates) {
        this.delegates = delegates;
    }

    private <R> R doDelegation(Function<Entity, R> accessor) {
        return this.delegates.stream().map(accessor).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)this.doDelegation(delegate -> delegate.getAnnotation(annotationType));
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        LinkedHashMap<String, AnnotationMirror> annotations = new LinkedHashMap<String, AnnotationMirror>();
        this.delegates.forEach(delegate -> annotations.putAll(delegate.getAnnotations()));
        return annotations;
    }

    public String getDescription() {
        return this.doDelegation(Entity::getDescription);
    }

    public List<? extends MediaTypeDescriptor> getMediaTypes() {
        ArrayList mediaTypes = new ArrayList();
        this.delegates.forEach(delegate -> mediaTypes.addAll(delegate.getMediaTypes()));
        return mediaTypes;
    }

    public JavaDoc getJavaDoc() {
        return this.doDelegation(Entity::getJavaDoc);
    }

    public boolean isRequired() {
        return this.delegates.stream().anyMatch(Entity::isRequired);
    }
}

