/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.swagger;

import com.webcohesion.enunciate.api.resources.Entity;
import com.webcohesion.enunciate.api.resources.Example;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Parameter;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.StatusCode;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.modules.swagger.SwaggerEntity;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import org.apache.commons.lang3.StringUtils;

public class SwaggerMethod
implements Method {
    private final String httpMethod;
    private final List<Method> delegates = new ArrayList<Method>();

    public SwaggerMethod(Method delegate) {
        this.delegates.add(delegate);
        this.httpMethod = delegate.getHttpMethod();
    }

    public void merge(Method delegate) {
        if (!StringUtils.equals((CharSequence)delegate.getHttpMethod(), (CharSequence)this.httpMethod)) {
            throw new IllegalArgumentException();
        }
        this.delegates.add(delegate);
    }

    private <R> R doDelegation(Function<Method, R> accessor) {
        return this.delegates.stream().map(accessor).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)this.doDelegation(delegate -> delegate.getAnnotation(annotationType));
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        LinkedHashMap<String, AnnotationMirror> annotations = new LinkedHashMap<String, AnnotationMirror>();
        this.delegates.forEach(delegate -> annotations.putAll(delegate.getAnnotations()));
        return annotations;
    }

    public Set<String> getStyles() {
        TreeSet<String> styles = new TreeSet<String>();
        this.delegates.forEach(delegate -> styles.addAll(delegate.getStyles()));
        return styles;
    }

    public Resource getResource() {
        return this.doDelegation(Method::getResource);
    }

    public String getLabel() {
        return this.doDelegation(Method::getLabel);
    }

    public String getDeveloperLabel() {
        return this.doDelegation(Method::getDeveloperLabel);
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getSlug() {
        return this.doDelegation(Method::getSlug);
    }

    public String getSummary() {
        return this.doDelegation(Method::getSummary);
    }

    public String getDescription() {
        return this.doDelegation(Method::getDescription);
    }

    public String getDeprecated() {
        return this.doDelegation(Method::getDeprecated);
    }

    public String getSince() {
        return this.doDelegation(Method::getSince);
    }

    public List<String> getSeeAlso() {
        ArrayList<String> seeAlsos = new ArrayList<String>();
        this.delegates.forEach(delegate -> seeAlsos.addAll(delegate.getSeeAlso()));
        return seeAlsos;
    }

    public String getVersion() {
        return this.doDelegation(Method::getVersion);
    }

    public boolean isIncludeDefaultParameterValues() {
        return this.delegates.stream().anyMatch(Method::isIncludeDefaultParameterValues);
    }

    public List<? extends Parameter> getParameters() {
        TreeSet<Parameter> alreadyDeclaredParams = new TreeSet<Parameter>(Comparator.comparing(Parameter::getName));
        ArrayList parameters = new ArrayList();
        this.delegates.stream().flatMap(delegate -> delegate.getParameters().stream()).filter(alreadyDeclaredParams::add).forEach(parameters::add);
        return parameters;
    }

    public boolean isHasParameterConstraints() {
        return this.delegates.stream().anyMatch(Method::isHasParameterConstraints);
    }

    public boolean isHasParameterMultiplicity() {
        return this.delegates.stream().anyMatch(Method::isHasParameterMultiplicity);
    }

    public Entity getRequestEntity() {
        List<Entity> requestEntities = this.delegates.stream().map(Method::getRequestEntity).filter(Objects::nonNull).collect(Collectors.toList());
        return requestEntities.isEmpty() ? null : new SwaggerEntity(requestEntities);
    }

    public List<? extends StatusCode> getResponseCodes() {
        ArrayList statusCodes = new ArrayList();
        this.delegates.forEach(delegate -> statusCodes.addAll(delegate.getResponseCodes()));
        return statusCodes;
    }

    public Entity getResponseEntity() {
        List<Entity> responseEntities = this.delegates.stream().map(Method::getResponseEntity).filter(Objects::nonNull).collect(Collectors.toList());
        return responseEntities.isEmpty() ? null : new SwaggerEntity(responseEntities);
    }

    public List<? extends StatusCode> getWarnings() {
        ArrayList statusCodes = new ArrayList();
        this.delegates.forEach(delegate -> statusCodes.addAll(delegate.getWarnings()));
        return statusCodes;
    }

    public List<? extends Parameter> getResponseHeaders() {
        TreeSet<Parameter> alreadyDeclared = new TreeSet<Parameter>(Comparator.comparing(Parameter::getName));
        ArrayList parameters = new ArrayList();
        this.delegates.stream().flatMap(delegate -> delegate.getResponseHeaders().stream()).filter(alreadyDeclared::add).forEach(parameters::add);
        return parameters;
    }

    public Set<String> getSecurityRoles() {
        TreeSet<String> securityRoles = new TreeSet<String>();
        this.delegates.forEach(delegate -> securityRoles.addAll(delegate.getSecurityRoles()));
        return securityRoles;
    }

    public JavaDoc getJavaDoc() {
        return this.doDelegation(Method::getJavaDoc);
    }

    public Example getExample() {
        return this.doDelegation(Method::getExample);
    }

    public Set<Facet> getFacets() {
        TreeSet<Facet> facets = new TreeSet<Facet>();
        this.delegates.forEach(delegate -> facets.addAll(delegate.getFacets()));
        return facets;
    }
}

