package com.webengage.sdk.android.actions.rules;


import android.content.Context;

import com.webengage.sdk.android.EventName;
import com.webengage.sdk.android.EventPayload;
import com.webengage.sdk.android.Subscriber;
import com.webengage.sdk.android.Topic;
import com.webengage.sdk.android.utils.WebEngageConstant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RuleExecutionController implements Subscriber {

    protected static final String RULE_EXECUTION_CHAIN = "execution_chain";
    protected static final String EVENT_STATE_DATA = "event_state_data";
    private Context applicationContext = null;
    private static RuleExecutionController instance = null;

    public static final Factory FACTORY = new Factory() {
        @Override
        public Subscriber initialize(Context context) {
            if (instance == null) {
                instance = new RuleExecutionController(context);
            }
            return instance;
        }
    };

    private RuleExecutionController(Context context) {
        this.applicationContext = context.getApplicationContext();
    }

    @Override
    public void createAction(Topic topic, Object data) {
        Map<String, Object> actionAttributes = getActionAttributes(topic, data);
        if (actionAttributes.get(RULE_EXECUTION_CHAIN) != null) {
            RuleExecutionAction action = new RuleExecutionAction(applicationContext);
            action.performActionSync(actionAttributes);
        }
    }

    @Override
    public boolean validateData(Object data) {
        return false;
    }

    @Override
    public Map<String, Object> getActionAttributes(Topic topic, Object data) {
        Map<String, Object> actionAttributes = new HashMap<String, Object>();
        if (data instanceof EventPayload) {
            List<WebEngageConstant.RuleCategory> executionChain = new ArrayList<WebEngageConstant.RuleCategory>();
            EventPayload eventPayload = (EventPayload) data;
            String event = eventPayload.getEventName();
            if (event != null && WebEngageConstant.SYSTEM.equals(eventPayload.getCategory())) {
                if (EventName.VISITOR_NEW_SESSION.equals(event)) {
                    executionChain.add(WebEngageConstant.RuleCategory.SESSION_RULE);
                    executionChain.add(WebEngageConstant.RuleCategory.PAGE_RULE);
                    actionAttributes.put(RULE_EXECUTION_CHAIN, executionChain);
                } else if (EventName.WE_WK_SCREEN_NAVIGATED.equals(event)) {
                    executionChain.add(WebEngageConstant.RuleCategory.PAGE_RULE);
                    actionAttributes.put(RULE_EXECUTION_CHAIN, executionChain);
                } else if (EventName.USER_UPDATE.equals(event) || EventName.USER_UPDATE_GEO_INFO.equals(event) || EventName.USER_DELETE_ATTRIBUTES.equals(event)) {
                    executionChain.add(WebEngageConstant.RuleCategory.SESSION_RULE);
                    executionChain.add(WebEngageConstant.RuleCategory.PAGE_RULE);
                    actionAttributes.put(RULE_EXECUTION_CHAIN, executionChain);
                } else if (EventName.USER_LOGGED_IN.equals(event)) {
                    executionChain.add(WebEngageConstant.RuleCategory.SESSION_RULE);
                    executionChain.add(WebEngageConstant.RuleCategory.PAGE_RULE);
                    executionChain.add(WebEngageConstant.RuleCategory.EVENT_RULE);
                    actionAttributes.put(RULE_EXECUTION_CHAIN, executionChain);
                } else if (EventName.NOTIFICATION_CLOSE.equals(event) || EventName.NOTIFICATION_CLICK.equals(event) || EventName.NOTIFICATION_VIEW.equals(event) || EventName.NOTIFICATION_CONTROL_GROUP.equals(event)) {
                    executionChain.add(WebEngageConstant.RuleCategory.PAGE_RULE);
                    executionChain.add(WebEngageConstant.RuleCategory.EVENT_RULE);
                    actionAttributes.put(RULE_EXECUTION_CHAIN, executionChain);
                } else if (EventName.PUSH_NOTIFICATION_CLICK.equals(event) || EventName.PUSH_NOTIFICATION_CLOSE.equals(event) || EventName.PUSH_NOTIFICATION_VIEW.equals(event) || EventName.PUSH_NOTIFICATION_RECEIVED.equals(event) || EventName.WE_WK_PUSH_NOTIFICATION_RERENDER.equals(event) || EventName.PUSH_NOTIFICATION_ITEM_VIEW.equals(event) || EventName.APP_INSTALLED.equals(event) || EventName.APP_UPGRADED.equals(event) || EventName.USER_LOGGED_OUT.equals(event) || EventName.WE_WK_PAGE_DELAY.equals(event) || EventName.WE_WK_SESSION_DELAY.equals(event) || EventName.APP_CRASHED.equals(event)) {
                    executionChain.add(WebEngageConstant.RuleCategory.EVENT_RULE);
                    actionAttributes.put(RULE_EXECUTION_CHAIN, executionChain);
                }

            } else {
                executionChain.add(WebEngageConstant.RuleCategory.EVENT_RULE);
                actionAttributes.put(RULE_EXECUTION_CHAIN, executionChain);
            }

            actionAttributes.put(EVENT_STATE_DATA, eventPayload);

        } else {
            actionAttributes.put(RULE_EXECUTION_CHAIN, data);
        }


        return actionAttributes;
    }

}
