/*
 * Decompiled with CFR 0.152.
 */
package com.webengage.sdk.android.actions.render;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import com.webengage.sdk.android.Logger;
import com.webengage.sdk.android.WebEngage;
import com.webengage.sdk.android.actions.render.CallToAction;
import com.webengage.sdk.android.actions.render.CarouselV1CallToAction;
import com.webengage.sdk.android.actions.render.b;
import com.webengage.sdk.android.utils.WebEngageConstant;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class PushNotificationData
extends b {
    private JSONObject bigNotificationData;
    private BigPictureStyle bigPictureStyle;
    private BigTextStyle bigTextStyle;
    private InboxStyle inboxStyle;
    private CarouselV1 carouselV1;
    private RatingV1 ratingV1;
    private String style;
    private Bitmap largeIcon;
    private int smallIcon;
    private String appName;
    private boolean autoExpand;
    private List<CallToAction> callToActions;
    private int accentColor;
    private JSONObject cta;
    private int currentIndex;
    private boolean isSticky;
    private int backgroundColor;

    /*
     * WARNING - void declaration
     */
    public PushNotificationData(JSONObject json, Context context) {
        Object object;
        block21: {
            int n2;
            void var2_3;
            super((JSONObject)object, "system_tray", (Context)var2_3);
            this.bigNotificationData = null;
            this.bigPictureStyle = null;
            this.bigTextStyle = null;
            this.inboxStyle = null;
            this.carouselV1 = null;
            this.ratingV1 = null;
            this.style = null;
            this.largeIcon = null;
            this.smallIcon = -1;
            this.appName = null;
            this.autoExpand = true;
            this.accentColor = -1;
            this.currentIndex = 0;
            this.isSticky = false;
            this.backgroundColor = Color.parseColor((String)"#00000000");
            JSONObject jSONObject = json.isNull("expandableDetails") ? null : object.optJSONObject("expandableDetails");
            this.bigNotificationData = jSONObject;
            this.callToActions = this.readCallToActions((JSONObject)object, (Context)var2_3);
            this.accentColor = WebEngage.get().getWebEngageConfig().getAccentColor();
            this.smallIcon = WebEngage.get().getWebEngageConfig().getPushSmallIcon();
            if (this.smallIcon == -1) {
                this.smallIcon = var2_3.getApplicationContext().getApplicationInfo().icon;
            }
            this.largeIcon = (n2 = WebEngage.get().getWebEngageConfig().getPushLargeIcon()) == -1 ? BitmapFactory.decodeResource((Resources)var2_3.getApplicationContext().getResources(), (int)var2_3.getApplicationContext().getApplicationInfo().icon) : BitmapFactory.decodeResource((Resources)var2_3.getApplicationContext().getResources(), (int)n2);
            if (this.largeIcon == null) {
                Logger.d("WebEngage", "large icon is not available in the resources. Creating Bitmap from app icon");
                this.largeIcon = this.createBitmapFromDrawable(var2_3.getPackageManager().getApplicationIcon(var2_3.getApplicationInfo()));
            }
            if (this.appName == null) {
                try {
                    this.appName = var2_3.getApplicationInfo().loadLabel(var2_3.getPackageManager()).toString();
                }
                catch (Exception exception) {
                    Logger.e("WebEngage", exception.toString() + " loading app name");
                }
            }
            this.isSticky = object.optBoolean("s", false);
            if (!object.isNull("bckColor")) {
                if (TextUtils.isEmpty((CharSequence)object.getString("bckColor"))) break block21;
                this.backgroundColor = Color.parseColor((String)object.getString("bckColor"));
                try {
                    Logger.d("WebEngage", "BackGround color : " + this.backgroundColor);
                }
                catch (Exception exception) {
                    Logger.e("WebEngage", "Exception while parsing bckColor " + exception.toString());
                    this.backgroundColor = Color.parseColor((String)"#00000000");
                    Logger.d("WebEngage", "BackGround color : " + this.backgroundColor);
                }
            }
        }
        if ((object = this.bigNotificationData) != null && !object.isNull("style")) {
            object = this.bigNotificationData.optString("style");
            this.style = object;
            if ("BIG_TEXT".equalsIgnoreCase((String)object)) {
                BigTextStyle bigTextStyle;
                object = bigTextStyle;
                bigTextStyle = new BigTextStyle(this, this.bigNotificationData);
                this.bigTextStyle = object;
            } else if ("BIG_PICTURE".equalsIgnoreCase(this.style)) {
                BigPictureStyle bigPictureStyle;
                object = bigPictureStyle;
                bigPictureStyle = new BigPictureStyle(this, this.bigNotificationData);
                this.bigPictureStyle = object;
            } else if ("INBOX".equalsIgnoreCase(this.style)) {
                InboxStyle inboxStyle;
                object = inboxStyle;
                inboxStyle = new InboxStyle(this, this.bigNotificationData);
                this.inboxStyle = object;
            } else if ("CAROUSEL_V1".equalsIgnoreCase(this.style)) {
                CarouselV1 carouselV1;
                object = carouselV1;
                PushNotificationData pushNotificationData = this;
                this.carouselV1 = new CarouselV1(pushNotificationData, pushNotificationData.bigNotificationData);
                this.callToActions.addAll(((CarouselV1)object).getCallToActions());
            } else if ("RATING_V1".equalsIgnoreCase(this.style)) {
                RatingV1 ratingV1;
                object = ratingV1;
                PushNotificationData pushNotificationData = this;
                this.ratingV1 = new RatingV1(pushNotificationData, pushNotificationData.bigNotificationData);
                if (((RatingV1)object).getSubmitCTA() != null) {
                    this.callToActions.add(this.ratingV1.getSubmitCTA());
                }
            }
        }
    }

    private List<CallToAction> readCallToActions(JSONObject jsonObject, Context context) {
        ArrayList<CallToAction> arrayList;
        Object object;
        JSONObject jSONObject = jsonObject.isNull("expandableDetails") ? null : object.optJSONObject("expandableDetails");
        ArrayList<CallToAction> arrayList2 = arrayList;
        arrayList = new ArrayList<CallToAction>();
        object = object.isNull("cta") ? null : object.optJSONObject("cta");
        ((PushNotificationData)object2).cta = object;
        if (object != null) {
            if (!object.isNull("id")) {
                PushNotificationData pushNotificationData = object2;
                object = pushNotificationData.cta.optString("id");
                String string = pushNotificationData.getContentText();
                arrayList2.add(new CallToAction((String)object, string, ((PushNotificationData)object2).cta.optString("actionLink"), true, true));
            }
        } else {
            CallToAction callToAction;
            object = callToAction;
            callToAction = new CallToAction(null, ((PushNotificationData)object2).getContentText(), null, true, true);
            arrayList2.add((CallToAction)object);
        }
        if (jSONObject != null) {
            object = jSONObject.isNull("cta1") ? null : jSONObject.optJSONObject("cta1");
            ((PushNotificationData)object2).cta = object;
            if (object != null) {
                if (!object.isNull("id") && !((PushNotificationData)object2).cta.isNull("rat")) {
                    PushNotificationData pushNotificationData = object2;
                    object = pushNotificationData.cta.optString("rat");
                    arrayList2.add(new CallToAction(((PushNotificationData)object2).cta.optString("id"), (String)object, pushNotificationData.cta.optString("actionLink"), false, true));
                } else if (!((PushNotificationData)object2).cta.isNull("id") && !((PushNotificationData)object2).cta.isNull("actionText")) {
                    PushNotificationData pushNotificationData = object2;
                    object = pushNotificationData.cta.optString("actionText");
                    arrayList2.add(new CallToAction(((PushNotificationData)object2).cta.optString("id"), (String)object, pushNotificationData.cta.optString("actionLink"), false, true));
                }
            }
            object = jSONObject.isNull("cta2") ? null : jSONObject.optJSONObject("cta2");
            ((PushNotificationData)object2).cta = object;
            if (object != null) {
                if (!object.isNull("id") && !((PushNotificationData)object2).cta.isNull("rat")) {
                    PushNotificationData pushNotificationData = object2;
                    object = pushNotificationData.cta.optString("rat");
                    arrayList2.add(new CallToAction(((PushNotificationData)object2).cta.optString("id"), (String)object, pushNotificationData.cta.optString("actionLink"), false, true));
                } else if (!((PushNotificationData)object2).cta.isNull("id") && !((PushNotificationData)object2).cta.isNull("actionText")) {
                    PushNotificationData pushNotificationData = object2;
                    object = pushNotificationData.cta.optString("actionText");
                    arrayList2.add(new CallToAction(((PushNotificationData)object2).cta.optString("id"), (String)object, pushNotificationData.cta.optString("actionLink"), false, true));
                }
            }
            object = jSONObject.isNull("cta3") ? null : jSONObject.optJSONObject("cta3");
            ((PushNotificationData)object2).cta = object;
            if (object != null) {
                Object object2;
                if (!object.isNull("id") && !((PushNotificationData)object2).cta.isNull("rat")) {
                    PushNotificationData pushNotificationData = object2;
                    object2 = pushNotificationData.cta.optString("rat");
                    arrayList2.add(new CallToAction(((PushNotificationData)object2).cta.optString("id"), (String)object2, pushNotificationData.cta.optString("actionLink"), false, true));
                } else if (!((PushNotificationData)object2).cta.isNull("id") && !((PushNotificationData)object2).cta.isNull("actionText")) {
                    Object object3 = object2;
                    object2 = ((PushNotificationData)object3).cta.optString("actionText");
                    arrayList2.add(new CallToAction(((PushNotificationData)object2).cta.optString("id"), (String)object2, ((PushNotificationData)object3).cta.optString("actionLink"), false, true));
                }
            }
        }
        return arrayList2;
    }

    private Bitmap createBitmapFromDrawable(Drawable drawable) {
        if (drawable != null) {
            Canvas canvas;
            Canvas canvas2;
            PushNotificationData pushNotificationData = Bitmap.createBitmap((int)canvas2.getIntrinsicWidth(), (int)canvas2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            void v02 = canvas2;
            canvas2 = canvas;
            int n2 = new Canvas((Bitmap)pushNotificationData).getWidth();
            int n3 = canvas2.getHeight();
            v02.setBounds(0, 0, n2, n3);
            v02.draw(canvas2);
            return pushNotificationData;
        }
        return null;
    }

    public List<CallToAction> getCallToActions() {
        return this.callToActions;
    }

    public CallToAction getPrimeCallToAction() {
        List<CallToAction> object2 = ((PushNotificationData)this).callToActions;
        if (object2 != null && object2.size() > 0) {
            for (CallToAction callToAction : ((PushNotificationData)this).callToActions) {
                if (callToAction == null || !callToAction.isPrimeAction()) continue;
                return callToAction;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public CallToAction getCallToActionById(String id) {
        void var1_1;
        List<CallToAction> object2 = ((PushNotificationData)this).callToActions;
        if (object2 != null && object2.size() > 0 && var1_1 != null && !var1_1.isEmpty()) {
            for (CallToAction callToAction : ((PushNotificationData)this).callToActions) {
                if (callToAction == null || !var1_1.equals(callToAction.getId())) continue;
                return callToAction;
            }
        }
        return null;
    }

    public List<CallToAction> getActions() {
        List<CallToAction> list = ((PushNotificationData)this_).callToActions;
        if (list != null && list.size() > 0) {
            PushNotificationData pushNotificationData = this_;
            Object this_ = null;
            for (CallToAction callToAction : pushNotificationData.callToActions) {
                if (callToAction == null || callToAction.isPrimeAction() || !callToAction.isNative()) continue;
                if (this_ == null) {
                    ArrayList arrayList;
                    this_ = arrayList;
                    arrayList = new ArrayList();
                }
                this_.add(callToAction);
            }
            return this_;
        }
        return null;
    }

    public boolean getAutoExpand() {
        return this.autoExpand;
    }

    /*
     * WARNING - void declaration
     */
    public void setAutoExpand(boolean autoExpand) {
        void var1_1;
        this.autoExpand = var1_1;
    }

    public boolean isBigNotification() {
        return this.bigNotificationData != null;
    }

    public Bitmap getLargeIcon() {
        return this.largeIcon;
    }

    public int getAccentColor() {
        return this.accentColor;
    }

    /*
     * WARNING - void declaration
     */
    public void setAccentColor(int accentColor) {
        void var1_1;
        this.accentColor = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSmallIcon(int resourceId) {
        void var1_1;
        this.smallIcon = var1_1;
    }

    public int getSmallIcon() {
        return this.smallIcon;
    }

    public String getAppName() {
        return this.appName;
    }

    /*
     * WARNING - void declaration
     */
    public void setLargerIcon(Bitmap largeIcon) {
        void var1_1;
        this.largeIcon = var1_1;
    }

    public WebEngageConstant.STYLE getStyle() {
        try {
            return WebEngageConstant.STYLE.valueOf(this.style);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BigTextStyle getBigTextStyleData() {
        return this.bigTextStyle;
    }

    public BigPictureStyle getBigPictureStyleData() {
        return this.bigPictureStyle;
    }

    public InboxStyle getInboxStyleData() {
        return this.inboxStyle;
    }

    public CarouselV1 getCarouselV1Data() {
        return this.carouselV1;
    }

    public RatingV1 getRatingV1() {
        return this.ratingV1;
    }

    public boolean isCustomRender() {
        return (this = this.getCustomData()) != null && this.containsKey("we_custom_render") && Boolean.parseBoolean(this.getString("we_custom_render"));
    }

    /*
     * WARNING - void declaration
     */
    public void setCurrentIndex(int currentIndex) {
        void var1_1;
        this.currentIndex = var1_1;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public boolean isSticky() {
        return this.isSticky;
    }

    /*
     * WARNING - void declaration
     */
    public void setSticky(boolean sticky) {
        void var1_1;
        this.isSticky = var1_1;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    /*
     * WARNING - void declaration
     */
    public void setBackgroundColor(int backgroundColor) {
        void var1_1;
        this.backgroundColor = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o2) {
        void var1_1;
        if (!(o2 instanceof PushNotificationData)) {
            return false;
        }
        PushNotificationData pushNotificationData = pushNotificationData2;
        PushNotificationData pushNotificationData2 = (PushNotificationData)var1_1;
        return pushNotificationData.getExperimentId().equals(pushNotificationData2.getExperimentId());
    }

    public int hashCode() {
        return this.getExperimentId().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        String string = System.getProperty("line.separator");
        new StringBuilder().append(this.getClass().getName() + " Object { " + string);
        stringBuilder2.append(" Experiment Id : " + this.getExperimentId() + string);
        stringBuilder2.append(" Variation Id : " + this.getVariationId() + string);
        stringBuilder2.append(" Title : " + this.getTitle() + string);
        stringBuilder2.append(" Message : " + this.getContentText() + string);
        StringBuilder stringBuilder3 = new StringBuilder().append("Summary : ");
        String string2 = this.getContentSummary() != null ? this.getContentSummary() : "null";
        stringBuilder2.append(stringBuilder3.append(string2).append(string).toString());
        if (this.getPrimeCallToAction() != null) {
            stringBuilder2.append(" Main CTA : " + this.getPrimeCallToAction() + " ID : " + this.getPrimeCallToAction().getId() + string);
        }
        stringBuilder3 = new StringBuilder().append(" Custom Data : ");
        string2 = this.getCustomData() != null ? this.getCustomData().toString() : "null";
        stringBuilder2.append(stringBuilder3.append(string2).append(string).toString());
        if (this.bigNotificationData != null) {
            stringBuilder2.append(" Expandable Details : " + this.bigNotificationData.toString() + string);
        }
        StringBuilder stringBuilder4 = stringBuilder2;
        stringBuilder4.append(" Amplified: " + this.isAmplified() + string);
        stringBuilder4.append("}");
        return stringBuilder4.toString();
    }

    public class RatingV1
    extends BaseStyleData {
        private int contentBackgroundColor;
        private String imageUrl;
        private String contentTitle;
        private String contentMessage;
        private String iconUrl;
        private int rateScale;
        private int contentTextColor;
        private CallToAction submitCTA;
        private int rateValue;
        final /* synthetic */ PushNotificationData this$0;

        public RatingV1(PushNotificationData this$0, JSONObject jsonObject) {
            CallToAction callToAction;
            String string;
            ((RatingV1)object).this$0 = string;
            super((PushNotificationData)((Object)string), (JSONObject)callToAction);
            ((RatingV1)object).contentBackgroundColor = Color.parseColor((String)"#00000000");
            ((RatingV1)object).imageUrl = null;
            ((RatingV1)object).contentTitle = null;
            ((RatingV1)object).contentMessage = null;
            ((RatingV1)object).iconUrl = null;
            ((RatingV1)object).rateScale = 5;
            ((RatingV1)object).contentTextColor = Color.parseColor((String)"#000000");
            ((RatingV1)object).submitCTA = null;
            ((RatingV1)object).rateValue = -1;
            if (jsonObject != null) {
                Object object;
                String string2;
                string = callToAction.isNull("image") ? null : callToAction.optString("image");
                ((RatingV1)object).imageUrl = string;
                string = callToAction.isNull("icon") ? null : callToAction.optString("icon");
                ((RatingV1)object).iconUrl = string;
                ((RatingV1)object).rateScale = callToAction.optInt("rateScale", 5);
                string = callToAction.optJSONObject("content");
                if (string != null) {
                    string2 = string.isNull("title") ? null : string.optString("title");
                    ((RatingV1)object).contentTitle = string2;
                    string2 = string.isNull("message") ? null : string.optString("message");
                    ((RatingV1)object).contentMessage = string2;
                    if (!string.isNull("textColor")) {
                        ((RatingV1)object).contentTextColor = Color.parseColor((String)string.optString("textColor"));
                    }
                    if (!string.isNull("bckColor")) {
                        try {
                            ((RatingV1)object).contentBackgroundColor = Color.parseColor((String)string.optString("bckColor"));
                        }
                        catch (Exception exception) {
                            Logger.e("WebEngage", "Error parsing bckColor. Not setting background color");
                        }
                    }
                }
                if ((string = callToAction.optJSONObject("submitCTA")) != null) {
                    String string3 = string;
                    string2 = string3.optString("id");
                    String string4 = string3.isNull("actionText") ? "Submit" : string.optString("actionText");
                    Object object2 = object;
                    object = string.optString("actionLink");
                    ((RatingV1)object2).submitCTA = callToAction = new CallToAction(string2, string4, (String)object, false, false);
                } else {
                    CallToAction callToAction2;
                    RatingV1 ratingV1 = object;
                    object = callToAction2;
                    callToAction2 = new CallToAction(null, "Submit", null, false, false);
                    ratingV1.submitCTA = object;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public void setRateValue(int rateValue) {
            void var1_1;
            this.rateValue = var1_1;
        }

        public int getRateValue() {
            return this.rateValue;
        }

        public String getImageUrl() {
            return this.imageUrl;
        }

        public String getContentTitle() {
            return this.contentTitle;
        }

        public String getContentMessage() {
            return this.contentMessage;
        }

        public String getIconUrl() {
            return this.iconUrl;
        }

        public int getRateScale() {
            return this.rateScale;
        }

        public int getContentTextColor() {
            return this.contentTextColor;
        }

        public int getContentBackgroundColor() {
            return this.contentBackgroundColor;
        }

        public CallToAction getSubmitCTA() {
            return this.submitCTA;
        }
    }

    public class CarouselV1
    extends BaseStyleData {
        private List<CarouselV1CallToAction> callToActions;
        private final String MODE;
        private int size;
        private int autoScrollTime;
        final /* synthetic */ PushNotificationData this$0;

        /*
         * WARNING - void declaration
         */
        public CarouselV1(PushNotificationData this$0, JSONObject jsonObject) {
            JSONArray jSONArray;
            void var2_2;
            JSONArray jSONArray2;
            this.this$0 = jSONArray2;
            super((PushNotificationData)jSONArray2, (JSONObject)var2_2);
            this.callToActions = null;
            this.size = 0;
            this.autoScrollTime = -1;
            jSONArray2 = jSONArray;
            jSONArray = new ArrayList();
            this.callToActions = jSONArray2;
            jSONArray2 = jsonObject.optJSONArray("items");
            if (jSONArray2 != null) {
                this.size = jSONArray2.length();
                for (int i2 = 0; i2 < jSONArray2.length(); ++i2) {
                    Object object = jSONArray2.optJSONObject(i2);
                    if (object == null || object.isNull("id") || object.isNull("image")) continue;
                    JSONObject jSONObject = object;
                    object = jSONObject.optString("id");
                    String string = jSONObject.optString("actionText");
                    String string2 = jSONObject.optString("actionLink");
                    String string3 = jSONObject.optString("image");
                    this.callToActions.add(new CarouselV1CallToAction((String)object, string, string2, string3));
                }
            }
            this.MODE = var2_2.optString("mode", "landscape");
            this.autoScrollTime = var2_2.optInt("ast", -1);
        }

        public List<CarouselV1CallToAction> getCallToActions() {
            return this.callToActions;
        }

        /*
         * WARNING - void declaration
         */
        public void setCallToActions(List<CarouselV1CallToAction> callToActions) {
            void var1_1;
            this.callToActions = var1_1;
        }

        public String getMODE() {
            return this.MODE;
        }

        protected int getSize() {
            return this.size;
        }

        public int getAutoScrollTime() {
            return this.autoScrollTime;
        }

        /*
         * WARNING - void declaration
         */
        public void setAutoScrollTime(int autoScrollTime) {
            void var1_1;
            this.autoScrollTime = var1_1;
        }
    }

    public class InboxStyle
    extends BaseStyleData {
        private List<String> lines;
        final /* synthetic */ PushNotificationData this$0;

        public InboxStyle(PushNotificationData this$0, JSONObject json) {
            LinkedList<String> linkedList;
            JSONArray jSONArray;
            this.this$0 = jSONArray;
            super((PushNotificationData)jSONArray, (JSONObject)linkedList);
            this.lines = null;
            jSONArray = json.isNull("lines") ? null : linkedList.optJSONArray("lines");
            if (jSONArray != null) {
                LinkedList<String> linkedList2;
                linkedList = linkedList2;
                linkedList2 = new LinkedList<String>();
                this.lines = linkedList;
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    this.lines.add(jSONArray.optString(i2));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public void setLines(List<String> lines) {
            void var1_1;
            this.lines = var1_1;
        }

        public List<String> getInboxLines() {
            return this.lines;
        }
    }

    public class BigPictureStyle
    extends BaseStyleData {
        private String bigPictureUrl;
        final /* synthetic */ PushNotificationData this$0;

        /*
         * WARNING - void declaration
         */
        public BigPictureStyle(PushNotificationData this$0, JSONObject json) {
            void var2_2;
            String string;
            this.this$0 = string;
            super((PushNotificationData)((Object)string), (JSONObject)var2_2);
            this.bigPictureUrl = null;
            string = json.isNull("image") ? null : var2_2.optString("image");
            this.bigPictureUrl = string;
        }

        /*
         * WARNING - void declaration
         */
        public void setBigPictureUrl(String url) {
            void var1_1;
            this.bigPictureUrl = var1_1;
        }

        public String getBigPictureUrl() {
            return this.bigPictureUrl;
        }
    }

    public class BigTextStyle
    extends BaseStyleData {
        private String bigText;
        final /* synthetic */ PushNotificationData this$0;

        /*
         * WARNING - void declaration
         */
        public BigTextStyle(PushNotificationData this$0, JSONObject json) {
            void var2_2;
            String string;
            this.this$0 = string;
            super((PushNotificationData)((Object)string), (JSONObject)var2_2);
            this.bigText = null;
            string = json.isNull("rm") ? ((PushNotificationData)((Object)string)).getContentText() : var2_2.optString("rm");
            this.bigText = string;
        }

        /*
         * WARNING - void declaration
         */
        public void setBigText(String bigText) {
            void var1_1;
            this.bigText = var1_1;
        }

        public String getBigText() {
            return this.bigText;
        }
    }

    public class BaseStyleData {
        private String bigContentTitle = null;
        private String message = null;
        private String summary = null;
        final /* synthetic */ PushNotificationData this$0;

        /*
         * WARNING - void declaration
         */
        public BaseStyleData(PushNotificationData this$0, JSONObject json) {
            void var2_2;
            String string;
            this.this$0 = string;
            String string2 = json.isNull("rt") ? ((PushNotificationData)((Object)string)).getTitle() : var2_2.optString("rt");
            this.bigContentTitle = string2;
            string2 = var2_2.isNull("rm") ? ((PushNotificationData)((Object)string)).getContentText() : var2_2.optString("rm");
            this.message = string2;
            string = var2_2.isNull("rst") ? ((PushNotificationData)((Object)string)).getContentSummary() : var2_2.optString("rst");
            this.summary = string;
        }

        /*
         * WARNING - void declaration
         */
        public void setBigContentTitle(String bigContentTitle) {
            void var1_1;
            this.bigContentTitle = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setMessage(String message) {
            void var1_1;
            this.message = var1_1;
        }

        public String getBigContentTitle() {
            return this.bigContentTitle;
        }

        public String getMessage() {
            return this.message;
        }

        public String getSummary() {
            return this.summary;
        }

        /*
         * WARNING - void declaration
         */
        public void setSummary(String summary) {
            void var1_1;
            this.summary = var1_1;
        }
    }
}

