package com.webengage.sdk.android;

import android.app.AppOpsManager;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Build;

import com.webengage.sdk.android.actions.database.DataHolder;
import com.webengage.sdk.android.actions.render.PushNotificationData;
import com.webengage.sdk.android.utils.ManifestUtils;
import com.webengage.sdk.android.utils.WebEngageConstant;

import org.json.JSONObject;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;

public class PushUtils {
    public static Map<String, String> prepareMap(String data) {
        Map<String, String> map = new HashMap<String, String>();
        try {
            JSONObject jsonObject = new JSONObject(data);
            Iterator<String> keysItr = jsonObject.keys();
            while (keysItr.hasNext()) {
                String key = keysItr.next();
                String value = jsonObject.getString(key);
                map.put(key, value);
            }
        } catch (Exception e) {
            // TODO Auto-generated catch block
        }
        return map;
    }

    /**
     * Checks if foreground service type is present in manifest for TimerService
     * @param mContext Context
     * @return foreground service can be used or not
     */
    public static boolean isForegroundServiceTypeAdded(Context mContext) {
        Integer foreGroundServiceType = null;
        try {
            PackageInfo packageInfo = mContext.getPackageManager().getPackageInfo(
                    mContext.getPackageName(),
                    PackageManager.GET_SERVICES | PackageManager.GET_PERMISSIONS
            );

            ServiceInfo[] services = packageInfo.services;
            for (ServiceInfo serviceInfo : services) {
                if (serviceInfo.name.equals(WebEngageConstant.TIMER_NOTIFICATION_SERVICE)) {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
                        foreGroundServiceType = serviceInfo.getForegroundServiceType();
                    }
                }
            }

            if (foreGroundServiceType == null) {
                return false;
            }

            switch (foreGroundServiceType) {
                case ServiceInfo.FOREGROUND_SERVICE_TYPE_CAMERA:
                    return ManifestUtils.checkPermission(ManifestUtils.FOREGROUND_SERVICE_CAMERA_PERMISSION, mContext);
                case ServiceInfo.FOREGROUND_SERVICE_TYPE_CONNECTED_DEVICE:
                    return ManifestUtils.checkPermission(ManifestUtils.FOREGROUND_SERVICE_CONNECTED_DEVICE_PERMISSION, mContext);
                case ServiceInfo.FOREGROUND_SERVICE_TYPE_DATA_SYNC:
                    return ManifestUtils.checkPermission(ManifestUtils.FOREGROUND_SERVICE_DATA_SYNC_PERMISSION, mContext);
                case ServiceInfo.FOREGROUND_SERVICE_TYPE_HEALTH:
                    return ManifestUtils.checkPermission(ManifestUtils.FOREGROUND_SERVICE_HEALTH_PERMISSION, mContext);
                case ServiceInfo.FOREGROUND_SERVICE_TYPE_LOCATION:
                    return ManifestUtils.checkPermission(ManifestUtils.FOREGROUND_SERVICE_LOCATION_PERMISSION, mContext);
                case ServiceInfo.FOREGROUND_SERVICE_TYPE_MEDIA_PLAYBACK:
                    return ManifestUtils.checkPermission(ManifestUtils.FOREGROUND_SERVICE_MEDIA_PLAYBACK_PERMISSION, mContext);
                case ServiceInfo.FOREGROUND_SERVICE_TYPE_SPECIAL_USE:
                    return ManifestUtils.checkPermission(ManifestUtils.FOREGROUND_SERVICE_SPECIAL_USE_PERMISSION, mContext);
                case ServiceInfo.FOREGROUND_SERVICE_TYPE_REMOTE_MESSAGING:
                    return ManifestUtils.checkPermission(ManifestUtils.FOREGROUND_SERVICE_REMOTE_MESSAGING_PERMISSION, mContext);
                case ServiceInfo.FOREGROUND_SERVICE_TYPE_MEDIA_PROJECTION:
                    return ManifestUtils.checkPermission(ManifestUtils.FOREGROUND_SERVICE_MEDIA_PROJECTION_PERMISSION, mContext);
                case ServiceInfo.FOREGROUND_SERVICE_TYPE_PHONE_CALL:
                    return ManifestUtils.checkPermission(ManifestUtils.FOREGROUND_SERVICE_PHONE_CALL_PERMISSION, mContext);
                case ServiceInfo.FOREGROUND_SERVICE_TYPE_SHORT_SERVICE:
                    return true;
                case ServiceInfo.FOREGROUND_SERVICE_TYPE_SYSTEM_EXEMPTED:
                    return ManifestUtils.checkPermission(ManifestUtils.FOREGROUND_SERVICE_SYSTEM_EXEMPTED_PERMISSION, mContext);
                case ServiceInfo.FOREGROUND_SERVICE_TYPE_MICROPHONE:
                    return ManifestUtils.checkPermission(ManifestUtils.FOREGROUND_SERVICE_MICROPHONE_PERMISSION, mContext);
                default:
                    return false;
            }
        } catch (PackageManager.NameNotFoundException e) {
            Logger.d(WebEngageConstant.TAG,"Foreground service type name not found");
            return false;
        }
    }

    /**
     * Used for getting timezone w.r.t user or campaign
     */
    public static TimeZone getTimeZone(PushNotificationData pushNotificationData) {
        if (pushNotificationData.getTimerStyleData().getTimeZone().equals("USER")) {
            String timezoneId = TimeZone.getDefault().getID();
            return TimeZone.getTimeZone(timezoneId);
        } else if(pushNotificationData.getTimerStyleData().getTimeZone().equals("ACCOUNT")){
            long campaignOffset = DataHolder.get().getTZO();
            String customTimeZoneId = "GMT" + (campaignOffset >= 0 ? "+" : "") + campaignOffset / 3600 + ":" + (campaignOffset % 3600) / 60;
            return TimeZone.getTimeZone(customTimeZoneId);
        } else {
            return null;
        }
    }

    public static boolean checkForPushOptIn(Context applicationContext) {
        try {
            if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 24) {
                AppOpsManager appOps = (AppOpsManager) applicationContext.getSystemService(Context.APP_OPS_SERVICE);
                ApplicationInfo appInfo = applicationContext.getApplicationInfo();
                String pkg = applicationContext.getApplicationContext().getPackageName();
                int uid = appInfo.uid;
                try {
                    Class<?> appOpsClass = Class.forName(AppOpsManager.class.getName());
                    Method checkOpNoThrowMethod = appOpsClass.getMethod("checkOpNoThrow", Integer.TYPE,
                            Integer.TYPE, String.class);
                    Field opPostNotificationValue = appOpsClass.getDeclaredField("OP_POST_NOTIFICATION");
                    int value = (int) opPostNotificationValue.get(Integer.class);
                    return ((int) checkOpNoThrowMethod.invoke(appOps, value, uid, pkg)
                            == AppOpsManager.MODE_ALLOWED);
                } catch (ClassNotFoundException | NoSuchMethodException | NoSuchFieldException |
                         InvocationTargetException | IllegalAccessException | RuntimeException e) {
                    return true;
                }

            } else if (Build.VERSION.SDK_INT >= 24) {
                NotificationManager notificationManager = (NotificationManager) applicationContext.getSystemService(Context.NOTIFICATION_SERVICE);
                return notificationManager.areNotificationsEnabled();
            }
        } catch (Exception e) {

        }
        return true;
    }
}
