package com.webengage.sdk.android;

import android.util.Pair;

import com.webengage.sdk.android.actions.database.DataContainer;
import com.webengage.sdk.android.actions.database.DataHolder;
import com.webengage.sdk.android.utils.WebEngageConstant;
import com.webengage.sdk.android.utils.WebEngageUtils;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WELifecycleManager {
    private final String TAG = WELifecycleManager.class.getCanonicalName();
    public static volatile WELifecycleManager INSTANCE;
    private Long inAppFCCount;
    private long inAppFCTimeGap;
    private Long inLineFCCount;
    private long inLineFCTimeGap;

    public static synchronized WELifecycleManager get() {
        if (INSTANCE == null) {
            synchronized (WELifecycleManager.class) {
                if (INSTANCE == null) {
                    INSTANCE = new WELifecycleManager();
                }
            }
        }
        return INSTANCE;
    }

    public boolean evaluateLifecycleChecks(WebEngageConstant.Entity entity, Map<String, Object> entityObj,
                                           Map<String, Object> variationObj) {
        /**
         * Evaluate should happen in this sequence only
         * Check FC
         * Check max times
         * Check clicks and views
         * Check LC
         * Check base checks
         * **/
        String notificationEncId = (String) entityObj.get("notificationEncId");
        Long maxTimesPerUser = (Long) entityObj.get("maxTimesPerUser");
        Long totalViewCount = DataHolder.get().getEntityTotalViewCountPerScope(entityObj, entity);
        Long totalClickCount = DataHolder.get().getEntityTotalClickCountPerScope(entityObj, entity);
        Long totalCloseCountSession = DataHolder.get().getEntityTotalCloseCountInSessionPerScope(entityObj, entity);
        Long totalHideCountSession = DataHolder.get().getEntityTotalHideCountInSessionPerScope(entityObj, entity);
        String attributeKeyViewSessionCount = WebEngageConstant.SCOPE_SEPARATOR
                + WebEngageConstant.VIEW_SESSION;
        String attributeKeyLastUpdateTime = WebEngageConstant.SCOPE_SEPARATOR
                + WebEngageConstant.LAST_VIEW_TIME_UPDATE;

//        Logger.d(WebEngageConstant.TAG, TAG + " start evaluating for " + notificationEncId);


        boolean isInlineEntity = false;
        if (WebEngageConstant.Entity.INLINE_PERSONALIZATION.equals(entity)) {
            attributeKeyViewSessionCount = WebEngageConstant.IN_LINE + attributeKeyViewSessionCount;
            attributeKeyLastUpdateTime = WebEngageConstant.IN_LINE + attributeKeyLastUpdateTime;
            isInlineEntity = true;
        } else if (WebEngageConstant.Entity.NOTIFICATION.equals(entity)) {
            attributeKeyViewSessionCount = WebEngageConstant.IN_APP + attributeKeyViewSessionCount;
            attributeKeyLastUpdateTime = WebEngageConstant.IN_APP + attributeKeyLastUpdateTime;
        }
        Long viewCountInSession = DataHolder.get().getSessionAttributeValueForKey(attributeKeyViewSessionCount);
        Long lastViewTimestamp = DataHolder.get().getScopeAttributeValueForKey(attributeKeyLastUpdateTime);
//        Logger.d(WebEngageConstant.TAG, TAG + " initial values maxTimesPerUser: " + notificationEncId
//                + "\n maxTimesPerUser: " + maxTimesPerUser
//                + "\n totalViewCount: " + totalViewCount
//                + "\n totalClickCount: " + totalClickCount
//                + "\n totalCloseCountSession: " + totalCloseCountSession
//                + "\n totalHideCountSession: " + totalHideCountSession
//                + "\n viewCountInSession: " + viewCountInSession
//                + "\n lastViewTimestamp: " + lastViewTimestamp
//        );

        boolean result = true;
        //First Frequency Capping would be checked
        //If FC applied than result should be set to false and vice versa
        boolean shouldCheckForFC = (boolean) (entityObj.get("fc") != null ? entityObj.get("fc") : false);
//        Logger.d(WebEngageConstant.TAG, TAG + " Should check for FC " + shouldCheckForFC + " id: " + notificationEncId);
        if (shouldCheckForFC) {
            result = isFCApplicable(isInlineEntity, viewCountInSession, lastViewTimestamp, notificationEncId);
//            Logger.d(WebEngageConstant.TAG, TAG + " isFCApplicable result " + result);
            if (!result) {
//                Logger.d(WebEngageConstant.TAG, TAG + " isFCApplicable Returning FC applied to " + notificationEncId + ", hence not rendering");
                return false;
            }
        }
//        Logger.d(WebEngageConstant.TAG, TAG + " MaxTimesPerUser " + maxTimesPerUser + " totalViewCount - " + totalViewCount + " result " + result);

        //Checking max limit
        if (maxTimesPerUser != null) {
            result = result && (totalViewCount < maxTimesPerUser);
            if (!result) {
                Logger.d(WebEngageConstant.TAG, TAG + " MaxTimesPerUser condition reached " + notificationEncId);
                return false;
            }
        }

        //Checking clicks, close and hide
        if (!isInlineEntity) {
            result = result && (totalClickCount < 1) && (totalCloseCountSession < 1) && (totalHideCountSession < 1);
        }
        if (!result) {
            Logger.d(WebEngageConstant.TAG, TAG + " Total click or hide or close already happen, hence returning false " + notificationEncId);
            return false;
        }

        //Check for Recur condition if total click or close is still zero.
        if (null != entityObj.get("lc")) {
            AnalyticsPreferenceManager preferenceManager = WebEngage.get().analytics().getPreferenceManager();
            String userIdentifier = preferenceManager.getCUID().isEmpty()
                    ? preferenceManager.getLUID()
                    : preferenceManager.getCUID();
            checkForRecurDetails(userIdentifier,notificationEncId);
            String attributeKeyNotificationRecurCount = notificationEncId + WebEngageConstant.SCOPE_SEPARATOR
                    + WebEngageConstant.RECUR_COUNT;
            Long campaignRecurCount = DataHolder.get().getScopeAttributeValueForKey(attributeKeyNotificationRecurCount);
            String lc = (String) entityObj.get("lc");
            Pair<String, Long> intervalPair = WebEngageUtils.getPairIntrvlTypeMillisFromTimeString(lc);
            long recurFreq = intervalPair.second;
            result = campaignRecurCount < recurFreq;
            if (!result) {
                Logger.d(WebEngageConstant.TAG, TAG + " Recur condition failed for " + notificationEncId + "Already recurred:" + campaignRecurCount + " freq: " + recurFreq);
                return false;
            }
        }

        if (variationObj != null) {
            //variationObj can be null if sampling fall under control group
            List<String> targetActivities = (List<String>) variationObj.get("targetActivities");
            boolean skipTargetPage = entityObj.containsKey("skipTargetPage") ? Boolean.valueOf(entityObj.get("skipTargetPage").toString()) : false;
            if (targetActivities != null && !targetActivities.isEmpty() && skipTargetPage) {
                String screenPath = DataHolder.get().getScreenPath();
                result = result && (!targetActivities.contains(screenPath));
            }
        }

        //Check base check for current time
        long startTimeStamp = entityObj.get("startTimestamp") == null ? Long.MIN_VALUE : (long) entityObj.get("startTimestamp");
        long endTimeStamp = entityObj.get("endTimestamp") == null ? Long.MAX_VALUE : (long) entityObj.get("endTimestamp");
        long currentTimeStamp = System.currentTimeMillis();
//        Logger.d(WebEngageConstant.TAG, TAG + " Returning "
//                + (result && (currentTimeStamp >= startTimeStamp && currentTimeStamp <= endTimeStamp))
//                + " for " + notificationEncId);
        return result && (currentTimeStamp >= startTimeStamp && currentTimeStamp <= endTimeStamp);
    }

    private void checkForRecurDetails(String userIdentifier,String notificationEncId) {
        //This has been done to record last recur time for the new campaign in the v4,
        //as the checkForResetRecurParams() gets called during visitor session due
        //to which LAST_RECUR_RESET time has not been set as the start time of the Campaign.
        String attributeKeyLastResetRecurTime = notificationEncId + WebEngageConstant.SCOPE_SEPARATOR
                + WebEngageConstant.LAST_RECUR_RESET;
        if (DataHolder.get().getScopeAttributeValueForKey(attributeKeyLastResetRecurTime) == 0L) {
            DataHolder.get().setOrUpdateUserProfile(userIdentifier,
                    attributeKeyLastResetRecurTime,
                    System.currentTimeMillis(), DataContainer.SCOPES);
        }
    }

    ///This function return true if FC applies, hence campaign will not be rendered if it falls under FC
    private boolean isFCApplicable(boolean isInlineEntity, Long viewCountInSession, Long lastViewTimestamp, String notifId) {
        long timeDiff = System.currentTimeMillis() - lastViewTimestamp;
        if (isInlineEntity) {
//            Logger.d(WebEngageConstant.TAG, TAG + " Checking for FC in-line time gap diff is:  inAppFCTimeGap "
//                    + inLineFCTimeGap + " < timeDiff " + timeDiff + " = " + ((timeDiff > inLineFCTimeGap)));
            boolean result = true;
            if (lastViewTimestamp > 0) {
                result = result && timeDiff >= inLineFCTimeGap;
            }
            if (inLineFCCount != null) {
//                Logger.d(WebEngageConstant.TAG, TAG + " Checking for FC in-line count is:  "
//                        + (viewCountInSession < inLineFCCount) + " viewCountInSession " + viewCountInSession +
//                        " <  inLineFCCount " + inLineFCCount + " notif id: " + notifId);
                result = result && (viewCountInSession < inLineFCCount);
            }

            return result;
        } else {
//            Logger.d(WebEngageConstant.TAG, TAG + " Checking for FC in-app time gap diff is:  inAppFCTimeGap "
//                    + inAppFCTimeGap + " < timeDiff " + timeDiff + " = " + ((timeDiff > inAppFCTimeGap)));
            boolean result = true;
            if (lastViewTimestamp > 0) {
                result = result && timeDiff >= inAppFCTimeGap;
            }
            if (inAppFCCount != null) {
//                Logger.d(WebEngageConstant.TAG, TAG + " Checking for FC in-app time gap diff is:  "
//                        + (viewCountInSession < inAppFCCount) + " viewCountInSession " + viewCountInSession +
//                        " <  inAppFCCount " + inAppFCCount + " notif id: " + notifId);
                result = result && (viewCountInSession < inAppFCCount);
            }
            return result;
        }
    }

    public void setFCDetails(HashMap<String, Object> fcDetails) {
        if (null != fcDetails) {
            if (null != fcDetails.get("ina")) {
                HashMap<String, Object> inAppFCDetails = (HashMap<String, Object>) fcDetails.get("ina");
                if (null != inAppFCDetails) {
                    if (null != inAppFCDetails.get("vps"))
                        inAppFCCount = (Long) inAppFCDetails.get("vps");

                    if (null != inAppFCDetails.get("tg"))
                        inAppFCTimeGap = (Long) inAppFCDetails.get("tg");
                }
            }
            if (null != fcDetails.get("inl")) {
                HashMap<String, Object> inLineFCDetails = (HashMap<String, Object>) fcDetails.get("inl");
                if (null != inLineFCDetails) {
                    if (null != inLineFCDetails.get("vps"))
                        inLineFCCount = (Long) (inLineFCDetails.get("vps"));

                    if (null != inLineFCDetails.get("tg"))
                        inLineFCTimeGap = (Long) inLineFCDetails.get("tg");
                }
            }
        }

//        Logger.d(WebEngageConstant.TAG, TAG + " WELifecycleManager inAppFCCount: " + inAppFCCount +
//                " inAppFCTimeGap: " + inAppFCTimeGap + " + inLineFCCount  " + inLineFCCount
//                + " inLineFCTimeGap " + inLineFCTimeGap);
    }


    public void checkForResetRecurParams() {
        Map<String, Object> inLineCampaigns = DataHolder.get().getInlineCampaignsData();
        Map<String, Object> inAppCampaigns = DataHolder.get().getInAppCampaignsData();
        if (inAppCampaigns != null) {
            for (Map.Entry<String, Object> inAppEntity : inAppCampaigns.entrySet()) {
                Map<String, Object> inApp = (Map<String, Object>) inAppEntity.getValue();
                if (null != inApp.get("lc")) {
                    resetRecurIfNeeded(inApp, WebEngageConstant.Entity.NOTIFICATION);
                }
            }
        }

        if (inLineCampaigns != null) {
            for (Map.Entry<String, Object> inLineEntity : inLineCampaigns.entrySet()) {
                Map<String, Object> inLine = (Map<String, Object>) inLineEntity.getValue();
                if (null != inLine.get("lc")) {
                    resetRecurIfNeeded(inLine, WebEngageConstant.Entity.INLINE_PERSONALIZATION);
                }
            }
        }
    }

    private void resetRecurIfNeeded(Map<String, Object> entityObj, WebEngageConstant.Entity entity) {
        String notificationEncId = (String) entityObj.get("notificationEncId");
        Long totalViewCount = DataHolder.get().getEntityTotalViewCountPerScope(entityObj, entity);
        String attributeKeyNotificationRecurCount = notificationEncId + WebEngageConstant.SCOPE_SEPARATOR
                + WebEngageConstant.RECUR_COUNT;
        String attributeKeyLastResetRecurTime = notificationEncId + WebEngageConstant.SCOPE_SEPARATOR
                + WebEngageConstant.LAST_RECUR_RESET;
        AnalyticsPreferenceManager preferenceManager = WebEngage.get().analytics().getPreferenceManager();
        String userIdentifier = preferenceManager.getCUID().isEmpty()
                ? preferenceManager.getLUID()
                : preferenceManager.getCUID();
        long notificationStartTime = entityObj.get("startTimestamp") == null ? Long.MIN_VALUE : (long) entityObj.get("startTimestamp");
        if (totalViewCount <= 0) {
            DataHolder.get().setOrUpdateUserProfile(userIdentifier,
                    attributeKeyLastResetRecurTime,
                    System.currentTimeMillis(), DataContainer.SCOPES);
            return;
        }
        Long campaignLastResetRecurTime = DataHolder.get().getScopeAttributeValueForKey(attributeKeyLastResetRecurTime);
        Calendar calToCompareFrom = Calendar.getInstance();
        if (campaignLastResetRecurTime != 0L) {
            calToCompareFrom.setTimeInMillis(campaignLastResetRecurTime);
        } else {
            calToCompareFrom.setTimeInMillis(notificationStartTime);
        }
        String lc = (String) entityObj.get("lc");
        Pair<String, Long> intervalPair = WebEngageUtils.getPairIntrvlTypeMillisFromTimeString(lc);
        String intervalType = intervalPair.first;
        Calendar today = Calendar.getInstance();
        today.setFirstDayOfWeek(Calendar.MONDAY);
        calToCompareFrom.setFirstDayOfWeek(Calendar.MONDAY);
        boolean isRecurCountReset = false;

        switch (intervalType.toUpperCase()) {
            case "MIN":
                if ((today.get(Calendar.YEAR) - calToCompareFrom.get(Calendar.YEAR) > 0)) {
                    isRecurCountReset = true;
                } else if (Math.abs(today.get(Calendar.MONTH) - calToCompareFrom.get(Calendar.MONTH)) > 0) {
                    isRecurCountReset = true;
                } else if (Math.abs(today.get(Calendar.DATE) - calToCompareFrom.get(Calendar.DATE)) > 0) {
                    isRecurCountReset = true;
                } else if (today.get(Calendar.HOUR) - calToCompareFrom.get(Calendar.HOUR) > 0) {
                    isRecurCountReset = true;
                } else if ((today.get(Calendar.MINUTE) - calToCompareFrom.get(Calendar.MINUTE) > 0)) {
                    isRecurCountReset = true;
                }
                break;
            case "H":
                if ((today.get(Calendar.YEAR) - calToCompareFrom.get(Calendar.YEAR) > 0)) {
                    isRecurCountReset = true;
                } else if (Math.abs(today.get(Calendar.MONTH) - calToCompareFrom.get(Calendar.MONTH)) > 0) {
                    isRecurCountReset = true;
                } else if (Math.abs(today.get(Calendar.DATE) - calToCompareFrom.get(Calendar.DATE)) > 0) {
                    isRecurCountReset = true;
                } else if (today.get(Calendar.HOUR) - calToCompareFrom.get(Calendar.HOUR) > 0) {
                    isRecurCountReset = true;
                }
                break;
            case "D":
                if ((today.get(Calendar.YEAR) - calToCompareFrom.get(Calendar.YEAR) > 0)) {
                    isRecurCountReset = true;
                } else if (Math.abs(today.get(Calendar.MONTH) - calToCompareFrom.get(Calendar.MONTH)) > 0) {
                    isRecurCountReset = true;
                } else if (Math.abs(today.get(Calendar.DATE) - calToCompareFrom.get(Calendar.DATE)) > 0) {
                    isRecurCountReset = true;
                }
                break;
            case "W":
                //If the week is of the same month
                if ((today.get(Calendar.YEAR) - calToCompareFrom.get(Calendar.YEAR) > 0)) {
                    isRecurCountReset = true;
                } else if (Math.abs(today.get(Calendar.MONTH) - calToCompareFrom.get(Calendar.MONTH)) > 0) {
                    isRecurCountReset = true;
                } else if (Math.abs(today.get(Calendar.WEEK_OF_MONTH) - calToCompareFrom.get(Calendar.WEEK_OF_MONTH)) > 0) {
                    isRecurCountReset = true;
                }
                break;
            case "M":
                if ((today.get(Calendar.YEAR) - calToCompareFrom.get(Calendar.YEAR) > 0)) {
                    isRecurCountReset = true;
                } else if (Math.abs(today.get(Calendar.MONTH) - calToCompareFrom.get(Calendar.MONTH)) > 0) {
                    isRecurCountReset = true;
                }
                break;
            case "Y":
                if (today.get(Calendar.YEAR) - calToCompareFrom.get(Calendar.YEAR) > 0) {
                    isRecurCountReset = true;
                }
                break;
        }

        if (isRecurCountReset) {
           //Reset click and view
            String scopeString = DataHolder.get().getScopeStringForExperiment(entityObj, entity);
            DataHolder.get().setOrUpdateUserProfile(userIdentifier,
                    scopeString + WebEngageConstant.SCOPE_SEPARATOR + WebEngageConstant.CLICK,
                    0L, DataContainer.SCOPES);
            DataHolder.get().setOrUpdateUserProfile(userIdentifier,
                    scopeString + WebEngageConstant.SCOPE_SEPARATOR + WebEngageConstant.VIEW,
                    0L, DataContainer.SCOPES);

            //Increase recur count and assign recurred-time
            DataHolder.get().setOrUpdateUserProfile(userIdentifier,
                    attributeKeyLastResetRecurTime,
                    System.currentTimeMillis(), DataContainer.SCOPES);
            DataHolder.get().incrementUserProfile(userIdentifier, attributeKeyNotificationRecurCount,
                    1L, DataContainer.SCOPES);
        }
    }
}
