package com.webengage.sdk.android.actions.database;

import android.content.Context;
import android.content.SharedPreferences;

import com.webengage.sdk.android.Action;
import com.webengage.sdk.android.BuildConfig;
import com.webengage.sdk.android.CallbackDispatcher;
import com.webengage.sdk.android.EventPayload;
import com.webengage.sdk.android.Logger;
import com.webengage.sdk.android.utils.DataType;
import com.webengage.sdk.android.utils.WebEngageConstant;
import com.webengage.sdk.android.utils.http.RequestMethod;
import com.webengage.sdk.android.utils.http.RequestObject;
import com.webengage.sdk.android.utils.http.WENetworkUtil;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SyncAction extends Action {
    private Context applicationContext = null;
    private String URL = null;
    private Object actionData = null;
    ArrayList<String> eventListNames = new ArrayList<String>();

    protected SyncAction(Context context) {
        super(context);
        this.applicationContext = context.getApplicationContext();
    }

    @Override
    public Object preExecute(Map<String, Object> actionAttributes) {
        actionData = actionAttributes.get(SyncActionController.ACTION_DATA);
        URL = (String) actionAttributes.get(SyncActionController.SERVER_URL);
        return generateDataPayload((ArrayList<EventPayload>) actionData);
    }

    @Override
    public Object execute(Object data) {
        if (data != null) {
            ArrayList<EventPayload> unsyncedEventdata = (ArrayList<EventPayload>) actionData;
            String userCUID = unsyncedEventdata.get(0).getCUID();
            if (ReportingStatistics.getShouldReport()) {
                if (BuildConfig.DEBUG) {
                    Logger.d(WebEngageConstant.TAG, "Events url: " + URL);
                }
                Map<String, String> headers = new HashMap<String, String>();
                headers.put("Content-Type", "application/transit+json");
                RequestObject requestObject = new RequestObject.Builder(URL, RequestMethod.POST, this.applicationContext)
                        .setParams(data)  // change data to params if end point is kafka
                        .setHeaders(headers)
                        .build();
                Map<String, Object> result = new HashMap<>();
                try {
                    result = WENetworkUtil.makeRequest(applicationContext, requestObject, true, false, userCUID);
                    return result;
                } catch (Exception e) {
                    Logger.d(WebEngageConstant.TAG, "Exception occured at Network utils while Event syncing");
                    e.printStackTrace();
                }
            } else {
                return null;
            }
        }
        return null;
    }

    @Override
    public void postExecute(Object data) {
        ArrayList<EventPayload> unsyncedEventdata = (ArrayList<EventPayload>) actionData;
        List<String> failedIds = new ArrayList<String>();

        if (data != null) {
            Map<String, Object> result = (HashMap<String, Object>) data;
            String payloadCUID = "";
            String payloadLUID = "";
            Boolean isLogoutExists = false;
            int responseCode = (int) result.get("status");
            payloadCUID = unsyncedEventdata.get(0).getCUID();
            payloadLUID = unsyncedEventdata.get(0).getLUID();
            String currentLUID = getLUID();
            if (responseCode >= HttpURLConnection.HTTP_OK && responseCode < HttpURLConnection.HTTP_BAD_REQUEST) {
                ReportingController.strategyFactory.getReportingStatistics().setLastReportStatus(true);
                ReportingController.strategyFactory.getReportingStatistics().resetNetworkReportFailureCount();
                Logger.d(WebEngageConstant.TAG, "Events successfully Logged to server, scheduling next sync");
                ArrayList<String> idsToRemove = new ArrayList<String>();
                if (unsyncedEventdata != null) {
                    for (EventPayload eventPayload : unsyncedEventdata) {
                        idsToRemove.add(Integer.toString(eventPayload.getId()));
                    }
                }
                if(result.containsKey("data")) {
                    InputStream inputStream = (InputStream) result.get("data");
                    try {
                        if(inputStream != null) {
                            inputStream.close();
                        } else {
                            Logger.d(WebEngageConstant.TAG, "Input Stream with invalid data. result -> "+result);
                        }
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    Logger.d(WebEngageConstant.TAG, "result.data is not Available  "+result);
                }

                EventDataManager.getInstance(this.applicationContext).removeEvents(idsToRemove);
                if (!payloadLUID.equals(currentLUID) && EventDataManager.getInstance(applicationContext).checkIfEventsExistsFromLUID(payloadLUID)) {
                    removeSecureToken(payloadCUID);
                }

            } else {
                if (responseCode == HttpURLConnection.HTTP_UNAUTHORIZED) {
                    List<EventPayload> eventList = new ArrayList<>();
                    isLogoutExists = EventDataManager.getInstance(applicationContext).checkLogoutExists();
                    if (isLogoutExists) {
                        EventDataManager.getInstance(applicationContext).deleteEvents(currentLUID);
                        removeSecureToken(payloadCUID);
                    } else {
                        CallbackDispatcher.init(applicationContext).onSecurityException(result);
                    }
                }
                    if (ReportingStatistics.getShouldReport()) {
                        ReportingStatistics.setShouldReport(false);
                        ReportingController.strategyFactory.getReportingStatistics().setLastReportStatus(false);
                        ReportingController.strategyFactory.getReportingStatistics().incrementNetworkReportFailureCount();
                    }
                if (unsyncedEventdata != null) {
                    for (EventPayload eventPayload : unsyncedEventdata) {
                        failedIds.add(Integer.toString(eventPayload.getId()));
                    }
                }
                EventDataManager.getInstance(this.applicationContext).updateFailedEvents(failedIds);
                Logger.d(WebEngageConstant.TAG, "Event Logging failed, scheduling next sync");
                if (result.get("exception") != null) {
                    Logger.e(WebEngageConstant.TAG, "Event sync failed due to Exception: " + String.valueOf(result.get("exception")), (Throwable) result.get("exception"));
                }
            }
        } else {
            if (unsyncedEventdata != null) {
                for (EventPayload eventPayload : unsyncedEventdata) {
                    failedIds.add(Integer.toString(eventPayload.getId()));
                }
                EventDataManager.getInstance(this.applicationContext).updateFailedEvents(failedIds);
            }

        }
    }

    private String generateDataPayload(ArrayList<EventPayload> eventPayloadList) {
        if (eventPayloadList == null) {
            return null;
        }
        if (eventPayloadList.size() == 0) {
            return null;
        }

        try {
            return DataType.convert(eventPayloadList, DataType.STRING, true).toString();
        } catch (Exception e) {

        }
        return null;
    }

    public String getCUID() {
        SharedPreferences preferences = getPreferenceFile(DEFAULT_PREFS);
        return preferences.getString(CUID_KEY, "");
    }
}
