package com.webengage.sdk.android.actions.database;

import android.content.Context;
import android.text.TextUtils;

import com.webengage.sdk.android.Action;
import com.webengage.sdk.android.BuildConfig;
import com.webengage.sdk.android.Logger;
import com.webengage.sdk.android.UserSystemAttribute;
import com.webengage.sdk.android.WebEngage;
import com.webengage.sdk.android.actions.rules.ConfigurationManager;
import com.webengage.sdk.android.utils.DataType;
import com.webengage.sdk.android.utils.NetworkUtils;
import com.webengage.sdk.android.utils.WebEngageConstant;
import com.webengage.sdk.android.utils.http.CachePolicy;
import com.webengage.sdk.android.utils.http.RequestMethod;
import com.webengage.sdk.android.utils.http.RequestObject;
import com.webengage.sdk.android.utils.http.WENetworkUtil;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class UserProfileFetchAndUpdateAction extends Action {
    Context applicationContext = null;
    String userIdentifier = null;
    ConfigurationManager configurationManager = null;
    Set<String> requiredData = new HashSet<>();

    UserProfileFetchAndUpdateAction(Context context) {
        super(context);
        this.applicationContext = context;
    }

    @Override
    protected Object preExecute(Map<String, Object> actionAttributes) {
        Map<String, Object> sidsFromConfig = new HashMap<>();
        Map<String, Object> jidsFromConfig = new HashMap<>();

        try {
            configurationManager = new ConfigurationManager(this.applicationContext);
            requiredData = (HashSet<String>) actionAttributes.get(WebEngageConstant.DATA);

            if (requiredData.contains(WebEngageConstant.FETCH_PROFILE)) {
                List<Object> eventCriteriaList = configurationManager.getEventCriteriaList();
                if ((eventCriteriaList == null || eventCriteriaList.isEmpty()) && getCUID().isEmpty()) {
                    requiredData.remove(WebEngageConstant.FETCH_PROFILE);
                }
            }
            if (DataHolder.get().isAppForeground()) {
                if (requiredData.contains(WebEngageConstant.JCX)) {
                    jidsFromConfig = DataHolder.get().getJIDsFromUPFC();
                    if (jidsFromConfig == null || jidsFromConfig.isEmpty())
                        requiredData.remove(WebEngageConstant.JCX);
                }
                if (requiredData.contains(WebEngageConstant.STATIC_LIST)) {
                    sidsFromConfig = DataHolder.get().getSIDsFromUPFC();
                    if (sidsFromConfig == null || sidsFromConfig.isEmpty())
                        requiredData.remove(WebEngageConstant.STATIC_LIST);
                }
            }

        } catch (Exception e) {
            return null;
        }
        if (requiredData.isEmpty()) {
            Logger.d(WebEngageConstant.TAG, "Cancelling UPF request as no data is required");
            return null;
        }
        String postBodyForUPFCFetch = generatePostBody(requiredData, WebEngage.get().getWebEngageConfig().getWebEngageKey(), getLUID(), getCUID(), jidsFromConfig, sidsFromConfig);

        return postBodyForUPFCFetch;
    }

    @Override
    protected Object execute(Object data) {
        if (data != null) {
            String url = WebEngageConstant.Urls.USER_PROFILE_2_BASE.toString();
            if (BuildConfig.DEBUG) {
                Logger.d(WebEngageConstant.TAG, "upf url: " + url);
            }
            Map<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/transit+json");
            RequestObject requestObject = new RequestObject.Builder(url, RequestMethod.POST, this.applicationContext).setHeaders(headers).setCachePolicy(CachePolicy.GET_DATA_FROM_NETWORK_ONLY_NO_CACHING).setParams(data).build();
            Map<String, Object> result = new HashMap<>();
            try {
                result = WENetworkUtil.makeRequest(applicationContext, requestObject, true, true);
            } catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            InputStream responseStream = (InputStream) result.get("data");
            if (responseStream != null) {
                userIdentifier = getCUID().isEmpty() ? getLUID() : getCUID();
                Map<String, Object> upf2Data = null;
                try {
                    upf2Data = NetworkUtils.getAsMap(responseStream, true);
                } catch (Exception e) {
                    dispatchExceptionTopic(e);
                }
                if (upf2Data != null) {
                    readJourneyContext(upf2Data);
                    readStaticListContext(upf2Data);
                    readUserProfile(upf2Data);
                }
                try {
                    responseStream.close();
                } catch (IOException e) {
                }
                return responseStream;
            }
        }

        return null;
    }

    private void readUserProfile(Map<String, Object> upf2Data) {
        if(upf2Data.containsKey("user_profile")) {
            Map<String, Object> userProfileData = (Map<String, Object>) upf2Data.get("user_profile");
            if (userProfileData != null) {
                userProfileData = (Map<String, Object>) userProfileData.get("upf");
                if (getCUID().isEmpty()) {
                    for (DataContainer dataContainer : DataContainer.values()) {
                        if (dataContainer.isAnonymousUserContainer()) {
                            readProfile(dataContainer, userProfileData);
                        }
                    }
                    loadUserDataFromProfile(UserSystemAttribute.CITY, userProfileData);
                    loadUserDataFromProfile(UserSystemAttribute.COUNTRY, userProfileData);
                    loadUserDataFromProfile(UserSystemAttribute.REGION, userProfileData);
                    loadUserDataFromProfile(UserSystemAttribute.LOCALITY, userProfileData);
                    loadUserDataFromProfile(UserSystemAttribute.POSTAL_CODE, userProfileData);

                } else {
                    if (userProfileData != null) {
                        if (getCUID().equals(userProfileData.get("cuid"))) {
                            for (DataContainer dataContainer : DataContainer.values()) {
                                if (dataContainer.isKnownUsersContainer()) {
                                    readProfile(dataContainer, userProfileData);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private String generatePostBody(Set<String> requiredData, String licenseCode, String luid, String cuid, Map<String, Object> jidsFromConfig, Map<String, Object> sidsFromConfig) {
        Map<String, Object> postBody = new HashMap<>();
        Map<String, Object> upfcObject = new HashMap<>();

        try {

            if (!TextUtils.isEmpty(cuid)) {
                upfcObject.put("cuid", cuid);
            }
            upfcObject.put("luid", luid);
            upfcObject.put("licenseCode", licenseCode);

            if (requiredData.contains(WebEngageConstant.JCX)) {
                upfcObject.put("jids", jidsFromConfig);
            }

            if (requiredData.contains(WebEngageConstant.STATIC_LIST)) {
                Map<String, Object> staticLists = getStaticListsData(sidsFromConfig);
                if (!staticLists.isEmpty()) {
                    upfcObject.put("sids", staticLists);
                }
            }

            upfcObject.put("upf", requiredData.contains(WebEngageConstant.FETCH_PROFILE));

            //return postBody only if it has either of jids , sids ,or upf. Else return null.
            // This is to handle empty post body due to some json exception
            if (upfcObject.containsKey("sids") || upfcObject.containsKey("jids") || (boolean) upfcObject.get("upf")) {
                postBody.put("upfc", upfcObject);
                return DataType.convert(postBody, DataType.STRING, true).toString();
            } else {
                return null;
            }

        } catch (Exception ignored) {
            return null;
        }
    }

    private Map<String, Object> getStaticListsData(Map<String, Object> sidsFromConfig) throws JSONException {
        Map<String, Object> sidsObject = new HashMap<>();

        Map<String, Object> sidsFromContainer = DataHolder.get().getStaticListIds();
        Map<String, Object> mergedSids = getMergedStaticList(sidsFromConfig, sidsFromContainer);

        if (!mergedSids.isEmpty()) {
            sidsObject.put("ids", mergedSids);
            Object timeStamp = DataHolder.get().getStaticListValue("ts");
            if (timeStamp != null) {
                sidsObject.put("ts", (long) timeStamp);
            } else {
                sidsObject.put("ts", JSONObject.NULL);
            }
        }

        return sidsObject;
    }

    private Map<String, Object> getMergedStaticList(Map<String, Object> sidsFromConfig, Map<String, Object> sidsFromContainer) {

        Map<String, Object> mergedSids = new HashMap<>();
        try {
            List<String> sidsArray = (List<String>) sidsFromConfig.get("ids");
            if (sidsArray != null && sidsArray.size() > 0) {
                for (int i = 0; i < sidsArray.size(); i++) {
                    if (sidsFromContainer.containsKey(sidsArray.get(i))) {
                        mergedSids.put(sidsArray.get(i), (boolean) sidsFromContainer.get(sidsArray.get(i)));
                    } else {
                        mergedSids.put(sidsArray.get(i), JSONObject.NULL);
                    }
                }
            }
        } catch (Exception ignored) {

        }
        return mergedSids;
    }


    @Override
    protected void postExecute(Object data) {

    }

    private void readJourneyContext(Map<String, Object> userProfile) {
        try {
            if (userProfile.containsKey("journey") && userProfile.get("journey") != null) {
                DataHolder.get().silentSetData(DataContainer.JOURNEY.toString(), userProfile.get("journey"));
            }
        } catch (Exception ignored) {

        }
    }

    private void readStaticListContext(Map<String, Object> userProfile) {
        try {
            if (userProfile.containsKey("static_list") && userProfile.get("static_list") != null) {
                Map<String, Object> staticListFromUPF = (Map<String, Object>) userProfile.get("static_list");
                if (staticListFromUPF != null) {
                    if (staticListFromUPF.containsKey("ts") && staticListFromUPF.get("ts") != null) {
                        long updateTimeStamp = (long) staticListFromUPF.get("ts");
                        DataHolder.get().setOrUpdateStaticLists(userIdentifier, "ts", updateTimeStamp);
                    }
                    if (staticListFromUPF.containsKey("ids") && staticListFromUPF.get("ids") != null) {
                        DataHolder.get().setOrUpdateStaticListContext(userIdentifier, (Map<String, Object>) staticListFromUPF.get("ids"));
                    }
                }
            }
        } catch (Exception e) {

        }
    }

    private void readProfile(DataContainer dataContainer, Map<String, Object> userProfile) {
        switch (dataContainer) {
            case USER:
                Set<String> keys = userProfile.keySet();
                Iterator<String> iterator = keys.iterator();
                while (iterator.hasNext()) {
                    String key = iterator.next();
                    UserSystemAttribute userSystemAttribute = UserSystemAttribute.valueByString(key);
                    if (!"event_criterias".equals(key) && !"devices".equals(key) && !"user_attributes".equals(key) && !"journey".equals(key) && !"static_list".equals(key)) {
                        try {
                            DataHolder.get().setOrUpdateUserProfile(userIdentifier, key, userProfile.get(key), dataContainer, userSystemAttribute == null ? Operation.FORCE_UPDATE : userSystemAttribute.getOperation());
                        } catch (Exception e) {

                        }
                    }
                }
                break;
            case EVENT_CRITERIA:
                Set<String> criteriaIdsFromConfig = configurationManager.getEventCriteriaIds();
                List<Object> eventCriterias = (List<Object>) userProfile.get("event_criterias");
                if (eventCriterias != null) {
                    for (int i = 0; i < eventCriterias.size(); i++) {
                        Map<String, Object> criteria = (Map<String, Object>) eventCriterias.get(i);
                        if (criteria != null) {
                            try {
                                String criteriaId = (String) criteria.get("criteria_id");
                                if (criteriaIdsFromConfig != null && criteriaIdsFromConfig.contains(criteriaId)) {
                                    DataHolder.get().setOrUpdateEventCriteriaValue(userIdentifier, criteriaId, criteria);
                                }
                            } catch (Exception e) {

                            }
                        }
                    }
                }
                break;

            case ATTR:
                try {
                    DataHolder.get().setOrUpdateUsersCustomAttributes(userIdentifier, (Map<String, Object>) userProfile.get("user_attributes"));
                } catch (Exception e) {

                }
                break;

            case ANDROID:
                break;
            case IOS:
            case WEB:
                readDeviceData(userProfile, dataContainer);
                break;
        }
    }

    private void readDeviceData(Map<String, Object> userProfile, DataContainer dataContainer) {
        Map<String, Object> devices = (Map<String, Object>) userProfile.get("devices");
        if (devices != null) {
            List<Object> platformDataArray = (List<Object>) devices.get(dataContainer.getSDKID());
            if (platformDataArray != null && platformDataArray.size() > 0) {
                Map<String, Object> platformData = (Map<String, Object>) platformDataArray.get(0);
                if (platformData != null) {
                    Set<String> keys = platformData.keySet();
                    Iterator<String> iterator = keys.iterator();
                    while (iterator.hasNext()) {
                        String key = iterator.next();
                        try {
                            DataHolder.get().setOrUpdateUserProfile(userIdentifier, key, platformData.get(key), dataContainer);
                        } catch (Exception e) {

                        }
                    }

                }
            }
        }
    }


    private void loadUserDataFromProfile(UserSystemAttribute userSystemAttribute, Map<String, Object> userProfile) {
        if (userProfile != null && userSystemAttribute != null) {
            String key = userSystemAttribute.toString();
            Object value = userProfile.get(key);
            if (value != null) {
                DataHolder.get().setOrUpdateUserProfile(userIdentifier, key, value, DataContainer.USER, Operation.FORCE_UPDATE);
            }
        }
    }


}
