package com.webengage.sdk.android.actions.database;


import android.content.Context;

import com.webengage.sdk.android.Action;
import com.webengage.sdk.android.Logger;
import com.webengage.sdk.android.Subscriber;
import com.webengage.sdk.android.Topic;
import com.webengage.sdk.android.utils.WebEngageConstant;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UserProfileFetchAndUpdateController implements Subscriber {
    private Context applicationContext = null;
    private static UserProfileFetchAndUpdateController instance = null;

    public static final Factory FACTORY = new Factory() {
        @Override
        public Subscriber initialize(Context context) {
            if (instance == null) {
                instance = new UserProfileFetchAndUpdateController(context);
            }
            return instance;
        }
    };

    private UserProfileFetchAndUpdateController(Context context) {
        this.applicationContext = context.getApplicationContext();
    }

    @Override
    public void createAction(Topic topic, Object data) {
        if (validateData(data)) {
            Action action = new UserProfileFetchAndUpdateAction(this.applicationContext);
            action.performActionSync(getActionAttributes(topic, data));
        } else {
            Logger.i(WebEngageConstant.TAG, "Failed to fetch User Profile context "+data);
        }
    }

    @Override
    public boolean validateData(Object data) {
        try {
            Set<String> requiredData = (HashSet<String>) data;
            return !requiredData.isEmpty();
        } catch (Exception e) {
            return false;
        }
    }

    @Override
    public Map<String, Object> getActionAttributes(Topic topic, Object data) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put(WebEngageConstant.TOPIC, topic);
        map.put(WebEngageConstant.DATA, data);
        return map;
    }
}
