package com.webengage.sdk.android.actions.render;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.RemoteViews;

import com.webengage.sdk.android.Logger;
import com.webengage.sdk.android.R;
import com.webengage.sdk.android.callbacks.CustomPushRender;
import com.webengage.sdk.android.callbacks.CustomPushRerender;
import com.webengage.sdk.android.utils.WebEngageConstant;
import com.webengage.sdk.android.utils.WebEngageUtils;
import com.webengage.sdk.android.utils.gifUtils.WEGifHelper;
import com.webengage.sdk.android.utils.htmlspanner.WEHtmlParserInterface;
import com.webengage.sdk.android.utils.http.CachePolicy;
import com.webengage.sdk.android.utils.http.RequestMethod;
import com.webengage.sdk.android.utils.http.RequestObject;
import com.webengage.sdk.android.utils.http.WENetworkUtil;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BigPictureRenderer extends PushRenderer implements CustomPushRender, CustomPushRerender {

    private boolean isAndroid12 = false;
    private boolean hasBackgroundColor = false;

    private final WEGifHelper weGifHelper = new WEGifHelper();


    @Override
    public boolean onRender(Context context, PushNotificationData pushNotificationData) {
        if (pushNotificationData.getBackgroundColor() != Color.parseColor("#00000000"))
            hasBackgroundColor = true;

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S && context.getApplicationInfo().targetSdkVersion >= Build.VERSION_CODES.S)
            isAndroid12 = true;

        return super.onRender(context, pushNotificationData);
    }

    @Override
    void downloadImages() {
    }

    @Override
    protected void loadImages() {
        if (pushNotificationData.getBigPictureStyleData() != null) {
            String URL = pushNotificationData.getBigPictureStyleData().getBigPictureUrl();
            if (URL != null) {
                HashMap<String, String> headers = new HashMap<>();
                headers.put("accept", WENetworkUtil.getAcceptHeadersForPushImages(URL));
                RequestObject requestObject = new RequestObject.Builder(URL, RequestMethod.GET, applicationContext)
                        .setCachePolicy(CachePolicy.GET_DATA_FROM_NETWORK_ONLY_NO_CACHING)
                        .setTag(WebEngageConstant.LANDSCAPE)
                        .setHeaders(headers)
                        .build();
                InputStream responseStream = null;
                try {
                    Map<String, Object> result = WENetworkUtil.makeRequest(applicationContext, requestObject, true, true);
                    responseStream = (InputStream) result.get("data");
                    String contentType = (String) result.get("content-type");
                    if (WebEngageConstant.IMAGE_GIF_TYPE.equals(contentType)) {
                        isGIF = true;
                        List<Bitmap> bitmapList = weGifHelper.decodeGif(responseStream);
                        validImages.addAll(bitmapList);
                    } else {
                        if(URL.endsWith(".gif")){
                            Logger.d(WebEngageConstant.TAG, "URL ending with .gif but content-type found is " + contentType + " ,hence rendering normal notification");
                        }
                        Bitmap bitmap = loadImage(responseStream);
                        if (bitmap != null) {
                            validImages.add(bitmap);
                        }
                    }
                    responseStream.close();
                } catch (Exception e) {
                    if (responseStream != null) {
                        try {
                            responseStream.close();
                        } catch (IOException ioException) {
                            ioException.printStackTrace();
                        }
                    }
                    e.printStackTrace();
                }

            }
        }
    }

    private RemoteViews constructExpandedPushBase() {
        RemoteViews pushBase = getCommonExpandedPushBase();
        if (isAndroid12) {
            pushBase.setBoolean(R.id.custom_title, "setSingleLine", false);
            pushBase.setBoolean(R.id.custom_title_native, "setSingleLine", false);
            pushBase.setInt(R.id.custom_title, "setMaxLines", 2);
            pushBase.setInt(R.id.custom_title_native, "setMaxLines", 2);
            pushBase.setInt(R.id.custom_message, "setMaxLines", 2);
            pushBase.setInt(R.id.custom_message_native, "setMaxLines", 2);
        }

        pushBase.setViewVisibility(R.id.custom_base_container, View.VISIBLE);
        PushNotificationData.BigPictureStyle bigPictureStyle = pushNotificationData.getBigPictureStyleData();
        if (bigPictureStyle != null) {
            pushBase.setTextViewText(R.id.custom_title, new WEHtmlParserInterface().fromHtml(bigPictureStyle.getBigContentTitle()));
            pushBase.setTextViewText(R.id.custom_message, new WEHtmlParserInterface().fromHtml(bigPictureStyle.getMessage()));
            pushBase.setTextViewText(R.id.custom_title_native, new WEHtmlParserInterface().fromHtml(bigPictureStyle.getBigContentTitle()));
            pushBase.setTextViewText(R.id.custom_message_native, new WEHtmlParserInterface().fromHtml(bigPictureStyle.getMessage()));

            if (!TextUtils.isEmpty(bigPictureStyle.getSummary())) {
                pushBase.setTextViewText(R.id.custom_summary, new WEHtmlParserInterface().fromHtml(bigPictureStyle.getSummary()));
                pushBase.setTextViewText(R.id.custom_summary_native, new WEHtmlParserInterface().fromHtml(bigPictureStyle.getSummary()));
            } else {
                pushBase.setViewVisibility(R.id.custom_summary, View.GONE);
                pushBase.setViewVisibility(R.id.custom_summary_native, View.GONE);
            }
            pushBase.setImageViewResource(R.id.small_icon, pushNotificationData.getSmallIcon());
        }
        if (!areButtonsPresent()) {
            pushBase.setViewVisibility(R.id.push_base_margin_view, View.VISIBLE);
        }

        return pushBase;
    }

    @Override
    protected void buildExpandedPush() {
        if (pushNotificationData.isBigNotification() && pushNotificationData.getStyle() != null && Build.VERSION.SDK_INT >= 16) {
            if (pushNotificationData.getBigPictureStyleData() != null) {
                PushNotificationData.BigPictureStyle bigPictureData = pushNotificationData.getBigPictureStyleData();
                if (!buildCustomPush && (pushNotificationData.getBackgroundColor() == Color.parseColor("#00000000")) && !isGIF) {
                    Notification.BigPictureStyle bigPictureStyle = new Notification.BigPictureStyle();
                    bigPictureStyle.setBigContentTitle(new WEHtmlParserInterface().fromHtml(bigPictureData.getBigContentTitle()));
                    bigPictureStyle.setSummaryText(new WEHtmlParserInterface().fromHtml(bigPictureData.getMessage()));

                    try {
                        bigPictureStyle.bigPicture(validImages.get(0));
                        mBuilder.setStyle(bigPictureStyle);
                    } catch (Exception e) {

                    }
                } else {
                    customBigView = constructExpandedPushBase();
                    RemoteViews bigPictureView = new RemoteViews(this.applicationContext.getPackageName(), R.layout.big_picture);
                    if (!validImages.isEmpty()) {
                        if (isGIF) {
                            showGIF(bigPictureView);
                        } else {
                            showBigImage(bigPictureView);
                        }
                    }
                    customBigView.removeAllViews(R.id.custom_base_container);
                    customBigView.addView(R.id.custom_base_container, bigPictureView);

                    if (areButtonsPresent()) {
                        customBigView.setInt(R.id.big_picture_image, "setMaxHeight",
                                WebEngageUtils.dpToPixels(161, this.applicationContext));
                    }
                    if (!hasBackgroundColor) {
                        showTextViews();
                    } else {
                        showNativeTextViews();
                    }

                }
            }
        }
    }

    private void showBigImage(RemoteViews bigPictureView) {
        bigPictureView.setViewVisibility(R.id.big_picture_image, View.VISIBLE);
        bigPictureView.setViewVisibility(R.id.big_picture_viewflipper, View.GONE);
        setBitmapToRemoteView(validImages.get(0), bigPictureView, R.id.big_picture_image);
    }

    private void showGIF(RemoteViews bigPictureView) {
        bigPictureView.setViewVisibility(R.id.big_picture_viewflipper, View.VISIBLE);
        bigPictureView.setViewVisibility(R.id.big_picture_image, View.GONE);
        weGifHelper.constructViewFlipper(bigPictureView, validImages, this.applicationContext, R.id.big_picture_viewflipper);
    }

    private void showTextViews() {
        customBigView.setViewVisibility(R.id.app_name_native, View.GONE);
        customBigView.setViewVisibility(R.id.custom_summary_native, View.GONE);
        customBigView.setViewVisibility(R.id.custom_notification_time_native, View.GONE);
        customBigView.setViewVisibility(R.id.custom_title_native, View.GONE);
        customBigView.setViewVisibility(R.id.custom_message_native, View.GONE);
    }

    private void showNativeTextViews() {
        customBigView.setViewVisibility(R.id.app_name, View.GONE);
        customBigView.setViewVisibility(R.id.custom_summary, View.GONE);
        customBigView.setViewVisibility(R.id.custom_notification_time, View.GONE);
        customBigView.setViewVisibility(R.id.custom_title, View.GONE);
        customBigView.setViewVisibility(R.id.custom_message, View.GONE);
    }

    @Override
    public boolean onRerender(Context context, PushNotificationData pushNotificationData, Bundle extras) {
        super.onRerender(context, pushNotificationData, extras);
        return true;
    }
}
