package com.webengage.sdk.android.actions.render;

import static com.webengage.sdk.android.utils.WebEngageConstant.TAG;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.webengage.sdk.android.Action;
import com.webengage.sdk.android.Analytics;
import com.webengage.sdk.android.AnalyticsFactory;
import com.webengage.sdk.android.CallbackDispatcher;
import com.webengage.sdk.android.Logger;
import com.webengage.sdk.android.actions.database.DataHolder;
import com.webengage.sdk.android.actions.rules.Rule;
import com.webengage.sdk.android.actions.rules.RuleExecutor;
import com.webengage.sdk.android.actions.rules.RuleExecutorFactory;
import com.webengage.sdk.android.utils.DataType;
import com.webengage.sdk.android.utils.WebEngageConstant;
import org.json.JSONArray;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InLinePersonalizationAction extends Action {
    private Context mContext;

    public InLinePersonalizationAction(Context context) {
        super(context);
        this.mContext = context;
    }

    @Override
    protected Object preExecute(Map<String, Object> actionAttributes) {
        HashMap<String, Object> actionData = (HashMap<String, Object>) actionAttributes.get(RenderingController.ACTION_DATA);
        if (actionData != null && !(actionData.containsKey("ids") && actionData.containsKey("qEntities"))) {
            return null;
        }
        List<String> inLineIds = (List<String>) actionData.get("ids");
        //Remove check for zero size, as already shown campaigns on the screen should get removed
        //if they gets non-qualified in minimizing-maximizing app.
        //Start
        List<String> olderInlineCampaigns = DataHolder.get().getOlderInLineCampaigns();
        boolean shouldProcess = false;
        assert inLineIds != null;
        if (inLineIds.size() != olderInlineCampaigns.size()) {
            shouldProcess = true;
        } else {
            for (String id : inLineIds) {
                if (!olderInlineCampaigns.contains(id)) {
                    shouldProcess = true;
                    break;
                }
            }
        }
        //End
        if (shouldProcess) {
            HashMap<String, List<Object>> qualifiedCampaignMap = (HashMap<String, List<Object>>) actionData.get("qEntities");
            if (qualifiedCampaignMap == null) {
                return null;
            }
            List<HashMap<String, Object>> result = createPropertyListWithProcessedCampaigns(qualifiedCampaignMap);
            Logger.d(TAG, "InLinePersonalizationAction show campaign  pre-execute: " + new JSONArray(result));
            return result;
        } else {
            Logger.d(TAG, "Not processing inline campaigns as their is no change, new ids:" +
                    " " + inLineIds + " old ids: " + olderInlineCampaigns);
        }
        DataHolder.get().setOlderQualifiedInlineCampaigns(inLineIds);
        return null;
    }

    private List<HashMap<String, Object>> createPropertyListWithProcessedCampaigns(HashMap<String, List<Object>> processedCampaigns) {
        List<HashMap<String, Object>> result = new ArrayList<>();
        List<HashMap<String, Object>> properties = DataHolder.get().getInlineProperties();
        if (null != properties) {
            for (HashMap<String, Object> _property : properties) {
                HashMap<String, Object> property = new HashMap<>(_property);
                String targetView = (String) property.get("targetView");
                if (targetView == null || TextUtils.isEmpty(targetView.trim())) {
                    continue;
                }
                targetView = targetView.trim();
                if (isPropertyRulePasses(property)) {
                    if (!processedCampaigns.containsKey(targetView)) {
                        result.add(property);
                    } else {
                        if(processedCampaigns.get(targetView) != null) {
                            for (Object entityObject: processedCampaigns.get(targetView)) {
                                if (entityObject == null)
                                    continue;
                                HashMap<String, Object> _entityObject = (HashMap<String, Object>) entityObject;
                                String experimentId = (String) _entityObject.get("notificationEncId");
                                Map<String, String> layoutIdMap = getVariationMap().get(experimentId);
                                String variationId = null;
                                //layoutIdMap will be null for CG
                                if (layoutIdMap != null) {
                                    variationId = layoutIdMap.keySet().iterator().next();
                                }

                                HashMap<String, Object> singleProperty = new HashMap<>(property);
                                if (variationId != null) {
                                    singleProperty.put("variationId", variationId);
                                    singleProperty.put("params", getParams(variationId));
                                } else {
                                    singleProperty.put(WebEngageConstant.CONTROL_GROUP, true);
                                }
                                singleProperty.put("campaign", entityObject);
                                result.add(singleProperty);
                                //only adding till a valid non CG campaign
                                if (variationId != null)
                                    break;
                            }
                        }
                    }
                } else {
                    Logger.d(TAG, "Ignoring property: " + targetView + " with Id: " + property.get("p_id") + " because screen rule failed");
                }
            }
        }
        return result;
    }

    @Override
    protected Object execute(Object data) {
        if (data == null) {
            return null;
        }
        HashMap<String, Object> personalizationResult = new HashMap<>();
        List<HashMap<String, Object>> result = (List<HashMap<String, Object>>) data;
        Logger.d(TAG, "InLinePersonalizationAction show campaign  execute: " + result.size());

        HashMap<String, Object> systemData = new HashMap<>();
        if (!result.isEmpty()) {
            systemData.put("luid", getLUID());
            systemData.put("cuid", getCUID());
            systemData.put("base_url", WebEngageConstant.Urls.PERSONALISATION_BASE.toString());
            personalizationResult.put("systemData", systemData);
            personalizationResult.put("properties", data);
            personalizationResult.put("limit", DataHolder.get().getIPCampaignLimit());
            Analytics analytics = AnalyticsFactory.getAnalytics(mContext);
            WeakReference<Activity> activityWeakReference = analytics.getActivity();
            if (null != activityWeakReference && null != activityWeakReference.get()
                    && !activityWeakReference.get().isFinishing()) {
                CallbackDispatcher.init(mContext).propertiesReceived(activityWeakReference, personalizationResult);
            }
        }
        return null;
    }

    private String getParams(String variationId) {
        Map<String, List<Object>> tokens = DataHolder.get().getTokens();
        if (tokens != null) {
            List<Object> variationTokens = (List<Object>) tokens.get(variationId);
            if (variationTokens != null) {
                for (Object obj : variationTokens) {
                    List<Object> variable = (ArrayList<Object>) obj;
                    if (variable != null && variable.size() > 0) {
                        Object result = RuleExecutorFactory.getRuleExecutor().getFunction("$we_getResolvedData").onEvaluation(variable);
                        if (result != null) {
                            List<Object> list = new ArrayList<>();
                            list.add(variationId);
                            list.addAll(variable);
                            DataHolder.get().setData(list, result);

                        }
                    }
                }
            }
        }
        HashMap<String, Object> data = (HashMap<String, Object>) DataHolder.get().getData(variationId);
        if (data == null)
            data = new HashMap<>();
        String params = "";
        try {
            params = (String) DataType.convert(data, DataType.STRING, true);
        } catch (Exception e) {
        }
        return params;
    }

    private boolean isPropertyRulePasses(Map<String, Object> property) {
        RuleExecutor ruleExecutor = RuleExecutorFactory.getRuleExecutor();
        String customRule = String.valueOf(property.get("pageRuleCode"));
        Rule rule = new Rule(customRule);
        return ruleExecutor.evaluateRule(rule, WebEngageConstant.RuleCategory.CUSTOM_RULE);
    }

    @Override
    protected void postExecute(Object data) {

    }
}
