package com.webengage.sdk.android.actions.render;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.RemoteViews;

import com.webengage.sdk.android.Logger;
import com.webengage.sdk.android.PendingIntentFactory;
import com.webengage.sdk.android.R;
import com.webengage.sdk.android.callbacks.CustomPushRender;
import com.webengage.sdk.android.callbacks.CustomPushRerender;
import com.webengage.sdk.android.utils.WebEngageConstant;
import com.webengage.sdk.android.utils.gifUtils.WEGifHelper;
import com.webengage.sdk.android.utils.http.CachePolicy;
import com.webengage.sdk.android.utils.http.RequestMethod;
import com.webengage.sdk.android.utils.http.RequestObject;
import com.webengage.sdk.android.utils.http.WENetworkUtil;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OverlayRenderer extends PushRenderer implements CustomPushRender, CustomPushRerender {
    NotificationConfigurator notificationConfigurator = null;
    private Notification.Builder mBuilder = null;
    List<Bitmap> expandedImages = null;
    List<Bitmap> collapsedImages = null;
    Notification notification = null;
    private WEGifHelper weGifCollapsedHelper;
    private WEGifHelper weGifExpandedHelper;
    Boolean isCollapsedGif = false;

    @Override
    void downloadImages() {
    }

    @Override
    void loadImages() {

    }

    @Override
    void buildExpandedPush() {

    }

    private void loadImages(PushNotificationData pushNotificationData, Context applicationContext) {
        if (pushNotificationData.getOverlayStyle() != null && !TextUtils.isEmpty(pushNotificationData.getOverlayStyle().getExpandedImageUrl())) {
            List<Bitmap> expandedBitMapList = loadImageWithURL(applicationContext, pushNotificationData.getOverlayStyle().getExpandedImageUrl(), "expanded");
            expandedImages.addAll(expandedBitMapList);
        }

        if (pushNotificationData.getOverlayStyle() != null && !TextUtils.isEmpty(pushNotificationData.getOverlayStyle().getCollapsedImageUrl())) {
            List<Bitmap> collapsedBitMapList = loadImageWithURL(applicationContext, pushNotificationData.getOverlayStyle().getCollapsedImageUrl(), "collapsed");
            collapsedImages.addAll(collapsedBitMapList);
        }

    }

    private List<Bitmap> loadImageWithURL(Context applicationContext, String imageUrl, String imageType) {
        List<Bitmap> imageList = new ArrayList<>();
        try {
            if (imageUrl != null) {
                HashMap<String, String> headers = new HashMap<>();
                headers.put("accept", WENetworkUtil.getAcceptHeadersForPushImages(imageUrl));
                RequestObject requestObject = new RequestObject.Builder(imageUrl, RequestMethod.GET, applicationContext)
                        .setCachePolicy(CachePolicy.GET_DATA_FROM_CACHE_FIRST_ELSE_DOWNLOAD_AND_CACHE)
                        .setTag(WebEngageConstant.LANDSCAPE)
                        .setHeaders(headers)
                        .build();
                InputStream responseStream = null;
                try {
                    Map<String, Object> result = WENetworkUtil.makeRequest(applicationContext, requestObject, true, true);
                    responseStream = (InputStream) result.get("data");
                    String contentType = "";
                    if (result.containsKey("content-type")) {
                        contentType = (String) result.get("content-type");
                    }
                    if (WebEngageConstant.IMAGE_GIF_TYPE.equals(contentType)) {
                        List<Bitmap> bitmapList;
                        if (imageType.equals("expanded")) {
                            weGifExpandedHelper = new WEGifHelper();
                            bitmapList = weGifExpandedHelper.decodeGif(responseStream);
                            isGIF = true;
                        } else {
                            weGifCollapsedHelper = new WEGifHelper();
                            bitmapList = weGifCollapsedHelper.decodeGif(responseStream);
                            isCollapsedGif = true;
                        }

                        imageList.addAll(bitmapList);
                    } else {
                        Bitmap bitmap = notificationConfigurator.loadImage(responseStream);
                        imageList.add(bitmap);
                    }
                    responseStream.close();
                } catch (Exception e) {
                    if (responseStream != null) {
                        try {
                            responseStream.close();
                        } catch (IOException ioException) {
                            ioException.printStackTrace();
                        }
                    }
                    e.printStackTrace();
                }
            }
        } catch (Exception e) {
            Logger.e(WebEngageConstant.TAG, "Overlay renderer can not load " + imageType + " image with exception ->" + e);
        }
        return imageList;
    }

    @Override
    public boolean onRender(Context context, PushNotificationData pushNotificationData) {
        initializeNotification(context, pushNotificationData);
        loadLargeIcon();
        attachCollapsedPushBase(context);
        notification = notificationConfigurator.buildNotification(mBuilder);
        attachExpandedPushBase(context);
        notificationConfigurator.showNotification(notification, context, pushNotificationData.getVariationId().hashCode());
        return true;
    }

    private void initializeNotification(Context context, PushNotificationData pushNotificationData) {
        if (notificationConfigurator == null)
            notificationConfigurator = new NotificationConfigurator();
        if (when == null) {
            when = System.currentTimeMillis();
        }
        this.pushNotificationData = pushNotificationData;
        expandedImages = new ArrayList<>();
        collapsedImages = new ArrayList<>();
        this.applicationContext = context;
        validImages = new ArrayList<>();
        loadImages(pushNotificationData, context);
        String channelId = notificationConfigurator.getChannelId(pushNotificationData, context);
        if (Build.VERSION.SDK_INT >= 26) {
            mBuilder = new Notification.Builder(context, channelId);
        } else {
            mBuilder = new Notification.Builder(context);
        }
        notificationConfigurator.buildNotificationBuilder(mBuilder, pushNotificationData, context);
        if (pushNotificationData.getAutoDismissTime() != null)
            calculateAutoDismissTime();
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O && autoDismissTime != -1) {
            if (when != null) {
                //this is done for re render notifications
                mBuilder.setTimeoutAfter(autoDismissTime - (System.currentTimeMillis() - when));
            } else
                mBuilder.setTimeoutAfter(autoDismissTime);
        }
    }

    //attaching collapsed remote view to builder
    private void attachCollapsedPushBase(Context context) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            mBuilder.setCustomContentView(constructCollapsedPushBase(context, pushNotificationData));
        } else {
            mBuilder.setContent(constructCollapsedPushBase(context, pushNotificationData));
        }
    }

    //attaching expanded remote view to notification
    private void attachExpandedPushBase(Context context) {
        if (Build.VERSION.SDK_INT <= 23) {
            notification.bigContentView = constructExpandedPushBase(context, pushNotificationData);
        } else {
            notification = mBuilder.setCustomBigContentView(constructExpandedPushBase(context, pushNotificationData)).build();
        }
    }

    public RemoteViews constructCollapsedPushBase(Context context, PushNotificationData pushNotificationData) {
        RemoteViews remoteView;
        String subStyle = "";
        if (pushNotificationData.getOverlayStyle().getSubStyle() != null)
            subStyle = pushNotificationData.getOverlayStyle().getSubStyle();
        switch (subStyle) {
            case WebEngageConstant.OVERLAY2:
                remoteView = constructRemoteViewWithLayoutId(context, R.layout.overlay_half_layout);
                return constructCollapsedHalfImage(remoteView, context, pushNotificationData);
            case WebEngageConstant.OVERLAY3:
                remoteView = constructRemoteViewWithLayoutId(context, R.layout.overlay_layout);
                return constructCollapsedNoImage(remoteView, pushNotificationData);
            default:
                remoteView = constructRemoteViewWithLayoutId(context, R.layout.overlay_layout);
                return constructCollapsedFullImage(remoteView, context, pushNotificationData);
        }

    }

    private RemoteViews constructRemoteViewWithLayoutId(Context context, int layoutId) {
        RemoteViews remoteView = notificationConfigurator.getCustomPushBase(context, pushNotificationData, when, layoutId);
        remoteView.setOnClickPendingIntent(R.id.we_notification_container, PendingIntentFactory.constructPushClickPendingIntent(context, pushNotificationData, pushNotificationData.getPrimeCallToAction(), true));
        return remoteView;
    }

    //for full image
    private RemoteViews constructCollapsedFullImage(RemoteViews remoteView, Context context, PushNotificationData pushNotificationData) {

        if (isCollapsedGif) {
            showCollapsedFullGif(remoteView, context);
            setLeftPadding(remoteView, context);
        } else {
            showCollapsedFullImage(remoteView, context);
        }
        notificationConfigurator.setTitleMaxLines(remoteView, 1);
        notificationConfigurator.setDescriptionMaxLines(remoteView, 1);
        if (pushNotificationData.getBackgroundColor() != Color.parseColor(WebEngageConstant.WE_TRANSPARENT_COLOR))
            remoteView.setInt(R.id.we_notification_container, "setBackgroundColor", pushNotificationData.getBackgroundColor());

        if (Boolean.FALSE.equals(pushNotificationData.getOverlayStyle().getAppNameVisibility()))
            remoteView.setViewVisibility(R.id.top_base_layout, View.GONE);


        remoteView.setViewVisibility(R.id.large_icon, View.GONE);
        return remoteView;
    }

    private void showCollapsedFullImage(RemoteViews remoteView, Context context) {
        //hide expanded bg image
        remoteView.setViewVisibility(R.id.we_notification_expanded_bg_image, View.INVISIBLE);
        remoteView.setViewVisibility(R.id.we_notification_expanded_view_flipper, View.GONE);
        //show collapsed full bg image
        remoteView.setViewVisibility(R.id.we_notification_collapsed_bg_image, View.VISIBLE);
        setCollapsedImage(remoteView, R.id.we_notification_collapsed_bg_image, context);
        remoteView.setViewVisibility(R.id.push_base_margin_view, View.VISIBLE);
    }

    private void showCollapsedFullGif(RemoteViews remoteView, Context context) {
        weGifCollapsedHelper.constructViewFlipper(remoteView, collapsedImages, context, R.id.collapsed_view_flipper);
        //hide expanded bg image and show gif
        remoteView.setViewVisibility(R.id.we_notification_expanded_view_flipper, View.VISIBLE);
        remoteView.setViewVisibility(R.id.we_notification_expanded_bg_image, View.GONE);
    }


    //for half image
    private RemoteViews constructCollapsedHalfImage(RemoteViews remoteView, Context context, PushNotificationData pushNotificationData) {

        if (isCollapsedGif) {
            showCollapseHalfGif(remoteView, context);
        } else {
            showCollapsedHalfImage(remoteView, context);
        }
        if (pushNotificationData.getBackgroundColor() != Color.parseColor(WebEngageConstant.WE_TRANSPARENT_COLOR))
            remoteView.setInt(R.id.we_notification_container, "setBackgroundColor", pushNotificationData.getBackgroundColor());
        if (Boolean.FALSE.equals(pushNotificationData.getOverlayStyle().getAppNameVisibility()))
            remoteView.setViewVisibility(R.id.top_base_layout, View.GONE);
        remoteView.setViewVisibility(R.id.large_icon, View.GONE);
        notificationConfigurator.setTitleMaxLines(remoteView, 1);
        notificationConfigurator.setDescriptionMaxLines(remoteView, 1);
        remoteView.setViewVisibility(R.id.push_base_margin_view, View.VISIBLE);
        return remoteView;
    }

    private void showCollapsedHalfImage(RemoteViews remoteView, Context context) {
        //showing half image
        remoteView.setViewVisibility(R.id.we_notification_half_image, View.VISIBLE);
        remoteView.setViewVisibility(R.id.collapsed_half_view_flipper, View.GONE);
        setCollapsedImage(remoteView, R.id.we_notification_half_image, context);
    }

    private void showCollapseHalfGif(RemoteViews remoteView, Context context) {
        weGifCollapsedHelper.constructViewFlipper(remoteView, collapsedImages, context, R.id.collapsed_half_view_flipper);
        // hide half image
        remoteView.setViewVisibility(R.id.we_notification_half_image, View.GONE);
        remoteView.setViewVisibility(R.id.collapsed_half_view_flipper, View.VISIBLE);
    }


    private RemoteViews constructCollapsedNoImage(RemoteViews remoteView, PushNotificationData pushNotificationData) {

        //hide expanded bg image
        remoteView.setViewVisibility(R.id.we_notification_expanded_bg_image, View.INVISIBLE);
        //hide half image
        remoteView.setViewVisibility(R.id.we_notification_half_image, View.GONE);
        //hide collapsed full bg image
        remoteView.setViewVisibility(R.id.we_notification_collapsed_bg_image, View.GONE);

        remoteView.setViewVisibility(R.id.large_icon, View.VISIBLE);

        notificationConfigurator.setTitleMaxLines(remoteView, 1);
        notificationConfigurator.setDescriptionMaxLines(remoteView, 1);
        remoteView.setViewVisibility(R.id.push_base_margin_view, View.VISIBLE);
        if (pushNotificationData.getBackgroundColor() != Color.parseColor(WebEngageConstant.WE_TRANSPARENT_COLOR))
            remoteView.setInt(R.id.we_notification_container, "setBackgroundColor", pushNotificationData.getBackgroundColor());
        if (Boolean.FALSE.equals(pushNotificationData.getOverlayStyle().getAppNameVisibility()))
            remoteView.setViewVisibility(R.id.top_base_layout, View.GONE);
        return remoteView;
    }

    // expanded view
    public RemoteViews constructExpandedPushBase(Context context, PushNotificationData pushNotificationData) {
        RemoteViews customBigView = notificationConfigurator.getCustomPushBase(context, pushNotificationData, when, R.layout.overlay_layout);
        customBigView.setOnClickPendingIntent(R.id.we_notification_container, PendingIntentFactory.constructPushClickPendingIntent(context, pushNotificationData, pushNotificationData.getPrimeCallToAction(), true));
        notificationConfigurator.setTitleMaxLines(customBigView, 2);
        notificationConfigurator.setDescriptionMaxLines(customBigView, 2);

        if (isGIF) {
            showExpandedGif(customBigView, context);
        } else {
            showExpandedImage(customBigView);
        }
        setLeftPadding(customBigView, context);
        if (pushNotificationData.getBackgroundColor() != Color.parseColor(WebEngageConstant.WE_TRANSPARENT_COLOR))
            customBigView.setInt(R.id.we_notification_container, "setBackgroundColor", pushNotificationData.getBackgroundColor());
        notificationConfigurator.addIntents(customBigView, mBuilder, pushNotificationData, context);
        //hide collapsed bg image
        customBigView.setViewVisibility(R.id.we_notification_collapsed_bg_image, View.GONE);
        // hide large icon
        customBigView.setViewVisibility(R.id.large_icon, View.GONE);

        if (Boolean.FALSE.equals(pushNotificationData.getOverlayStyle().getAppNameVisibility()))
            customBigView.setViewVisibility(R.id.top_base_layout, View.GONE);

        return customBigView;
    }

    private void showExpandedImage(RemoteViews customBigView) {
        //hide collapsed bg image
        customBigView.setViewVisibility(R.id.we_notification_collapsed_bg_image, View.GONE);
        //Use image url and render on we_notification_expanded_bg_image
        if (!expandedImages.isEmpty() && expandedImages.get(0) != null) {
            setBitmapToRemoteView(expandedImages.get(0), customBigView, R.id.we_notification_expanded_bg_image);
        } else {
            customBigView.setViewVisibility(R.id.we_notification_expanded_bg_image, View.GONE);
        }
    }

    private void showExpandedGif(RemoteViews customBigView, Context context) {
        weGifExpandedHelper.constructViewFlipper(customBigView, expandedImages, context, R.id.we_notification_expanded_view_flipper);
        customBigView.setViewVisibility(R.id.we_notification_expanded_view_flipper, View.VISIBLE);
        //Hide expanded bg image
        customBigView.setViewVisibility(R.id.we_notification_expanded_bg_image, View.GONE);
    }

    private void setCollapsedImage(RemoteViews remoteView, int imageId, Context context) {
        if (!collapsedImages.isEmpty()) {
            if (collapsedImages.get(0) != null) {
                setBitmapToRemoteView(collapsedImages.get(0), remoteView, imageId);
                setLeftPadding(remoteView, context);
            } else
                remoteView.setViewVisibility(imageId, View.GONE);
        } else {
            remoteView.setViewVisibility(imageId, View.GONE);
        }
    }

    private void setLeftPadding(RemoteViews remoteView, Context context) {
        boolean isAndroid12 = Build.VERSION.SDK_INT >= Build.VERSION_CODES.S && context.getApplicationInfo().targetSdkVersion >= Build.VERSION_CODES.S;
        if (isAndroid12) {
            int leftPadding = context.getResources().getDimensionPixelSize(R.dimen.we_push_content_margin_colorbg);
            remoteView.setViewPadding(R.id.custom_head_container, leftPadding, 0, leftPadding, 0);
        }
    }

    @Override
    public boolean onRerender(Context context, PushNotificationData pushNotificationData, Bundle extras) {
        initializeNotification(context, pushNotificationData);
        attachCollapsedPushBase(context);
        notification = notificationConfigurator.buildNotification(mBuilder);
        attachExpandedPushBase(context);
        notificationConfigurator.showNotification(notification, context, pushNotificationData.getVariationId().hashCode());
        return true;
    }
}
