package com.webengage.sdk.android.actions.render;

import android.app.AlarmManager;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;

import com.webengage.sdk.android.Action;
import com.webengage.sdk.android.CallbackDispatcher;
import com.webengage.sdk.android.EventFactory;
import com.webengage.sdk.android.EventName;
import com.webengage.sdk.android.EventPayload;
import com.webengage.sdk.android.IntentFactory;
import com.webengage.sdk.android.Logger;
import com.webengage.sdk.android.PendingIntentFactory;
import com.webengage.sdk.android.PushUtils;
import com.webengage.sdk.android.Topic;
import com.webengage.sdk.android.UserSystemAttribute;
import com.webengage.sdk.android.WebEngage;
import com.webengage.sdk.android.actions.database.DataHolder;
import com.webengage.sdk.android.callbacks.CustomPushRender;
import com.webengage.sdk.android.callbacks.CustomPushRerender;
import com.webengage.sdk.android.utils.WebEngageConstant;
import com.webengage.sdk.android.utils.WebEngageUtils;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PushNotificationAction extends Action {
    private final Context applicationContext;
    private PushNotificationData pushNotificationData = null;
    private String id = "";
    private boolean isFirstRun = true;
    private boolean we_render = false;

    private Map<String, Object> systemData = null;
    private Map<String, Object> eventData = null;
    private Map<String, Object> extraData = null;
    //added for dismissing Old Progress bar/Big Timer Notification to match functionality below Android 14
    private Boolean isProgressOrBigTimerNotification = false;

    protected PushNotificationAction(Context context) {
        super(context);
        this.applicationContext = context.getApplicationContext();
    }

    @Override
    public Object preExecute(Map<String, Object> actionAttributes) {
        String properties = null;

        isFirstRun = (boolean) actionAttributes.get(RenderingController.FIRST_TIME);
        if (!isFirstRun) {
            EventPayload eventPayload = (EventPayload) actionAttributes.get(RenderingController.ACTION_DATA);
            systemData = eventPayload.getSystemData();
            eventData = eventPayload.getEventData();
            extraData = eventPayload.getExtraData();
            if (systemData != null) {
                id = (String) systemData.get(WebEngageConstant.NOTIFICATION_ID);
            }
        } else {
            id = (String) actionAttributes.get(RenderingController.ACTION_DATA);
        }

        properties = getVolatileData(id);

        try {
            pushNotificationData = new PushNotificationData(new JSONObject(properties), applicationContext);
        } catch (Exception e) {
            dispatchExceptionTopic(e);
            return null;
        }

        if (eventData == null) {
            eventData = new HashMap<String, Object>();
        }
        eventData.put(WebEngageConstant.AMPLIFIED, pushNotificationData.isAmplified());

        //added for dismissing Old Progress bar/Big Timer Notification to match functionality below Android 14
        String previousId = getVolatileData(WebEngageConstant.PREVIOUS_PROGRESS_NOTIFICATION_ID);
        Boolean isPreviousNotificationIdPresent = !TextUtils.isEmpty(previousId);
        Boolean isDifferentNotification = isPreviousNotificationIdPresent
                && Integer.parseInt(previousId) != pushNotificationData.getVariationId().hashCode();
        isProgressOrBigTimerNotification = pushNotificationData.getStyle() != null &&
                (WebEngageConstant.STYLE.PROGRESS_BAR.equals(pushNotificationData.getStyle()) ||
                        WebEngageConstant.STYLE.BIG_TIMER.equals(pushNotificationData.getStyle()));
        if (isFirstRun) {
            /*Cancelling old progress bar and big timer notification
              Required for above API 32 due to FCM low priority message
              or ForegroundService type restrictions in API34
             */
            if (isProgressOrBigTimerNotification && isPreviousNotificationIdPresent) {
                if (WebEngageConstant.STYLE.PROGRESS_BAR.equals(pushNotificationData.getStyle())) {
                    AlarmManager alarmManager = (AlarmManager) applicationContext.getSystemService(Context.ALARM_SERVICE);
                    PendingIntent pendingIntent = PendingIntentFactory.constructProgressBarRerenderPendingIntent(applicationContext, pushNotificationData, "progressbar_update", null);
                    alarmManager.cancel(pendingIntent);
                }
                Logger.d(WebEngageConstant.TAG, "Dismissing older notifications \n" +
                        "isProgressOrBigTimerNotification " + isProgressOrBigTimerNotification + "\n" +
                        "isPreviousNotificationIdPresent " + isPreviousNotificationIdPresent);
                NotificationManager manager = (NotificationManager) applicationContext.getSystemService(Context.NOTIFICATION_SERVICE);
                manager.cancel(Integer.parseInt(previousId));

            }

            systemData = new HashMap<>();
            systemData.put(WebEngageConstant.EXPERIMENT_ID, pushNotificationData.getExperimentId());
            systemData.put(WebEngageConstant.NOTIFICATION_ID, pushNotificationData.getVariationId());
            dispatchEventTopic(EventFactory.newSystemEvent(EventName.PUSH_NOTIFICATION_RECEIVED, systemData, eventData, null, applicationContext));
            if (pushNotificationData != null) {
                PushNotificationData modifiedData = getCallbackDispatcher(this.applicationContext).onPushNotificationReceived(this.applicationContext, pushNotificationData);
                if (modifiedData != null) {
                    pushNotificationData = modifiedData;
                }
            }

            Boolean userOptIn = (Boolean) DataHolder.get().getUserSystemData(UserSystemAttribute.PUSH_OPT_IN.toString());
            userOptIn = userOptIn == null || userOptIn;
            if (!userOptIn) {
                logPushFailureEvent(WebEngageConstant.FAILURE_REASONS.USER_PUSH_OPTED_OUT);
                return null;
            }

            //checking if push notifications are enabled
            boolean deviceOptIn = PushUtils.checkForPushOptIn(applicationContext);
            if(deviceOptIn){
                WebEngage.get().user().setDevicePushOptIn(true);
            } else {
                WebEngage.get().user().setDevicePushOptIn(false);
                logPushFailureEvent(WebEngageConstant.FAILURE_REASONS.DEVICE_PUSH_OPTED_OUT);
                return null;
            }

            //added for channel failure
            NotificationConfigurator notificationConfigurator = new NotificationConfigurator();
            String channelId = notificationConfigurator.getChannelId(pushNotificationData, applicationContext);
            if (Build.VERSION.SDK_INT >= 26 && !notificationConfigurator.isNotificationChannelEnabled(applicationContext, channelId)) {
                logPushFailureEvent(WebEngageConstant.FAILURE_REASONS.CHANNEL_OPTED_OUT);
                return null;
            }
            if (pushNotificationData != null) {
                if (pushNotificationData.shouldRender()) {
                    return pushNotificationData;
                }
            }
        } else {
            if (isProgressOrBigTimerNotification) {
                //old alarm for progress bar notification should not be re rendered
                if (WebEngageUtils.mapToBundle(extraData).getBoolean(WebEngageConstant.WE_RENDER, false) &&
                        isProgressOrBigTimerNotification &&
                        isPreviousNotificationIdPresent && isDifferentNotification) {
                    return null;
                }
            }

            return pushNotificationData;
        }

        return null;
    }

    @Override
    public Object execute(Object data) {
        if (data != null) {
            boolean isCustomPushRender = pushNotificationData.isCustomRender();

            if (isFirstRun) {
                CustomPushRender customPushRender = null;
                CallbackDispatcher callbackDispatcher = getCallbackDispatcher(this.applicationContext);
                if (isCustomPushRender && callbackDispatcher.isCustomRenderRegistered()) {
                    customPushRender = callbackDispatcher;
                } else {
                    //saving old progress bar and big timer notification hashed variation id
                    if (isProgressOrBigTimerNotification) {
                        saveVolatileData(WebEngageConstant.PREVIOUS_PROGRESS_NOTIFICATION_ID, "" + pushNotificationData.getVariationId().hashCode());
                    }
                    customPushRender = PushRendererFactory.getRender(this.pushNotificationData.getStyle());
                }
                if (customPushRender != null) {
                    return customPushRender.onRender(this.applicationContext, pushNotificationData);
                } else {
                    logPushFailureEvent(WebEngageConstant.FAILURE_REASONS.UNKNOWN_SDK_FAILURE);
                    Logger.e(WebEngageConstant.TAG, "CustomPushRender is null");
                }
            } else {
                Bundle extras = WebEngageUtils.mapToBundle(extraData);
                we_render = extras != null && extras.getBoolean(WebEngageConstant.WE_RENDER, false);
                CustomPushRerender customPushRerender = null;
                if (we_render) {
                    customPushRerender = PushRendererFactory.getRerender(this.pushNotificationData.getStyle());
                } else {
                    customPushRerender = getCallbackDispatcher(this.applicationContext);
                }
                if (customPushRerender != null) {
                    return customPushRerender.onRerender(this.applicationContext, pushNotificationData, extras);
                } else {
                    Logger.e(WebEngageConstant.TAG, "CustomPushRerender is null");
                }
            }
        }
        return null;
    }

    @Override
    public void postExecute(Object data) {
        if (data != null) {
            Boolean shown = (Boolean) data;
            if (shown) {
                if (isFirstRun) {
                    dispatchEventTopic(EventFactory.newSystemEvent(EventName.PUSH_NOTIFICATION_VIEW, systemData, eventData, null, applicationContext));
                    getCallbackDispatcher(this.applicationContext).onPushNotificationShown(this.applicationContext, pushNotificationData);
                } else {
                    if (pushNotificationData.getStyle() == WebEngageConstant.STYLE.CAROUSEL_V1 && pushNotificationData.getCarouselV1Data() != null) {
                        List<CarouselV1CallToAction> carouselV1CallToActions = pushNotificationData.getCarouselV1Data().getCallToActions();

                        int currIndex = pushNotificationData.getCurrentIndex();

                        int prevIndex = 0;
                        if (extraData != null && extraData.containsKey(WebEngageConstant.CURRENT) && extraData.get(WebEngageConstant.CURRENT) != null) {
                            prevIndex = (Integer) extraData.get(WebEngageConstant.CURRENT);
                        }

                        String navigation = WebEngageConstant.RIGHT;
                        if (extraData != null && extraData.containsKey(WebEngageConstant.NAVIGATION) && extraData.get(WebEngageConstant.NAVIGATION) != null) {
                            navigation = (String) extraData.get(WebEngageConstant.NAVIGATION);
                        }

                        systemData.put(WebEngageConstant.CTA_ID, carouselV1CallToActions.get(currIndex).getId());
                        systemData.put(WebEngageConstant.NAVIGATED_FROM, carouselV1CallToActions.get(prevIndex).getId());
                        systemData.put(WebEngageConstant.NAVIGATION, navigation);

                        if (extraData != null) {
                            eventData.putAll(extraData);
                        }

                        Intent notificationBrowsedIntent = IntentFactory.newIntent(Topic.EVENT, EventFactory.newSystemEvent(EventName.PUSH_NOTIFICATION_ITEM_VIEW, systemData, eventData, null, applicationContext), applicationContext);
                        WebEngage.startService(notificationBrowsedIntent, applicationContext, null);
                    } else {
                        if (pushNotificationData.getStyle() != WebEngageConstant.STYLE.RATING_V1 && !we_render) {
                            if (extraData != null) {
                                eventData.putAll(extraData);
                            }
                            Intent pushRerenderIntent = IntentFactory.newIntent(Topic.EVENT, EventFactory.newSystemEvent(EventName.PUSH_NOTIFICATION_RERENDER, systemData, eventData, extraData, applicationContext), applicationContext);
                            WebEngage.startService(pushRerenderIntent, applicationContext, null);
                        }
                    }

                }
            } else {
                if (!pushNotificationData.getStyle().equals(WebEngageConstant.STYLE.TIMER)
                        && !pushNotificationData.getStyle().equals(WebEngageConstant.STYLE.BIG_TIMER)
                        && !pushNotificationData.getStyle().equals(WebEngageConstant.STYLE.PROGRESS_BAR)) {
                    logPushFailureEvent(WebEngageConstant.FAILURE_REASONS.UNKNOWN_SDK_FAILURE);
                }
                Logger.e(WebEngageConstant.TAG, "Push notification is not rendered.");
            }
        }
    }

    private void logPushFailureEvent(WebEngageConstant.FAILURE_REASONS failureReason) {
        eventData.put(WebEngageConstant.WE_ERROR_CODE, failureReason.getErrorCode());
        eventData.put(WebEngageConstant.WE_FAILURE_REASON, failureReason.toString());
        eventData.put(WebEngageConstant.WE_FAILURE_MESSAGE, failureReason.getErrorMessage());
        dispatchEventTopic(EventFactory.newSystemEvent(EventName.PUSH_NOTIFICATION_FAILED, systemData, eventData, null, applicationContext));
        Logger.e(WebEngageConstant.TAG, "Push failed to render with reason : " + failureReason.getErrorMessage());
    }
}
