package com.webengage.sdk.android.actions.render;


import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;

import com.webengage.sdk.android.Action;
import com.webengage.sdk.android.AnalyticsFactory;
import com.webengage.sdk.android.EventName;
import com.webengage.sdk.android.EventPayload;
import com.webengage.sdk.android.IntentFactory;
import com.webengage.sdk.android.Logger;
import com.webengage.sdk.android.Subscriber;
import com.webengage.sdk.android.Topic;
import com.webengage.sdk.android.UserDeviceAttribute;
import com.webengage.sdk.android.WebEngage;
import com.webengage.sdk.android.actions.database.DataHolder;
import com.webengage.sdk.android.utils.WebEngageConstant;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class RenderingController implements Subscriber {
    protected static final String ACTION_DATA = "action_data";
    protected static final String FIRST_TIME = "first_time";
    private Context applicationContext = null;
    private static RenderingController instance = null;

    public static final Factory FACTORY = new Factory() {
        @Override
        public Subscriber initialize(Context context) {
            if (instance == null) {
                instance = new RenderingController(context);
            }
            return instance;
        }
    };

    private RenderingController(Context context) {
        this.applicationContext = context.getApplicationContext();
    }

    @Override
    public void createAction(Topic topic, Object data) {
        switch (topic) {
            case GCM_MESSAGE:
                Bundle extras = (Bundle) data;
                if (extras != null && extras.containsKey(WebEngageConstant.GCM_MESSAGE_SOURCE) && ("webengage").equalsIgnoreCase(extras.getString(WebEngageConstant.GCM_MESSAGE_SOURCE))) {
                    String action = extras.getString(WebEngageConstant.GCM_MESSAGE_ACTION_KEY);
                    if (action != null && action.equalsIgnoreCase(WebEngageConstant.SHOW_SYSTEM_TRAY_NOTIFICATION) && extras.containsKey("message_data")) {
                        try {
                            String message = extras.getString("message_data");
                            Logger.d(WebEngageConstant.TAG, " Push Payload: " + message);
                            JSONObject gcmMessage = new JSONObject(message);

                            if (gcmMessage.has("testing_details") && DataHolder.get().isAppForeground()) {
                                //removing currently running In-App
                                if (DataHolder.get().getData("entity_is_running") != null && ((AtomicBoolean) DataHolder.get().getData("entity_is_running")).get()) {
                                    WeakReference<Activity> activityWeakReference = AnalyticsFactory.getAnalytics(this.applicationContext).getActivity();
                                    removeRenderDialogFragment(activityWeakReference.get().getFragmentManager());
                                }
                                invokeTestInApp(gcmMessage.getJSONObject("testing_details"));

                            }
                            Action systemTrayNotificationAction = new PushNotificationAction(applicationContext);
                            systemTrayNotificationAction.performActionSync(getActionAttributes(topic, gcmMessage.getString("identifier")));
                            if (gcmMessage.has("testing_details") && DataHolder.get().isAppForeground()) {
                                NotificationManager manager = (NotificationManager) applicationContext.getSystemService(Context.NOTIFICATION_SERVICE);
                                manager.cancel(gcmMessage.getString("identifier").hashCode());
                            }
                        } catch (JSONException e) {
                            WebEngage.startService(IntentFactory.newIntent(Topic.EXCEPTION, e, this.applicationContext), applicationContext);
                        }
                    }
                }
                break;

            case RENDER:
                if (DataHolder.get().getData(WebEngageConstant.IN_APP_TESTING_DATA) != null && DataHolder.get().isAppForeground()) {
                    WeakReference<Activity> activityWeakReference = AnalyticsFactory.getAnalytics(applicationContext).getActivity();
                    if (activityWeakReference != null && activityWeakReference.get() != null
                            && !activityWeakReference.get().isFinishing() && DataHolder.get().getData("entity_is_running") != null
                            && ((AtomicBoolean) DataHolder.get().getData("entity_is_running")).get()) {
                        removeRenderDialogFragment(activityWeakReference.get().getFragmentManager());
                    }
                    if (activityWeakReference != null && activityWeakReference.get() != null
                            && !activityWeakReference.get().isDestroyed()
                            && DataHolder.get().compareAndSetEntityRunningState(false, true)) {
                        removeRenderDialogFragment(activityWeakReference.get().getFragmentManager());
                        invokeTestInApp((JSONObject) DataHolder.get().getData(WebEngageConstant.IN_APP_TESTING_DATA));
                        DataHolder.get().setData(WebEngageConstant.IN_APP_TESTING_DATA, null);
                    }
                } else {
                    Action renderingAction = null;
                    List<String> renderingIds = (List<String>) data;
                    if (renderingIds != null && renderingIds.size() > 0) {
                        for (String id : renderingIds) {
                            Boolean deviceOptIn = (Boolean) DataHolder.get().getDeviceData(UserDeviceAttribute.OPT_IN_INAPP);
                            deviceOptIn = deviceOptIn == null || deviceOptIn;
                            if (deviceOptIn && DataHolder.get().isAppForeground()) {
                                if (DataHolder.get().compareAndSetEntityRunningState(false, true)) {
                                    renderingAction = new InAppNotificationAction(this.applicationContext);
                                    renderingAction.performActionSync(getActionAttributes(topic, id));
                                }
                            }
                        }
                    }
                }

                break;

            case EVENT:
            case INTERNAL_EVENT:
                if (data instanceof EventPayload) {
                    EventPayload eventPayload = (EventPayload) data;
                    if (EventName.WE_WK_PUSH_NOTIFICATION_RERENDER.equals(eventPayload.getEventName()) || EventName.WE_WK_PROGRESS_BAR_PUSH_NOTIFICATION_RERENDER.equals(eventPayload.getEventName())) {
                        Action pushNotificationAction = new PushNotificationAction(this.applicationContext);
                        pushNotificationAction.performActionSync(getActionAttributes(topic, data));
                    } else if (EventName.WE_WK_ACTIVITY_START.equals(eventPayload.getEventName())) {
                        if (DataHolder.get().getData(WebEngageConstant.IN_APP_TESTING_DATA) != null) {
                            WeakReference<Activity> activityWeakReference = AnalyticsFactory.getAnalytics(applicationContext).getActivity();
                            if (activityWeakReference != null && activityWeakReference.get() != null
                                    && !activityWeakReference.get().isFinishing() && DataHolder.get().getData("entity_is_running") != null
                                    && ((AtomicBoolean) DataHolder.get().getData("entity_is_running")).get()) {
                                removeRenderDialogFragment(activityWeakReference.get().getFragmentManager());
                            }
                            if (activityWeakReference != null && activityWeakReference.get() != null
                                    && !activityWeakReference.get().isDestroyed()
                                    && DataHolder.get().compareAndSetEntityRunningState(false, true)) {
                                removeRenderDialogFragment(activityWeakReference.get().getFragmentManager());
                                invokeTestInApp((JSONObject) DataHolder.get().getData(WebEngageConstant.IN_APP_TESTING_DATA));
                                DataHolder.get().setData(WebEngageConstant.IN_APP_TESTING_DATA, null);
                            }
                        }
                    }
                }
                break;
        }
    }

    private void removeRenderDialogFragment(FragmentManager fragmentManager) {
        Fragment fragment = fragmentManager.findFragmentByTag(WebEngageConstant.TAG);
        if (fragment != null) {
            FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
            fragmentTransaction.remove(fragment).commitAllowingStateLoss();
        }
    }

    private void invokeTestInApp(JSONObject testingDetails) {
        try {
            String variationId = testingDetails.getString(WebEngageConstant.VARIATION_ID);
            String experimentId = testingDetails.getString(WebEngageConstant.EXPERIMENT_ENC_ID);
            String layoutId = testingDetails.getString(WebEngageConstant.LAYOUT_ID);
            List<Object> tokensList = new ArrayList<>();
            if (testingDetails.has(WebEngageConstant.TOKENS)) {
                JSONArray tokensArray = testingDetails.getJSONArray(WebEngageConstant.TOKENS);
                for (int i = 0; i < tokensArray.length(); i++) {
                    JSONArray innerArray = tokensArray.getJSONArray(i);
                    List<String> innerList = new ArrayList<>();
                    for (int j = 0; j < innerArray.length(); j++) {
                        innerList.add(innerArray.getString(j));
                    }
                    tokensList.add(innerList);
                }
            }
            InAppNotificationAction renderingAction = new InAppNotificationAction(applicationContext);
            HashMap<String, Object> data = new HashMap<>();
            data.put(WebEngageConstant.VARIATION_ID, variationId);
            data.put(WebEngageConstant.EXPERIMENT_ENC_ID, experimentId);
            data.put(WebEngageConstant.LAYOUT_ID, layoutId);
            data.put(WebEngageConstant.TOKENS, tokensList);
            renderingAction.performActionSync(getActionAttributes(Topic.RENDER, data));
        } catch (Exception e) {
            Logger.d(WebEngageConstant.TAG, "Exception while parsing testing campaign details");
        }
    }

    @Override
    public boolean validateData(Object data) {
        return false;
    }

    @Override
    public Map<String, Object> getActionAttributes(Topic topic, Object data) {
        Map<String, Object> actionAttribues = new HashMap<String, Object>();
        switch (topic) {
            case GCM_MESSAGE:
                actionAttribues.put(FIRST_TIME, true);
                actionAttribues.put(WebEngageConstant.CURRENT, 0);
                actionAttribues.put(WebEngageConstant.NAVIGATION, WebEngageConstant.RIGHT);
                actionAttribues.put(ACTION_DATA, data);
                break;
            case EVENT:
            case INTERNAL_EVENT:
                EventPayload eventPayload = (EventPayload) data;
                actionAttribues.put(FIRST_TIME, false);
                actionAttribues.put(ACTION_DATA, eventPayload);
                break;
            case RENDER:
                actionAttribues.put(ACTION_DATA, data);
                break;
        }

        return actionAttribues;
    }
}
