package com.webengage.sdk.android.actions.rules;

import android.content.Context;

import com.webengage.sdk.android.Action;
import com.webengage.sdk.android.BuildConfig;
import com.webengage.sdk.android.LocationManagerFactory;
import com.webengage.sdk.android.Logger;
import com.webengage.sdk.android.Topic;
import com.webengage.sdk.android.WebEngage;
import com.webengage.sdk.android.actions.database.DataContainer;
import com.webengage.sdk.android.actions.database.DataHolder;
import com.webengage.sdk.android.actions.database.UserProfileDataManager;
import com.webengage.sdk.android.utils.NetworkUtils;
import com.webengage.sdk.android.utils.WebEngageConstant;
import com.webengage.sdk.android.utils.http.CachePolicy;
import com.webengage.sdk.android.utils.http.HttpDataManager;
import com.webengage.sdk.android.utils.http.RequestMethod;
import com.webengage.sdk.android.utils.http.RequestObject;
import com.webengage.sdk.android.utils.http.WENetworkUtil;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ConfigurationAction extends Action {
    private Context applicationContext = null;
    private Topic topic = null;

    ConfigurationAction(Context context) {
        super(context);
        this.applicationContext = context.getApplicationContext();
    }

    @Override
    protected Object preExecute(Map<String, Object> actionAttributes) {
        String configUrl = (String) actionAttributes.get(ConfigurationController.CONGIF_URL);
        topic = (Topic) actionAttributes.get(ConfigurationController.TOPIC);
        int cachePolicy = CachePolicy.GET_VALIDATED_DATA_FROM_CACHE_FIRST_ELSE_DOWNLOAD_AND_CACHE;
        switch (topic) {
            case BOOT_UP:
                cachePolicy = CachePolicy.GET_DATA_FROM_CACHE_ONLY;
                break;
            case CONFIG_REFRESH:
                cachePolicy = CachePolicy.GET_VALIDATED_DATA_FROM_CACHE_FIRST_ELSE_DOWNLOAD_AND_CACHE;
                break;
        }
        if (BuildConfig.DEBUG) {
            Logger.d(WebEngageConstant.TAG, "Config url: " + configUrl);
        }
        Map<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/transit+json");
        RequestObject requestObject = new RequestObject.Builder(configUrl, RequestMethod.GET, this.applicationContext)
                .setCachePolicy(cachePolicy)
                .setHeaders(headers)
                .build();
        return requestObject;
    }

    @Override
    protected Object execute(Object data) {

        Map<String, Object> result = new HashMap<>();
        try {
            result = WENetworkUtil.makeRequest(applicationContext, (RequestObject) data, true, true);
        } catch (Exception e) {
            e.printStackTrace();
        }
        //Response response = (Response) data;
        int responseCode = (int) result.get("status");
        if (result.get("data") != null) {
            InputStream inputStream = (InputStream) result.get("data");
            switch (topic) {
                case BOOT_UP:
                    try {
                        ConfigurationManager configurationManager = new ConfigurationManager(NetworkUtils.getAsMap(inputStream, false));
                        configurationManager.initRuntime(RuleExecutorFactory.getRuleExecutor(), DataHolder.get());
                        Map<String, Object> geofences = DataHolder.get().getGeoFences();
                        addGeofences(geofences);
                        saveSessionDestroyTime(configurationManager.getSessionDestroyTime());
                        inputStream.close();
                    } catch (Exception e) {
                        dispatchExceptionTopic(e);
                    }
                    break;
                case CONFIG_REFRESH:
                    try {
                        if (responseCode == 200) {
                            DataHolder.get().silentSetData(WebEngageConstant.REFRESH_CONFIG_RULE, true);
                            Map<String, Object> oldGeoFences = DataHolder.get().getGeoFences();
                            ConfigurationManager configurationManager = new ConfigurationManager(NetworkUtils.getAsMap(inputStream, false));
                            Set<String> experimentIds = configurationManager.initRuntime(RuleExecutorFactory.getRuleExecutor(), DataHolder.get());
                            performCleanUp(configurationManager, experimentIds);
                            NetworkUtils.preFetchResourcesAsync(configurationManager.getGlobalResources(), this.applicationContext);
                            Map<String, Object> newGeoFences = DataHolder.get().getGeoFences();
                            manageGeoFences(oldGeoFences, newGeoFences);
                            saveSessionDestroyTime(configurationManager.getSessionDestroyTime());
                            inputStream.close();
                        }
                    } catch (Exception e) {
                        dispatchExceptionTopic(e);
                    }
                    break;
            }
            return inputStream;
        } else {
            Logger.e(WebEngageConstant.TAG, "ConfigurationAction result data is null");
            //response.closeErrorStream();
        }
        return null;
    }

    @Override
    protected void postExecute(Object data) {
        if (data != null) {
            InputStream inputStream = (InputStream) data;
            try {
                inputStream.close();
            } catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
    }

    private void performCleanUp(ConfigurationManager configurationManager, Set<String> experimentIds) {
        Set<String> totalResources = configurationManager.getAllResources();
        Set<String> cachedResources = HttpDataManager.getInstance(this.applicationContext).getAllCachedResources();
        cachedResources.removeAll(totalResources);
        HttpDataManager.getInstance(this.applicationContext).removeResourcesByURL(cachedResources);


        Set<String> fetchedIds = configurationManager.getEventCriteriaIds();
        Map<String, Set<String>> presentEventCriteria = UserProfileDataManager.getInstance(this.applicationContext).getAllEventCriteriaIdsAcrossUsers();
        if (presentEventCriteria != null) {
            for (Map.Entry<String, Set<String>> entry : presentEventCriteria.entrySet()) {
                String userId = entry.getKey();
                Set<String> presentIds = entry.getValue();
                presentIds.removeAll(fetchedIds);
                if (presentIds.size() > 0) {
                    Iterator<String> idsToRemove = presentIds.iterator();
                    while (idsToRemove.hasNext()) {
                        DataHolder.get().setOrUpdateEventCriteriaValue(userId, idsToRemove.next(), null);
                    }
                }
            }
        }

        Map<String, Set<String>> scopesAcrossUsers = UserProfileDataManager.getInstance(this.applicationContext).getAllScopesAcrossUser();
        if (scopesAcrossUsers != null) {
            for (Map.Entry<String, Set<String>> entry : scopesAcrossUsers.entrySet()) {
                String userId = entry.getKey();
                Set<String> scopes = entry.getValue();
                Set<String> presentIds = new HashSet<String>();
                Iterator<String> iterator = scopes.iterator();
                while (iterator.hasNext()) {
                    String scopeKey = iterator.next();
                    String expId = "";
                    int index = scopeKey.indexOf('[');
                    if (index == -1) {
                        index = scopeKey.indexOf('_');
                    }
                    if (index != -1) {
                        expId = scopeKey.substring(0, index);
                        presentIds.add(expId);
                    }
                }
                presentIds.removeAll(experimentIds);
                if (presentIds.size() > 0) {
                    Iterator<String> itr = presentIds.iterator();
                    while (itr.hasNext()) {
                        String idToRemove = itr.next();
                        Iterator<String> scopesIterator = scopes.iterator();
                        while (scopesIterator.hasNext()) {
                            String scope = scopesIterator.next();
                            if (scope.startsWith(idToRemove)) {
                                DataHolder.get().setOrUpdateUserProfile(userId, scope, null, DataContainer.SCOPES);
                            }
                        }
                    }
                }
            }
        }

        //remove static list ids from the User DB
        cleanUpStaticListIds(configurationManager);

    }

    private void cleanUpStaticListIds(ConfigurationManager configurationManager){
        List<String> fetchedStaticListIds = configurationManager.getListOfStaticIds();
        Map<String, Set<String>> presentStaticListIds = UserProfileDataManager.getInstance(this.applicationContext).getAllStaticListAcrossUser();
        if (presentStaticListIds != null) {
            for (Map.Entry<String, Set<String>> entry : presentStaticListIds.entrySet()) {
                String userId = entry.getKey();
                Set<String> presentIds = entry.getValue();
                //remove list of static list ids present in the config from the list fetched from DB
                presentIds.removeAll(fetchedStaticListIds);
                if (presentIds.size() > 0) {
                    Iterator<String> idsToRemove = presentIds.iterator();
                    while (idsToRemove.hasNext()) {
                        //remove the static list data for each user from the DB
                        DataHolder.get().setOrUpdateStaticLists(userId, idsToRemove.next(), null);
                    }
                }
            }
        }
    }


    private void manageGeoFences(Map<String, Object> oldGeoFences, Map<String, Object> newGeoFences) {
        addGeofences(newGeoFences);

        if (oldGeoFences != null) {
            List<String> ids = new ArrayList<>(oldGeoFences.keySet());
            if (newGeoFences != null) {
                ids.removeAll(newGeoFences.keySet());
            }
            if (!ids.isEmpty()) {
                LocationManagerFactory.getLocationManager(this.applicationContext).unregisterGeoFence(ids);
            }
        }
    }

    private void addGeofences(Map<String, Object> geoFences) {
        if (geoFences != null) {
            for (Map.Entry<String, Object> entry : geoFences.entrySet()) {
                Map<String, Object> value = (Map<String, Object>) entry.getValue();
                if (value != null) {
                    double latitude = (double) value.get("lat");
                    double longitude = (double) value.get("long");
                    float radius = Float.parseFloat(value.get("radius").toString());
                    LocationManagerFactory.getLocationManager(this.applicationContext).registerGeoFence(latitude, longitude, radius, entry.getKey(), WebEngage.get().getWebEngageConfig());
                }
            }
        }
    }

}
