package com.webengage.sdk.android.actions.rules;

import android.content.Context;
import android.text.TextUtils;

import com.webengage.sdk.android.Action;
import com.webengage.sdk.android.EventName;
import com.webengage.sdk.android.EventPayload;
import com.webengage.sdk.android.Logger;
import com.webengage.sdk.android.WELifecycleManager;
import com.webengage.sdk.android.actions.database.DataContainer;
import com.webengage.sdk.android.actions.database.DataHolder;
import com.webengage.sdk.android.actions.render.InLinePersonalizationAction;
import com.webengage.sdk.android.actions.rules.ruleEngine.Function;
import com.webengage.sdk.android.utils.NetworkUtils;
import com.webengage.sdk.android.utils.WECGManager;
import com.webengage.sdk.android.utils.WebEngageConstant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RuleExecutionAction extends Action {
    private Context applicationContext = null;
    private List<WebEngageConstant.RuleCategory> executionChain = null;
    String userIdentifier = null;

    protected RuleExecutionAction(Context context) {
        super(context);
        this.applicationContext = context.getApplicationContext();
    }

    @Override
    protected Object preExecute(Map<String, Object> actionAttributes) {
        return actionAttributes;
    }

    /**
     * Good job,congratulation!!!
     * If you think that reaching till here was like a gold mining, boy you
     * have no idea about what is going to come ahead.
     * So, get ready for some more actions and fasten your seat-belts because the ride
     * is going to get jerky.
     *
     * @param data
     * @return
     */
    @Override
    protected Object execute(Object data) {
//        Logger.d(WebEngageConstant.TAG, "on execute: " + RuleExecutorFactory.getRuleExecutor().getEvaluationIds());
        userIdentifier = getCUID().isEmpty() ? getLUID() : getCUID();
        List<String> evaluatedIds = null;
        Map<String, Object> actionAttributes = (Map<String, Object>) data;
        executionChain = (List<WebEngageConstant.RuleCategory>) actionAttributes.get(RuleExecutionController.RULE_EXECUTION_CHAIN);
        EventPayload eventPayload = (EventPayload) actionAttributes.get(RuleExecutionController.EVENT_STATE_DATA);
        boolean isThroughECL = false;
        if (eventPayload != null) {
            isThroughECL = checkForEventCriterias(eventPayload);
            if (isThroughECL) {
                if (executionChain.size() > 0) {
                    if (executionChain.get(0) != WebEngageConstant.RuleCategory.SESSION_RULE) {
                        executionChain.add(0, WebEngageConstant.RuleCategory.SESSION_RULE);
                    }
                    if (executionChain.size() > 1) {
                        if (executionChain.get(1) != WebEngageConstant.RuleCategory.PAGE_RULE) {
                            executionChain.add(1, WebEngageConstant.RuleCategory.PAGE_RULE);
                        }
                    } else {
                        executionChain.add(1, WebEngageConstant.RuleCategory.PAGE_RULE);
                    }
                } else {
                    executionChain.add(0, WebEngageConstant.RuleCategory.SESSION_RULE);
                    executionChain.add(1, WebEngageConstant.RuleCategory.PAGE_RULE);
                }
            }
        }
        for (WebEngageConstant.RuleCategory ruleCategory : executionChain) {
            if (ruleCategory.equals(WebEngageConstant.RuleCategory.PAGE_RULE)) {
                RuleExecutorFactory.getRuleExecutor().setCompetingIds(getSessionEvaluatedIds());
                Map<String, Map<String, String>> variationMap = getVariationMap();
                List<String> ids = RuleExecutorFactory.getRuleExecutor().evaluateRulesByCategory(WebEngageConstant.RuleCategory.PAGE_RULE);
                long minOrder = Long.MAX_VALUE;
                try {
                    evaluatedIds = new ArrayList<String>();
                    if (ids.size() > 0) {
                        ConfigurationManager configurationManager = new ConfigurationManager(this.applicationContext);
                        for (String id : ids) {
                            Map<String, Object> entityObj = null;
                            WebEngageConstant.Entity entity = null;
                            boolean isInline;
                            if (null != DataHolder.get().getInlineCampaignsData()
                                    && null != DataHolder.get().getInlineCampaignsData().get(id)) {
                                entityObj = configurationManager.getEntityObj(id, WebEngageConstant.Entity.INLINE_PERSONALIZATION);
                                entity = WebEngageConstant.Entity.INLINE_PERSONALIZATION;
                                isInline = true;
                            } else if (null != DataHolder.get().getInAppCampaignsData()
                                    && null != DataHolder.get().getInAppCampaignsData().get(id)) {
                                entityObj = configurationManager.getEntityObj(id, WebEngageConstant.Entity.NOTIFICATION);
                                entity = WebEngageConstant.Entity.NOTIFICATION;
                                isInline = false;
                            } else {
                                entityObj = configurationManager.getEntityObj(id, WebEngageConstant.Entity.SURVEY);
                                entity = WebEngageConstant.Entity.SURVEY;
                                isInline = false;
                            }
                            long order = entityObj.get("order") == null ? 0 : (long) entityObj.get("order");

                            if (isInline) {
                                Map<String, String> layoutIdMap = variationMap.get(id);
                                Map<String, Object> variationObj = null;
                                if (layoutIdMap != null) {
                                    variationObj = configurationManager.getEntityVariationObj(
                                            layoutIdMap.keySet().iterator().next(), entityObj);
                                }
                                 // This piece will only be executed after some event has occurred
                                 // and an ECL has been linked to the campaign.
                                 // The following typically occurs when the user is on the same
                                 // screen and a round of rule execution has already occurred on the
                                 // screen navigation. As a result, we will only update the existing
                                 // list for the addition or removal of any campaigns, and older
                                 // campaigns will be added without consider for their lifecycle
                                 // condition. This was done with the understanding that the product
                                 // only counts the view impression of the campaign
                                 // on the screen once.
                                if (isThroughECL && RuleExecutorFactory.getRuleExecutor()
                                        .getEvaluationIds().contains(id)) {
                                    evaluatedIds.add(id);
//                                    Logger.d(WebEngageConstant.TAG, "Flow is through ECL, adding the campaign without LC check");
                                } else {
                                    boolean result = WELifecycleManager.get().evaluateLifecycleChecks(
                                            entity, entityObj, variationObj);
                                    if (result) {
//                                        Logger.d(WebEngageConstant.TAG, "Rule eval adding to evaluation list: " + id);
                                        evaluatedIds.add(id);
                                    } else {
//                                        Logger.d(WebEngageConstant.TAG, "Rule eval failed to add to evaluation list: " + id);
                                    }
                                }
                            } else {
                                if (minOrder == Long.MAX_VALUE || order <= minOrder) {
                                    Map<String, String> layoutIdMap = variationMap.get(id);
                                    Map<String, Object> variationObj = null;
                                    if (layoutIdMap != null) {
                                        variationObj = configurationManager.getEntityVariationObj(layoutIdMap.keySet().iterator().next(), entityObj);
                                    }
                                    //variationObj will be null if sampling fall under control group
                                    boolean result = WELifecycleManager.get().evaluateLifecycleChecks(entity, entityObj, variationObj);
                                    if (result) {
                                        minOrder = Math.min(order, minOrder);
                                        //Logger.d(WebEngageConstant.TAG, "Rule eval adding to evaluation list: " + id);
                                        evaluatedIds.add(id);
                                    } else {
                                        // Logger.d(WebEngageConstant.TAG, "Rule eval failed to add to evaluation list: " + id);
                                    }
                                } else {
                                    //Logger.d(WebEngageConstant.TAG, "Rule eval order <= minOrder: order " + order + " min:" + minOrder + " exper: " + id);
                                }
                            }
                        }
                    }
                    RuleExecutorFactory.getRuleExecutor().setCompetingIds(evaluatedIds);
                } catch (Exception e) {

                }
            } else if (ruleCategory.equals(WebEngageConstant.RuleCategory.SESSION_RULE)) {
                try {
                    ConfigurationManager configurationManager = new ConfigurationManager(this.applicationContext);
                    RuleExecutorFactory.getRuleExecutor().reset();
                    evaluatedIds = RuleExecutorFactory.getRuleExecutor().evaluateRulesByCategory(WebEngageConstant.RuleCategory.SESSION_RULE);
                    Iterator<String> iterator = evaluatedIds.iterator();
                    Map<String, Map<String, String>> variationMap = new HashMap<String, Map<String, String>>();
                    Map<String, Map<String, String>> cgMap = new HashMap<>();
                    Set<String> layoutUrls = new HashSet<>();
                    while (iterator.hasNext()) {
                        String id = iterator.next();
                        Map<String, Object> entityObj = null;
                        if (null != DataHolder.get().getInlineCampaignsData() && null != DataHolder.get().getInlineCampaignsData().get(id)) {
                            entityObj = configurationManager.getEntityObj(id, WebEngageConstant.Entity.INLINE_PERSONALIZATION);
                        } else {
                            entityObj = configurationManager.getEntityObj(id, WebEngageConstant.Entity.NOTIFICATION);
                        }
                        Map<String, String> cgDetailsResult = WECGManager.get().selectVariation(id, userIdentifier,
                                entityObj, configurationManager.isApplyUCGToExistingCampaigns());

                        String variationId = cgDetailsResult.get("variationId");
                        if (variationId != null) {
                            Map<String, Object> variationObj = configurationManager.getEntityVariationObj(variationId, entityObj);
                            String layoutId = (String) variationObj.get("layout");
                            layoutUrls.add(configurationManager.getVariationLayoutUrl(layoutId));
                            Map<String, String> layoutIdMap = new HashMap<String, String>();
                            layoutIdMap.put(variationId, layoutId);
                            variationMap.put(id, layoutIdMap);
                        } else {
                            // sampled value falls in control group
                            cgMap.put(id, cgDetailsResult);
                        }
                    }
                    if (!layoutUrls.isEmpty() && eventPayload != null && EventName.VISITOR_NEW_SESSION.equals(eventPayload.getEventName())) {
                        NetworkUtils.preFetchResourcesAsync(layoutUrls, this.applicationContext);
                    }
                    RuleExecutorFactory.getRuleExecutor().setCompetingIds(evaluatedIds);
                    saveSessionEvaluatedIds(evaluatedIds);
                    saveVariationMap(variationMap);
                    saveControlGroupMap(cgMap);
                } catch (Exception e) {

                }
            } else if (ruleCategory.equals(WebEngageConstant.RuleCategory.EVENT_RULE)) {
                evaluatedIds = RuleExecutorFactory.getRuleExecutor().evaluateRulesByCategory(WebEngageConstant.RuleCategory.EVENT_RULE);
            }
        }
        RuleExecutorFactory.getRuleExecutor().setEvaluationIds(evaluatedIds);
        Logger.d(WebEngageConstant.TAG, "evaluated campaigns: " + evaluatedIds + " with chain: " + executionChain);
        return evaluatedIds;
    }

    @Override
    protected void postExecute(Object data) {
        List<String> evaluatedIds = (List<String>) data;
        List<String> inAppRenderingIds = null;
        if (evaluatedIds != null) {
            inAppRenderingIds = RuleExecutorFactory.getRuleExecutor().filterRenderingIds(evaluatedIds,
                    executionChain.get(executionChain.size() - 1));
        }
        inAppRenderingIds = segregateInlineAndInAppIds(inAppRenderingIds);
        dispatchRenderTopic(inAppRenderingIds);
    }

    /**
     * Inline campaigns are only evaluated either on page rule or event rule.
     * Page  rule: When screen is navigated only page rules are evaluated
     * Event rule: Any event based In-Line will be evaluated.
     *
     * @param renderingIds
     * @return
     */
    private List<String> segregateInlineAndInAppIds(List<String> renderingIds) {
        HashMap<String, List<Object>> qualifiedInlineCampaigns = new HashMap<>();
        List<String> inAppIds = new ArrayList<>();
        List<String> inLineIds = new ArrayList<>();
        for (String id : renderingIds) {
            if (null != DataHolder.get().getInlineCampaignsData()
                    && null != DataHolder.get().getInlineCampaignsData().get(id)) {
                HashMap<String, Object> entityObj = (HashMap<String, Object>) DataHolder.get().getInlineCampaignsData().get(id);
                String targetView = (String) entityObj.get("targetView");
                List<Object> qualifiedPerProperty = qualifiedInlineCampaigns.get(targetView);
                if (!TextUtils.isEmpty(targetView)) {
                    if (qualifiedPerProperty == null) {
                        qualifiedPerProperty = new ArrayList<>();
                    }
                    qualifiedPerProperty.add(entityObj);
                    qualifiedInlineCampaigns.put(targetView, qualifiedPerProperty);
                    inLineIds.add(id);
                }
            } else {
                inAppIds.add(id);
            }
        }
        Action renderingAction = new InLinePersonalizationAction(this.applicationContext);
        Map<String, Object> actionAttributes = new HashMap<String, Object>();
        Map<String, Object> actionValues = new HashMap<>();
        actionValues.put("ids", inLineIds);
        actionValues.put("qEntities", qualifiedInlineCampaigns);
        actionAttributes.put("action_data", actionValues);
        renderingAction.performActionSync(actionAttributes);
        DataHolder.get().setOlderQualifiedInlineCampaigns(inLineIds);
        return inAppIds;
    }


    /**
     * Don't waste your time !!!! it returns true or false based
     * on some probability distribution.
     *
     * @param eventPayload
     * @return
     */
    public boolean checkForEventCriterias(EventPayload eventPayload) {
        boolean flag = false;
        Object result = null;
        String eventName = eventPayload.getEventName();
        if (eventName != null) {
            String category = eventPayload.getCategory();
            if (WebEngageConstant.SYSTEM.equals(category) && !eventName.startsWith("we_")) {
                eventName = "we_" + eventName;
            }
            List<EventCriteria> eventCriteriaList = RuleExecutorFactory.getRuleExecutor().getEventCriteriasForEvent(eventName);
            if (eventCriteriaList != null) {
                for (EventCriteria eventCriteria : eventCriteriaList) {
                    result = eventCriteria.getExpression().evaluate();
                    if (result != null && (Boolean) result) {
                        List<Object> path = new ArrayList<Object>();
                        path.add(DataContainer.EVENT.toString());
                        path.add(eventName);
                        if (WebEngageConstant.SYSTEM.equals(eventCriteria.getAttributeCategory())) {
                            path.add("we_wk_sys");
                        }
                        path.add(eventCriteria.getAttribute());
                        Object newValue = DataHolder.get().getData(path);

                        List<Object> arguments = new ArrayList<Object>();
                        arguments.add(newValue);
                        arguments.add(DataHolder.get().getEventCriteria(eventCriteria.getId()));
                        Function function = RuleExecutorFactory.getRuleExecutor().getFunction(eventCriteria.getFunction());
                        result = function != null ? function.onEvaluation(arguments) : null;
                        if (result != null) {
                            flag = true;
                            DataHolder.get().setOrUpdateEventCriteriaValue(userIdentifier, eventCriteria.getId(), (Map<String, Object>) result);
                        }
                    }
                }
            }
        }
        return flag;
    }

}
