package com.webengage.sdk.android.utils;


import android.content.Context;

import com.webengage.sdk.android.utils.http.RequestObject;
import com.webengage.sdk.android.utils.http.WENetworkUtil;

import java.io.InputStream;
import java.util.Map;

public class AsyncRunner {

    public static void execute(Object object, Context context) {
        Runnable runnable = new WorkerThread(object, context);
        ThreadExecutor.get().execute(runnable);
    }

    private static class WorkerThread implements Runnable {
        private Object object;
        private Context context;

        private WorkerThread(Object object, Context context) {
            this.object = object;
            this.context = context;
        }

        @Override
        public void run() {
            try {
                if (object instanceof Runnable) {
                    ((Runnable) object).run();
                } else if (object instanceof RequestObject) {
                    RequestObject requestObject = (RequestObject) object;
                    Map<String, Object> result = WENetworkUtil.makeRequest(context, requestObject, true, true);
                    InputStream responseStream = (InputStream) result.get("data");
                    if (responseStream != null) {
                        responseStream.close();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}
