package com.webengage.sdk.android.utils;

import android.text.TextUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WECGManager {
    public static WECGManager INSTANCE = null;
    private HashMap<String, Object> UNIVERSAL_CG = new HashMap<>();
    private HashMap<String, Object> CUSTOM_CG = new HashMap<>();
    double samplingOccupied = 0.0;
    double userHash = 0.0;

    //this variable is used to keep a track of whether any cg has been already applied.
    private boolean controlGroupFlag = false;

    HashMap<String, String> result = new HashMap<>();

    public static synchronized WECGManager get() {
        synchronized (WECGManager.class) {
            if (INSTANCE == null) {
                INSTANCE = new WECGManager();
            }
        }
        return INSTANCE;
    }

    private WECGManager() {
    }

    public void setUNIVERSAL_CG(HashMap<String, Object> UNIVERSAL_CG) {
        this.UNIVERSAL_CG = UNIVERSAL_CG;
    }

    public void setCUSTOM_CG(HashMap<String, Object> CUSTOM_CG) {
        this.CUSTOM_CG = CUSTOM_CG;
    }

    public HashMap<String, String> selectVariation(String experimentId,
                                                   String userId, Map<String, Object> entityObj,
                                                   boolean applyUCGToExistingCampaigns) {
        controlGroupFlag = false;
        samplingOccupied = 0.0;
        result = new HashMap<>();
        //Universal Control Group
        userHash = Double.parseDouble(String.valueOf(Math.abs((userId).hashCode()) % 100));
       // userHash = 31.0;
        if ((!entityObj.containsKey("excludeUCG") && applyUCGToExistingCampaigns) || (entityObj.containsKey("excludeUCG") && entityObj.get("excludeUCG") instanceof Boolean &&
                !(boolean) entityObj.get("excludeUCG"))) {
            checkForUniversalCG();
        }
        //Check for custom CG if customCG id is present in entityOBj
        if(!controlGroupFlag) {
            if (entityObj.containsKey(WebEngageConstant.UniversalCGKeys.CG_ID)
                    && null != CUSTOM_CG.get((String) entityObj.get(WebEngageConstant.UniversalCGKeys.CG_ID))) {
                String cgId = (String) entityObj.get(WebEngageConstant.UniversalCGKeys.CG_ID);
                checkForCustomCG(cgId);
            } else {
                checkForCampaignCG(experimentId, userId, entityObj);
            }
        }
        //Select variation if control group not applied
        if (!controlGroupFlag) {
            getVariation(experimentId, userId, entityObj);
        }

        //Logger.d(WebEngageConstant.TAG, "Control-group getVariation: " + result.toString() + " experiment id: " + experimentId);
        return result;
    }

    private void checkForUniversalCG() {
        String uCGId = "";
        String rangeSelected = "";
        String name = "";
        for (String key : UNIVERSAL_CG.keySet()) {
            if (null != UNIVERSAL_CG.get(key)) {
                HashMap<String, String> cgDetail = (HashMap<String, String>) UNIVERSAL_CG.get(key);
                List<List<Integer>> ranges = getRangeFromString(cgDetail.get("range"));
                name = cgDetail.get("name");
                if (TextUtils.isEmpty(name)) {
                    name = "UNIVERSAL";
                }
                for (List<Integer> range : ranges) {
                    samplingOccupied += range.get(1) - range.get(0) + 1;
                    if (userHash >= range.get(0) && userHash < range.get(1)) {
                        uCGId = key;
                        rangeSelected = range.toString();
                    }
                }
            }
        }
        if (!TextUtils.isEmpty(uCGId)) {
            result.put("attribution_type", name);
            result.put("cg_id", uCGId);
            result.put("cg_range", rangeSelected);
            result.put("bucket_value", userHash + "");
            result.put("size", samplingOccupied + "");
            controlGroupFlag = true;
        }

    }

    private void checkForCustomCG(String cgId) {
        boolean isCGApplied = false;
        String rangeSelected = "";
        if (null != CUSTOM_CG.get(cgId)) {
            HashMap<String, String> cgDetail = (HashMap<String, String>) CUSTOM_CG.get(cgId);
            List<List<Integer>> ranges = getRangeFromString(cgDetail.get("range"));
            String name = cgDetail.get("name");
            for (List<Integer> range : ranges) {
                samplingOccupied += range.get(1) - range.get(0) + 1;
                if (userHash >= range.get(0) && userHash < range.get(1)) {
                    isCGApplied = true;
                    rangeSelected = range.toString();
                }
            }
            if (isCGApplied) {
                result.put("attribution_type", name);
                result.put("cg_id", cgId);
                result.put("bucket_value", userHash + "");
                result.put("cg_range", rangeSelected);
                result.put("size", samplingOccupied + "");
                controlGroupFlag = true;
            }
        }
    }

    private void checkForCampaignCG(String experimentId, String userId, Map<String, Object> entityObj) {
        if (entityObj != null) {
            String entityId = experimentId;
            if (entityObj.get("journeyId") != null) {
                entityId = (String) entityObj.get("journeyId");
            }
            double reCalculatedUserHash = WebEngageUtils.getSampledValue(entityId, userId);
            //Logger.d(WebEngageConstant.TAG, "Control-group recalculated HASH: " + reCalculatedUserHash);
            if (entityObj.containsKey("controlGroup")) {
                long campaignControlGroupSize = (long) (entityObj.get("controlGroup"));
                if (campaignControlGroupSize > 0 && reCalculatedUserHash > (100 - campaignControlGroupSize)) {
                    result.put("bucket_value", reCalculatedUserHash + "");
                    result.put("size", campaignControlGroupSize + "");
                    controlGroupFlag = true;
                }
            }
        }
    }

    private void getVariation(String experimentId, String userID, Map<String, Object> entityObj) {
        if (entityObj != null) {
            String entityId = experimentId;
            if (entityObj.get("journeyId") != null) {
                entityId = (String) entityObj.get("journeyId");
            }
            double reCalculatedUserHash = WebEngageUtils.getSampledValue(entityId, userID);
            List<Object> variations = (List<Object>) entityObj.get("variations");
            //Logger.d(WebEngageConstant.TAG, "Control-group getVariation userHashToCompare: " + reCalculatedUserHash + " experiment id: " + experimentId);
            double lowerBound = 0.0;
            if (variations != null) {
                for (int i = 0; i < variations.size(); i++) {
                    Map<String, Object> variation = (Map<String, Object>) variations.get(i);
                    if (variation != null) {
                        double variationSampledValue = variation.get("sampling") == null ? 100.0 : (double)(variation.get("sampling"));
                        if (reCalculatedUserHash >= lowerBound && reCalculatedUserHash < (lowerBound + variationSampledValue)) {
                            result.put("variationId", (String) variation.get("id"));
                            break;
                        }
                        lowerBound += variationSampledValue;
                    }
                }
            }
        }
    }

    private List<List<Integer>> getRangeFromString(String range) {
        List<List<Integer>> rangeList = new ArrayList<>();
        if (null != range && !range.isEmpty()) {
            String[] outerSplit = range.replace(",[", ";").replace("[", "").replace("]", "").split(";");
            for (String s : outerSplit) {
                String[] innerRange = s.split(",");
                ArrayList<Integer> _iR = new ArrayList<>();
                _iR.add(Integer.parseInt(innerRange[0]));
                _iR.add(Integer.parseInt(innerRange[1]));
                rangeList.add(_iR);
            }
        }
        return rangeList;
    }

}
