package com.webengage.sdk.android.utils.gifUtils;

import android.content.Context;
import android.graphics.Bitmap;
import android.widget.RemoteViews;

import com.webengage.sdk.android.R;
import com.webengage.sdk.android.actions.exception.ImageLoadException;
import com.webengage.sdk.android.actions.render.NotificationConfigurator;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WEGifHelper {

    WEGifDecoder decoder = null;

    public WEGifDecoder getDecoder() {
        return decoder;
    }

    public ArrayList<Bitmap> decodeGif(InputStream stream) {
        byte[] byteArray = readNBytes(stream, Integer.MAX_VALUE);
        ArrayList<Bitmap> bitmapList = new ArrayList<>();

        if (byteArray.length == 0) {
            return bitmapList;
        }

        decoder = WEGifDecoder.decode(byteArray);
        for (int i = 0; i < decoder.frameCount; i++) {
            bitmapList.add(decoder.getFrame(i));
        }
        return bitmapList;
    }

    public void constructViewFlipper(RemoteViews remoteView, List<Bitmap> validImages, Context context, int viewFlipperId) {

        int totalDuration = 0;
        int frameDelay;
        WEGifDecoder decoder = getDecoder(); // accessing same instance for delay
        NotificationConfigurator notificationConfigurator = new NotificationConfigurator();
        for (int i = 0; i < validImages.size(); i++) {
            Bitmap gifImage = validImages.get(i);
            RemoteViews gifItemView = new RemoteViews(context.getPackageName(), R.layout.gif_item);
            frameDelay = decoder.getDelay(i);
            totalDuration += frameDelay;
            notificationConfigurator.setBitmapToRemoteView(gifImage, gifItemView, R.id.gif_image);
            remoteView.addView(viewFlipperId, gifItemView);
        }

        int numberOfFrames = validImages.size();
        int interval = totalDuration / numberOfFrames;
        remoteView.setInt(viewFlipperId, "setFlipInterval", interval);
    }

    //for converting input stream to byte array
    public byte[] readNBytes(InputStream inputStream, int len) {
        try {
            int MAX_BUFFER_SIZE = Integer.MAX_VALUE - 8;
            int DEFAULT_BUFFER_SIZE = 8192;
            if (len < 0) {
                throw new ImageLoadException("len < 0");
            }

            List<byte[]> bufs = null;
            byte[] result = null;
            int total = 0;
            int remaining = len;
            int n;
            do {
                byte[] buf = new byte[Math.min(remaining, DEFAULT_BUFFER_SIZE)];
                int nread = 0;

                // read to EOF which may read more or less than buffer size
                while ((n = inputStream.read(buf, nread,
                        Math.min(buf.length - nread, remaining))) > 0) {
                    nread += n;
                    remaining -= n;
                }

                if (nread > 0) {
                    if (MAX_BUFFER_SIZE - total < nread) {
                        throw new ImageLoadException("Out of memory");
                    }
                    if (nread < buf.length) {
                        buf = Arrays.copyOfRange(buf, 0, nread);
                    }
                    total += nread;
                    if (result == null) {
                        result = buf;
                    } else {
                        if (bufs == null) {
                            bufs = new ArrayList<>();
                            bufs.add(result);
                        }
                        bufs.add(buf);
                    }
                }
                // if the last call to read returned -1 or the number of bytes
                // requested have been read then break
            } while (n >= 0 && remaining > 0);

            if (bufs == null) {
                if (result == null) {
                    throw new ImageLoadException("No byte to read");
                }
                return result.length == total ?
                        result : Arrays.copyOf(result, total);
            }

            result = new byte[total];
            int offset = 0;
            remaining = total;
            for (byte[] b : bufs) {
                int count = Math.min(b.length, remaining);
                System.arraycopy(b, 0, result, offset, count);
                offset += count;
                remaining -= count;
            }
            return result;

        } catch (Exception e) {
            return new byte[0];
        }

    }
}