package com.webengage.sdk.android.utils.htmlspanner.style;

import com.webengage.sdk.android.utils.htmlspanner.FontFamily;

/**
 * CSS Style object.
 *
 * A Style is immutable: using a setter creates a new Style object with the
 * changed setings.
 */
public class Style {

    public enum TextAlignment { LEFT, CENTER, RIGHT }
    public enum FontWeight {  NORMAL, BOLD }
    public enum FontStyle { NORMAL, ITALIC }
    public enum DisplayStyle { BLOCK, INLINE }
    public enum BorderStyle { SOLID, DASHED, DOTTED, DOUBLE }
    public enum TextDecoration {UNDERLINE, LINETHROUGH}

    private final FontFamily fontFamily;
    private final TextAlignment textAlignment;
    private final StyleValue fontSize;

    private final FontWeight fontWeight;
    private final FontStyle fontStyle;

    private final Integer color;
    private final Integer backgroundColor;
    private final Integer borderColor;

    private final DisplayStyle displayStyle;
    private final BorderStyle borderStyle;
    private final StyleValue borderWidth;

    private final StyleValue textIndent;

    private final StyleValue marginTop;
    private final StyleValue marginBottom;
    private final StyleValue marginLeft;
    private final StyleValue marginRight;
    private final StyleValue lineHeight;
    //text decoration
    private final TextDecoration textDecoration;


    public Style() {
        fontFamily = null;
        textAlignment = null;
        fontSize = null;
        fontWeight = null;
        fontStyle = null;
        color = null;
        backgroundColor = null;
        displayStyle = null;
        marginBottom = null;
        textIndent = null;
        marginTop = null;
        marginLeft = null;
        marginRight = null;

        borderColor = null;
        borderStyle = null;
        borderWidth = null;
        lineHeight=null;
        textDecoration=null;
    }

    public Style(FontFamily family, TextAlignment textAlignment, StyleValue fontSize,
                 FontWeight fontWeight, FontStyle fontStyle, Integer color,
                 Integer backgroundColor, DisplayStyle displayStyle, StyleValue marginTop,
                 StyleValue marginBottom, StyleValue marginLeft, StyleValue marginRight,
                 StyleValue textIndent, Integer borderColor, BorderStyle borderStyle,
                 StyleValue borderWidth,StyleValue lineHeight,TextDecoration textDecoration) {
        this.fontFamily = family;
        this.textAlignment = textAlignment;
        this.fontSize = fontSize;

        this.fontWeight = fontWeight;
        this.fontStyle = fontStyle;
        this.color = color;
        this.backgroundColor = backgroundColor;
        this.displayStyle = displayStyle;
        this.marginBottom = marginBottom;
        this.textIndent = textIndent;
        this.marginTop = marginTop;
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;

        this.borderColor = borderColor;
        this.borderWidth = borderWidth;
        this.borderStyle = borderStyle;
        this.lineHeight=lineHeight;
        this.textDecoration=textDecoration;
    }

    public Style setFontFamily(FontFamily fontFamily) {
        return new Style(fontFamily, this.textAlignment, this.fontSize,
                this.fontWeight, this.fontStyle, this.color, this.backgroundColor, this.displayStyle,
                this.marginTop, this.marginBottom, this.marginLeft, this.marginRight, this.textIndent,
                this.borderColor, this.borderStyle, this.borderWidth,this.lineHeight,this.textDecoration );
    }

    public Style setLineHeight(StyleValue lineHeight) {
        return new Style(this.fontFamily, this.textAlignment, this.fontSize, this.fontWeight,
                this.fontStyle, this.color, this.backgroundColor, this.displayStyle,
                this.marginTop, this.marginBottom, this.marginLeft, this.marginRight, this.textIndent,
                this.borderColor, this.borderStyle, this.borderWidth,lineHeight,this.textDecoration);
    }


    public Style setTextAlignment(TextAlignment alignment) {
        return new Style(this.fontFamily, alignment, this.fontSize, this.fontWeight,
                this.fontStyle, this.color, this.backgroundColor, this.displayStyle,
                this.marginTop, this.marginBottom, this.marginLeft, this.marginRight, this.textIndent,
                this.borderColor, this.borderStyle, this.borderWidth,this.lineHeight,this.textDecoration );
    }

    public Style setFontSize(StyleValue fontSize) {
        return new Style(this.fontFamily, this.textAlignment, fontSize, this.fontWeight,
                this.fontStyle, this.color, this.backgroundColor, this.displayStyle,
                this.marginTop, this.marginBottom, this.marginLeft, this.marginRight, this.textIndent,
                this.borderColor, this.borderStyle, this.borderWidth,this.lineHeight,this.textDecoration );
    }

    public Style setFontWeight(FontWeight fontWeight) {
        return new Style(fontFamily, this.textAlignment, this.fontSize, fontWeight,
                this.fontStyle, this.color, this.backgroundColor, this.displayStyle,
                this.marginTop, this.marginBottom, this.marginLeft, this.marginRight, this.textIndent,
                this.borderColor, this.borderStyle, this.borderWidth,this.lineHeight,this.textDecoration );
    }

    public Style setFontStyle(FontStyle fontStyle) {
        return new Style(fontFamily, this.textAlignment, this.fontSize,
                this.fontWeight, fontStyle, this.color, this.backgroundColor,
                this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight,
                this.textIndent, this.borderColor, this.borderStyle, this.borderWidth,this.lineHeight,this.textDecoration );
    }

    public Style setColor(Integer color) {
        return new Style(fontFamily, this.textAlignment, this.fontSize,
                this.fontWeight, fontStyle, color, this.backgroundColor,
                this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight,
                this.textIndent, this.borderColor, this.borderStyle, this.borderWidth,this.lineHeight,this.textDecoration );
    }

    public Style setBackgroundColor( Integer bgColor ) {
        return new Style(fontFamily, this.textAlignment, this.fontSize,
                this.fontWeight, fontStyle, this.color, bgColor,
                this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight,
                this.textIndent, this.borderColor, this.borderStyle, this.borderWidth,this.lineHeight,this.textDecoration );
    }

    public Style setDisplayStyle( DisplayStyle displayStyle ) {
        return new Style(fontFamily, this.textAlignment, this.fontSize,
                this.fontWeight, fontStyle, this.color, this.backgroundColor,
                displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight,
                this.textIndent, this.borderColor, this.borderStyle, this.borderWidth,this.lineHeight,this.textDecoration );
    }

    public Style setMarginBottom( StyleValue marginBottom ) {
        return new Style(fontFamily, this.textAlignment, this.fontSize,
                this.fontWeight, fontStyle, this.color, this.backgroundColor,
                this.displayStyle, this.marginTop, marginBottom, this.marginLeft,
                this.marginRight,this.textIndent, this.borderColor, this.borderStyle, this.borderWidth,this.lineHeight,this.textDecoration );
    }

    public Style setMarginTop( StyleValue marginTop ) {
        return new Style(fontFamily, this.textAlignment, this.fontSize,
                this.fontWeight, fontStyle, this.color, this.backgroundColor,
                this.displayStyle, marginTop, this.marginBottom, this.marginLeft,
                this.marginRight,this.textIndent, this.borderColor, this.borderStyle, this.borderWidth,this.lineHeight,this.textDecoration );
    }

    public Style setMarginLeft( StyleValue marginLeft ) {
        return new Style(fontFamily, this.textAlignment, this.fontSize,
                this.fontWeight, fontStyle, this.color, this.backgroundColor,
                this.displayStyle, this.marginTop, this.marginBottom, marginLeft,
                this.marginRight,this.textIndent, this.borderColor, this.borderStyle, this.borderWidth,this.lineHeight,this.textDecoration );
    }

    public Style setMarginRight( StyleValue marginRight ) {
        return new Style(fontFamily, this.textAlignment, this.fontSize,
                this.fontWeight, fontStyle, this.color, this.backgroundColor,
                this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft,
                marginRight,this.textIndent, this.borderColor, this.borderStyle, this.borderWidth,this.lineHeight,this.textDecoration );
    }

    public Style setTextIndent( StyleValue textIndent ) {
        return new Style(fontFamily, this.textAlignment, this.fontSize,
                this.fontWeight, fontStyle, this.color, this.backgroundColor,
                this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight,
                textIndent, this.borderColor, this.borderStyle, this.borderWidth,this.lineHeight,this.textDecoration );
    }

    public Style setBorderStyle( BorderStyle borderStyle ) {
        return new Style(fontFamily, this.textAlignment, this.fontSize,
                this.fontWeight, fontStyle, this.color, this.backgroundColor,
                this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight,
                textIndent, this.borderColor, borderStyle, this.borderWidth,this.lineHeight,this.textDecoration );
    }

    public Style setBorderColor( Integer borderColor ) {
        return new Style(fontFamily, this.textAlignment, this.fontSize,
                this.fontWeight, fontStyle, this.color, this.backgroundColor,
                this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight,
                textIndent, borderColor, borderStyle, this.borderWidth,this.lineHeight,this.textDecoration );
    }

    public Style setBorderWidth( StyleValue borderWidth ) {
        return new Style(fontFamily, this.textAlignment, this.fontSize,
                this.fontWeight, fontStyle, this.color, this.backgroundColor,
                this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight,
                textIndent, this.borderColor, this.borderStyle, borderWidth,this.lineHeight,this.textDecoration );
    }

    public Style setTextDecoration(TextDecoration textDecoration) {
        return new Style(fontFamily, this.textAlignment, this.fontSize,
                this.fontWeight, fontStyle, this.color, this.backgroundColor,
                this.displayStyle, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight,
                textIndent, this.borderColor, this.borderStyle, borderWidth,this.lineHeight,textDecoration );
    }

    public Integer getBackgroundColor() {
        return this.backgroundColor;
    }

    public FontFamily getFontFamily() {
        return this.fontFamily;
    }

    public TextAlignment getTextAlignment() {
        return textAlignment;
    }

    public StyleValue getFontSize() {
        return this.fontSize;
    }

    public FontWeight getFontWeight() {
        return fontWeight;
    }

    public FontStyle getFontStyle() {
        return fontStyle;
    }

    public Integer getColor() {
        return this.color;
    }

    public DisplayStyle getDisplayStyle() {
        return this.displayStyle;
    }

    public StyleValue getMarginBottom() {
        return this.marginBottom;
    }

    public StyleValue getMarginTop() {
        return this.marginTop;
    }

    public StyleValue getMarginLeft() {
        return this.marginLeft;
    }

    public StyleValue getMarginRight() {
        return this.marginRight;
    }

    public StyleValue getTextIndent() {
        return this.textIndent;
    }

    public Integer getBorderColor() {
        return this.borderColor;
    }

    public BorderStyle getBorderStyle() {
        return this.borderStyle;
    }

    public StyleValue getBorderWidth() {
        return this.borderWidth;
    }

    public StyleValue getLineHeight() {return this.lineHeight;}

    public TextDecoration getTextDecoration() {
        return textDecoration;
    }

    public String toString() {

        StringBuilder result = new StringBuilder( "{\n" );

        if ( fontFamily != null  ) {
            result.append("  font-family: ").append(fontFamily.getName()).append("\n");
        }

        if ( textAlignment != null ) {
            result.append("  text-alignment: ").append(textAlignment).append("\n");
        }

        if ( fontSize != null ) {
            result.append("  font-size: ").append(fontSize).append("\n");
        }

        if ( fontWeight != null ) {
            result.append("  font-weight: ").append(fontWeight).append("\n");
        }

        if ( fontStyle != null ) {
            result.append( "  font-style: " + fontStyle + "\n" );
        }

        if ( color != null ) {
            result.append("  color: " + color + "\n");
        }

        if ( backgroundColor != null ) {
            result.append("  background-color: " + backgroundColor + "\n");
        }

        if ( displayStyle != null ) {
            result.append("  display: " + displayStyle + "\n");
        }

        if ( marginTop != null ) {
            result.append("  margin-top: " + marginTop + "\n" );
        }

        if ( marginBottom != null ) {
            result.append("  margin-bottom: " + marginBottom + "\n" );
        }

        if ( marginLeft != null ) {
            result.append("  margin-left: " + marginLeft + "\n" );
        }

        if ( marginRight != null ) {
            result.append("  margin-right: " + marginRight + "\n" );
        }

        if ( textIndent != null ) {
            result.append("  text-indent: " + textIndent + "\n" );
        }

        if ( borderStyle != null ) {
            result.append("  border-style: " + borderStyle + "\n" );
        }

        if ( borderColor != null ) {
            result.append("  border-color: " + borderColor + "\n" );
        }

        if ( borderWidth != null ) {
            result.append("  border-style: " + borderWidth + "\n" );
        }

        result.append("}\n");

        return result.toString();
    }

}
