/*
 * Decompiled with CFR 0.152.
 */
package com.webengage.sdk.android.actions.render;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import androidx.core.content.ContextCompat;
import com.webengage.sdk.android.Logger;
import com.webengage.sdk.android.R;
import com.webengage.sdk.android.WebEngage;
import com.webengage.sdk.android.actions.render.CallToAction;
import com.webengage.sdk.android.actions.render.CarouselV1CallToAction;
import com.webengage.sdk.android.actions.render.a;
import com.webengage.sdk.android.utils.WebEngageConstant;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class PushNotificationData
extends a {
    private JSONObject bigNotificationData;
    private JSONObject testingDetails;
    private BigPictureStyle bigPictureStyle;
    private BigTextStyle bigTextStyle;
    private InboxStyle inboxStyle;
    private CarouselV1 carouselV1;
    private RatingV1 ratingV1;
    private OverlayStyle overlayStyle;
    private TimerStyle timerStyle;
    private String style;
    private Bitmap largeIcon;
    private int smallIcon;
    private String appName;
    private boolean autoExpand;
    private List<CallToAction> callToActions;
    private int accentColor;
    private JSONObject cta;
    private int currentIndex;
    private boolean isSticky;
    private int backgroundColor;
    private String largeIconUrl;
    private String autoDismissTime;

    /*
     * WARNING - void declaration
     */
    public PushNotificationData(JSONObject json, Context context) {
        void var2_3;
        Object object;
        block26: {
            super((JSONObject)object, "system_tray", (Context)var2_3);
            this.bigNotificationData = null;
            this.testingDetails = null;
            this.bigPictureStyle = null;
            this.bigTextStyle = null;
            this.inboxStyle = null;
            this.carouselV1 = null;
            this.ratingV1 = null;
            this.overlayStyle = null;
            this.timerStyle = null;
            this.style = null;
            this.largeIcon = null;
            this.smallIcon = -1;
            this.appName = null;
            this.autoExpand = true;
            this.accentColor = -1;
            this.currentIndex = 0;
            this.isSticky = false;
            this.backgroundColor = Color.parseColor((String)"#00000000");
            this.largeIconUrl = null;
            this.autoDismissTime = null;
            Object object2 = json.isNull("expandableDetails") ? null : object.optJSONObject("expandableDetails");
            this.bigNotificationData = object2;
            object2 = object.isNull("testing_details") ? null : object.optJSONObject("testing_details");
            this.testingDetails = object2;
            this.callToActions = this.readCallToActions((JSONObject)object, (Context)var2_3);
            this.accentColor = WebEngage.get().getWebEngageConfig().getAccentColor();
            this.smallIcon = WebEngage.get().getWebEngageConfig().getPushSmallIcon();
            if (this.smallIcon == -1) {
                this.smallIcon = var2_3.getApplicationContext().getApplicationInfo().icon;
            }
            if ((object2 = this.bigNotificationData) != null && !object2.isNull("l_ic")) {
                this.largeIconUrl = this.bigNotificationData.getString("l_ic");
            }
            if (TextUtils.isEmpty((CharSequence)this.largeIconUrl)) {
                this.createLargeIconFromAsset((Context)var2_3);
            }
            if (this.appName == null) {
                try {
                    this.appName = var2_3.getApplicationInfo().loadLabel(var2_3.getPackageManager()).toString();
                }
                catch (Exception exception) {
                    Logger.e("WebEngage", exception.toString() + " loading app name");
                }
            }
            this.isSticky = object.optBoolean("s", false);
            if (!object.isNull("bckColor")) {
                if (TextUtils.isEmpty((CharSequence)object.getString("bckColor"))) break block26;
                try {
                    this.backgroundColor = Color.parseColor((String)object.getString("bckColor"));
                    Logger.d("WebEngage", "BackGround color : " + this.backgroundColor);
                }
                catch (Exception exception) {
                    Logger.e("WebEngage", "Exception while parsing bckColor " + exception.toString());
                    this.backgroundColor = Color.parseColor((String)"#00000000");
                }
            }
        }
        if ((object = this.bigNotificationData) != null && !object.isNull("adms")) {
            this.autoDismissTime = this.bigNotificationData.getString("adms");
        }
        if ((object = this.bigNotificationData) != null && !object.isNull("style")) {
            object = this.bigNotificationData.optString("style");
            this.style = object;
            if ("BIG_TEXT".equalsIgnoreCase((String)object)) {
                BigTextStyle bigTextStyle;
                object = bigTextStyle;
                bigTextStyle = new BigTextStyle(this, this.bigNotificationData);
                this.bigTextStyle = object;
            } else if ("BIG_PICTURE".equalsIgnoreCase(this.style)) {
                BigPictureStyle bigPictureStyle;
                object = bigPictureStyle;
                bigPictureStyle = new BigPictureStyle(this, this.bigNotificationData);
                this.bigPictureStyle = object;
            } else if ("INBOX".equalsIgnoreCase(this.style)) {
                InboxStyle inboxStyle;
                object = inboxStyle;
                inboxStyle = new InboxStyle(this, this.bigNotificationData);
                this.inboxStyle = object;
            } else if ("CAROUSEL_V1".equalsIgnoreCase(this.style)) {
                CarouselV1 carouselV1;
                object = carouselV1;
                PushNotificationData pushNotificationData = this;
                this.carouselV1 = new CarouselV1(pushNotificationData, pushNotificationData.bigNotificationData);
                this.callToActions.addAll(((CarouselV1)object).getCallToActions());
            } else if ("RATING_V1".equalsIgnoreCase(this.style)) {
                RatingV1 ratingV1;
                object = ratingV1;
                PushNotificationData pushNotificationData = this;
                this.ratingV1 = new RatingV1(pushNotificationData, pushNotificationData.bigNotificationData);
                if (((RatingV1)object).getSubmitCTA() != null) {
                    this.callToActions.add(this.ratingV1.getSubmitCTA());
                }
            } else if (!("TIMER".equalsIgnoreCase(this.style) || "PROGRESS_BAR".equalsIgnoreCase(this.style) || "BIG_TIMER".equalsIgnoreCase(this.style))) {
                if ("OVERLAY".equalsIgnoreCase(this.style)) {
                    OverlayStyle overlayStyle;
                    object = overlayStyle;
                    overlayStyle = new OverlayStyle(this, this.bigNotificationData);
                    this.overlayStyle = object;
                }
            } else {
                TimerStyle timerStyle;
                object = timerStyle;
                timerStyle = new TimerStyle(this, this.bigNotificationData, (Context)var2_3);
                this.timerStyle = object;
            }
        }
    }

    private List<CallToAction> readCallToActions(JSONObject jsonObject, Context context) {
        Object object;
        ArrayList<CallToAction> arrayList;
        Object object2;
        JSONObject jSONObject = jsonObject.isNull("expandableDetails") ? null : object2.optJSONObject("expandableDetails");
        ArrayList<CallToAction> arrayList2 = arrayList;
        arrayList = new ArrayList<CallToAction>();
        object2 = object2.isNull("cta") ? null : object2.optJSONObject("cta");
        ((PushNotificationData)object3).cta = object2;
        if (object2 != null) {
            if (!object2.isNull("id")) {
                if (((PushNotificationData)object3).cta.optJSONObject("ca") != null) {
                    CallToAction callToAction;
                    object2 = callToAction;
                    PushNotificationData pushNotificationData = object3;
                    object = pushNotificationData.cta;
                    callToAction = new CallToAction((JSONObject)object, pushNotificationData.getContentText(), true, true);
                    arrayList2.add((CallToAction)object2);
                } else {
                    PushNotificationData pushNotificationData = object3;
                    object2 = pushNotificationData.cta.optString("id");
                    object = pushNotificationData.getContentText();
                    arrayList2.add(new CallToAction((String)object2, (String)object, ((PushNotificationData)object3).cta.optString("actionLink"), true, true));
                }
            }
        } else {
            CallToAction callToAction;
            object2 = callToAction;
            callToAction = new CallToAction(null, ((PushNotificationData)object3).getContentText(), null, true, true);
            arrayList2.add((CallToAction)object2);
        }
        if (jSONObject != null) {
            object2 = jSONObject.isNull("cta1") ? null : jSONObject.optJSONObject("cta1");
            ((PushNotificationData)object3).cta = object2;
            if (object2 != null) {
                if (!object2.isNull("id") && !((PushNotificationData)object3).cta.isNull("rat")) {
                    if (((PushNotificationData)object3).cta.optJSONObject("ca") != null) {
                        CallToAction callToAction;
                        object2 = callToAction;
                        object = ((PushNotificationData)object3).cta;
                        callToAction = new CallToAction((JSONObject)object, object.optString("rat"), false, true);
                        arrayList2.add((CallToAction)object2);
                    } else {
                        PushNotificationData pushNotificationData = object3;
                        object2 = pushNotificationData.cta.optString("rat");
                        arrayList2.add(new CallToAction(((PushNotificationData)object3).cta.optString("id"), (String)object2, pushNotificationData.cta.optString("actionLink"), false, true));
                    }
                } else if (!((PushNotificationData)object3).cta.isNull("id") && !((PushNotificationData)object3).cta.isNull("actionText")) {
                    if (((PushNotificationData)object3).cta.optJSONObject("ca") != null) {
                        CallToAction callToAction;
                        object2 = callToAction;
                        object = ((PushNotificationData)object3).cta;
                        callToAction = new CallToAction((JSONObject)object, object.optString("actionText"), false, true);
                        arrayList2.add((CallToAction)object2);
                    } else {
                        PushNotificationData pushNotificationData = object3;
                        object2 = pushNotificationData.cta.optString("actionText");
                        arrayList2.add(new CallToAction(((PushNotificationData)object3).cta.optString("id"), (String)object2, pushNotificationData.cta.optString("actionLink"), false, true));
                    }
                }
            }
            object2 = jSONObject.isNull("cta2") ? null : jSONObject.optJSONObject("cta2");
            ((PushNotificationData)object3).cta = object2;
            if (object2 != null) {
                if (!object2.isNull("id") && !((PushNotificationData)object3).cta.isNull("rat")) {
                    if (((PushNotificationData)object3).cta.optJSONObject("ca") != null) {
                        CallToAction callToAction;
                        object2 = callToAction;
                        object = ((PushNotificationData)object3).cta;
                        callToAction = new CallToAction((JSONObject)object, object.optString("rat"), false, true);
                        arrayList2.add((CallToAction)object2);
                    } else {
                        PushNotificationData pushNotificationData = object3;
                        object2 = pushNotificationData.cta.optString("rat");
                        arrayList2.add(new CallToAction(((PushNotificationData)object3).cta.optString("id"), (String)object2, pushNotificationData.cta.optString("actionLink"), false, true));
                    }
                } else if (!((PushNotificationData)object3).cta.isNull("id") && !((PushNotificationData)object3).cta.isNull("actionText")) {
                    if (((PushNotificationData)object3).cta.optJSONObject("ca") != null) {
                        CallToAction callToAction;
                        object2 = callToAction;
                        object = ((PushNotificationData)object3).cta;
                        callToAction = new CallToAction((JSONObject)object, object.optString("actionText"), false, true);
                        arrayList2.add((CallToAction)object2);
                    } else {
                        PushNotificationData pushNotificationData = object3;
                        object2 = pushNotificationData.cta.optString("actionText");
                        arrayList2.add(new CallToAction(((PushNotificationData)object3).cta.optString("id"), (String)object2, pushNotificationData.cta.optString("actionLink"), false, true));
                    }
                }
            }
            object2 = jSONObject.isNull("cta3") ? null : jSONObject.optJSONObject("cta3");
            ((PushNotificationData)object3).cta = object2;
            if (object2 != null) {
                Object object3;
                if (!object2.isNull("id") && !((PushNotificationData)object3).cta.isNull("rat")) {
                    if (((PushNotificationData)object3).cta.optJSONObject("ca") != null) {
                        CallToAction callToAction;
                        object2 = callToAction;
                        object3 = ((PushNotificationData)object3).cta;
                        callToAction = new CallToAction((JSONObject)object3, object3.optString("rat"), false, true);
                        arrayList2.add((CallToAction)object2);
                    } else {
                        PushNotificationData pushNotificationData = object3;
                        object3 = pushNotificationData.cta.optString("rat");
                        arrayList2.add(new CallToAction(((PushNotificationData)object3).cta.optString("id"), (String)object3, pushNotificationData.cta.optString("actionLink"), false, true));
                    }
                } else if (!((PushNotificationData)object3).cta.isNull("id") && !((PushNotificationData)object3).cta.isNull("actionText")) {
                    if (((PushNotificationData)object3).cta.optJSONObject("ca") != null) {
                        CallToAction callToAction;
                        object2 = callToAction;
                        object3 = ((PushNotificationData)object3).cta;
                        callToAction = new CallToAction((JSONObject)object3, object3.optString("actionText"), false, true);
                        arrayList2.add((CallToAction)object2);
                    } else {
                        Object object4 = object3;
                        object3 = ((PushNotificationData)object4).cta.optString("actionText");
                        arrayList2.add(new CallToAction(((PushNotificationData)object3).cta.optString("id"), (String)object3, ((PushNotificationData)object4).cta.optString("actionLink"), false, true));
                    }
                }
            }
        }
        return arrayList2;
    }

    private Bitmap createBitmapFromDrawable(Drawable drawable) {
        if (drawable != null) {
            Canvas canvas;
            Canvas canvas2;
            PushNotificationData pushNotificationData = Bitmap.createBitmap((int)canvas2.getIntrinsicWidth(), (int)canvas2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            void v02 = canvas2;
            canvas2 = canvas;
            int n5 = new Canvas((Bitmap)pushNotificationData).getWidth();
            int n6 = canvas2.getHeight();
            v02.setBounds(0, 0, n5, n6);
            v02.draw(canvas2);
            return pushNotificationData;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void createLargeIconFromAsset(Context context) {
        void var1_1;
        int n5 = WebEngage.get().getWebEngageConfig().getPushLargeIcon();
        this.largeIcon = n5 == -1 ? BitmapFactory.decodeResource((Resources)var1_1.getApplicationContext().getResources(), (int)var1_1.getApplicationContext().getApplicationInfo().icon) : BitmapFactory.decodeResource((Resources)var1_1.getApplicationContext().getResources(), (int)n5);
        if (this.largeIcon == null) {
            Logger.d("WebEngage", "large icon is not available in the resources. Creating Bitmap from app icon");
            this.largeIcon = this.createBitmapFromDrawable(var1_1.getPackageManager().getApplicationIcon(var1_1.getApplicationInfo()));
        }
    }

    public List<CallToAction> getCallToActions() {
        return this.callToActions;
    }

    public CallToAction getPrimeCallToAction() {
        List<CallToAction> object2 = ((PushNotificationData)this).callToActions;
        if (object2 != null && object2.size() > 0) {
            for (CallToAction callToAction : ((PushNotificationData)this).callToActions) {
                if (callToAction == null || !callToAction.isPrimeAction()) continue;
                return callToAction;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public CallToAction getCallToActionById(String id) {
        void var1_1;
        List<CallToAction> object2 = ((PushNotificationData)this).callToActions;
        if (object2 != null && object2.size() > 0 && var1_1 != null && !var1_1.isEmpty()) {
            for (CallToAction callToAction : ((PushNotificationData)this).callToActions) {
                if (callToAction == null || !var1_1.equals(callToAction.getId())) continue;
                return callToAction;
            }
        }
        return null;
    }

    public List<CallToAction> getActions() {
        List<CallToAction> list = ((PushNotificationData)this_).callToActions;
        if (list != null && list.size() > 0) {
            PushNotificationData pushNotificationData = this_;
            Object this_ = null;
            for (CallToAction callToAction : pushNotificationData.callToActions) {
                if (callToAction == null || callToAction.isPrimeAction() || !callToAction.isNative()) continue;
                if (this_ == null) {
                    ArrayList arrayList;
                    this_ = arrayList;
                    arrayList = new ArrayList();
                }
                this_.add(callToAction);
            }
            return this_;
        }
        return null;
    }

    public boolean getAutoExpand() {
        return this.autoExpand;
    }

    /*
     * WARNING - void declaration
     */
    public void setAutoExpand(boolean autoExpand) {
        void var1_1;
        this.autoExpand = var1_1;
    }

    public boolean isBigNotification() {
        return this.bigNotificationData != null;
    }

    public Bitmap getLargeIcon() {
        return this.largeIcon;
    }

    public int getAccentColor() {
        return this.accentColor;
    }

    /*
     * WARNING - void declaration
     */
    public void setAccentColor(int accentColor) {
        void var1_1;
        this.accentColor = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSmallIcon(int resourceId) {
        void var1_1;
        this.smallIcon = var1_1;
    }

    public int getSmallIcon() {
        return this.smallIcon;
    }

    public String getAppName() {
        return this.appName;
    }

    /*
     * WARNING - void declaration
     */
    public void setLargerIcon(Bitmap largeIcon) {
        void var1_1;
        this.largeIcon = var1_1;
    }

    public WebEngageConstant.STYLE getStyle() {
        try {
            return WebEngageConstant.STYLE.valueOf(this.style);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BigTextStyle getBigTextStyleData() {
        return this.bigTextStyle;
    }

    public BigPictureStyle getBigPictureStyleData() {
        return this.bigPictureStyle;
    }

    public InboxStyle getInboxStyleData() {
        return this.inboxStyle;
    }

    public CarouselV1 getCarouselV1Data() {
        return this.carouselV1;
    }

    public RatingV1 getRatingV1() {
        return this.ratingV1;
    }

    public TimerStyle getTimerStyleData() {
        return this.timerStyle;
    }

    public OverlayStyle getOverlayStyle() {
        return this.overlayStyle;
    }

    public boolean isCustomRender() {
        return (this = this.getCustomData()) != null && this.containsKey("we_custom_render") && Boolean.parseBoolean(this.getString("we_custom_render"));
    }

    /*
     * WARNING - void declaration
     */
    public void setCurrentIndex(int currentIndex) {
        void var1_1;
        this.currentIndex = var1_1;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public boolean isSticky() {
        return this.isSticky;
    }

    /*
     * WARNING - void declaration
     */
    public void setSticky(boolean sticky) {
        void var1_1;
        this.isSticky = var1_1;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    /*
     * WARNING - void declaration
     */
    public void setBackgroundColor(int backgroundColor) {
        void var1_1;
        this.backgroundColor = var1_1;
    }

    public String getLargeIconUrl() {
        return this.largeIconUrl;
    }

    /*
     * WARNING - void declaration
     */
    public void setLargeIconUrl(String largeIconUrl) {
        void var1_1;
        this.largeIconUrl = var1_1;
    }

    public String getAutoDismissTime() {
        return this.autoDismissTime;
    }

    /*
     * WARNING - void declaration
     */
    public void setAutoDismissTime(String autoDismissTime) {
        void var1_1;
        this.autoDismissTime = var1_1;
    }

    public JSONObject getTestingDetails() {
        return this.testingDetails;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o5) {
        void var1_1;
        if (!(o5 instanceof PushNotificationData)) {
            return false;
        }
        PushNotificationData pushNotificationData = pushNotificationData2;
        PushNotificationData pushNotificationData2 = (PushNotificationData)var1_1;
        return pushNotificationData.getExperimentId().equals(pushNotificationData2.getExperimentId());
    }

    public int hashCode() {
        return this.getExperimentId().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        String string = System.getProperty("line.separator");
        new StringBuilder().append(this.getClass().getName() + " Object { " + string);
        stringBuilder2.append(" Experiment Id : " + this.getExperimentId() + string);
        stringBuilder2.append(" Variation Id : " + this.getVariationId() + string);
        stringBuilder2.append(" Title : " + this.getTitle() + string);
        stringBuilder2.append(" Message : " + this.getContentText() + string);
        StringBuilder stringBuilder3 = new StringBuilder().append("Summary : ");
        String string2 = this.getContentSummary() != null ? this.getContentSummary() : "null";
        stringBuilder2.append(stringBuilder3.append(string2).append(string).toString());
        if (this.getPrimeCallToAction() != null) {
            stringBuilder2.append(" Main CTA : " + this.getPrimeCallToAction() + " ID : " + this.getPrimeCallToAction().getId() + string);
        }
        stringBuilder3 = new StringBuilder().append(" Custom Data : ");
        string2 = this.getCustomData() != null ? this.getCustomData().toString() : "null";
        stringBuilder2.append(stringBuilder3.append(string2).append(string).toString());
        if (this.bigNotificationData != null) {
            stringBuilder2.append(" Expandable Details : " + this.bigNotificationData.toString() + string);
        }
        StringBuilder stringBuilder4 = stringBuilder2;
        stringBuilder4.append(" Amplified: " + this.isAmplified() + string);
        stringBuilder4.append("}");
        return stringBuilder4.toString();
    }

    public class OverlayStyle
    extends BaseStyleData {
        private String expandedImageUrl;
        private String collapsedImageUrl;
        private String subStyle;
        private Boolean appNameVisibility;
        final /* synthetic */ PushNotificationData this$0;

        /*
         * WARNING - void declaration
         */
        public OverlayStyle(PushNotificationData this$0, JSONObject jsonObject) {
            void var2_2;
            Object object;
            this.this$0 = object;
            super((PushNotificationData)object, (JSONObject)var2_2);
            this.expandedImageUrl = null;
            this.collapsedImageUrl = null;
            this.subStyle = null;
            this.appNameVisibility = Boolean.TRUE;
            object = jsonObject.isNull("image") ? null : var2_2.optString("image");
            this.expandedImageUrl = object;
            object = var2_2.isNull("cm_img") ? null : var2_2.optString("cm_img");
            this.collapsedImageUrl = object;
            object = var2_2.isNull("ss") ? null : var2_2.optString("ss");
            this.subStyle = object;
            object = var2_2.isNull("a_n_vis") ? null : Boolean.valueOf(var2_2.optBoolean("a_n_vis"));
            this.appNameVisibility = object;
        }

        public String getExpandedImageUrl() {
            return this.expandedImageUrl;
        }

        /*
         * WARNING - void declaration
         */
        public void setExpandedImageUrl(String expandedImageUrl) {
            void var1_1;
            this.expandedImageUrl = var1_1;
        }

        public String getCollapsedImageUrl() {
            return this.collapsedImageUrl;
        }

        /*
         * WARNING - void declaration
         */
        public void setCollapsedImageUrl(String collapsedImageUrl) {
            void var1_1;
            this.collapsedImageUrl = var1_1;
        }

        public String getSubStyle() {
            return this.subStyle;
        }

        /*
         * WARNING - void declaration
         */
        public void setSubStyle(String subStyle) {
            void var1_1;
            this.subStyle = var1_1;
        }

        public Boolean getAppNameVisibility() {
            return this.appNameVisibility;
        }

        /*
         * WARNING - void declaration
         */
        public void setAppNameVisibility(Boolean appNameVisibility) {
            void var1_1;
            this.appNameVisibility = var1_1;
        }
    }

    public class TimerStyle
    extends BaseStyleData {
        private String imageUrl;
        private String duration;
        private String futureTime;
        private String timeZone;
        private int timerColor;
        private int progressBarColor;
        private int progressBarBackgroundColor;
        final /* synthetic */ PushNotificationData this$0;

        /*
         * WARNING - void declaration
         */
        public TimerStyle(PushNotificationData this$0, JSONObject json, Context context) {
            block14: {
                void var3_6;
                void var2_5;
                block13: {
                    block12: {
                        String string;
                        this.this$0 = string;
                        super((PushNotificationData)((Object)string), (JSONObject)var2_5);
                        string = json.isNull("image") ? null : var2_5.optString("image");
                        this.imageUrl = string;
                        string = var2_5.isNull("dr") ? null : var2_5.optString("dr");
                        this.duration = string;
                        string = var2_5.isNull("ft") ? null : var2_5.optString("ft");
                        this.futureTime = string;
                        string = var2_5.isNull("tz") ? null : var2_5.optString("tz");
                        this.timeZone = string;
                        this.timerColor = ContextCompat.getColor((Context)var3_6, (int)R.color.we_black);
                        if (!var2_5.isNull("tc")) {
                            if (TextUtils.isEmpty((CharSequence)var2_5.getString("tc"))) break block12;
                            try {
                                this.timerColor = Color.parseColor((String)var2_5.getString("tc"));
                            }
                            catch (Exception exception) {
                                Logger.e("WebEngage", "Exception while parsing timerColor " + exception);
                            }
                        }
                    }
                    this.progressBarColor = ContextCompat.getColor((Context)var3_6, (int)R.color.we_progress);
                    if (!var2_5.isNull("pc")) {
                        if (TextUtils.isEmpty((CharSequence)var2_5.getString("pc"))) break block13;
                        try {
                            this.progressBarColor = Color.parseColor((String)var2_5.getString("pc"));
                        }
                        catch (Exception exception) {
                            this.progressBarColor = ContextCompat.getColor((Context)var3_6, (int)R.color.we_progress);
                            Logger.e("WebEngage", "Exception while parsing progressBarColor " + exception);
                        }
                    }
                }
                this.progressBarBackgroundColor = ContextCompat.getColor((Context)var3_6, (int)R.color.we_progress_tint);
                if (!var2_5.isNull("pbc")) {
                    if (TextUtils.isEmpty((CharSequence)var2_5.getString("pbc"))) break block14;
                    try {
                        this.progressBarBackgroundColor = Color.parseColor((String)var2_5.getString("pbc"));
                    }
                    catch (Exception exception) {
                        Logger.e("WebEngage", "Exception while parsing progressBarColor " + exception);
                    }
                }
            }
        }

        public String getImageUrl() {
            return this.imageUrl;
        }

        /*
         * WARNING - void declaration
         */
        public void setImageUrl(String imageUrl) {
            void var1_1;
            this.imageUrl = var1_1;
        }

        public String getDuration() {
            return this.duration;
        }

        /*
         * WARNING - void declaration
         */
        public void setDuration(String duration) {
            void var1_1;
            this.duration = var1_1;
        }

        public String getFutureTime() {
            return this.futureTime;
        }

        /*
         * WARNING - void declaration
         */
        public void setFutureTime(String futureTime) {
            void var1_1;
            this.futureTime = var1_1;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        /*
         * WARNING - void declaration
         */
        public void setTimeZone(String timeZone) {
            void var1_1;
            this.timeZone = var1_1;
        }

        public int getTimerColor() {
            return this.timerColor;
        }

        /*
         * WARNING - void declaration
         */
        public void setTimerColor(int timerColor) {
            void var1_1;
            this.timerColor = var1_1;
        }

        public int getProgressBarColor() {
            return this.progressBarColor;
        }

        /*
         * WARNING - void declaration
         */
        public void setProgressBarColor(int progressBarColor) {
            void var1_1;
            this.progressBarColor = var1_1;
        }

        public int getProgressBarBackgroundColor() {
            return this.progressBarBackgroundColor;
        }

        /*
         * WARNING - void declaration
         */
        public void setProgressBarBackgroundColor(int progressBarBackgroundColor) {
            void var1_1;
            this.progressBarBackgroundColor = var1_1;
        }
    }

    public class RatingV1
    extends BaseStyleData {
        private int contentBackgroundColor;
        private String imageUrl;
        private String contentTitle;
        private String contentMessage;
        private String iconUrl;
        private int rateScale;
        private int contentTextColor;
        private CallToAction submitCTA;
        private int rateValue;
        final /* synthetic */ PushNotificationData this$0;

        public RatingV1(PushNotificationData this$0, JSONObject jsonObject) {
            CallToAction callToAction;
            String string;
            ((RatingV1)object).this$0 = string;
            super((PushNotificationData)((Object)string), (JSONObject)callToAction);
            ((RatingV1)object).contentBackgroundColor = Color.parseColor((String)"#00000000");
            ((RatingV1)object).imageUrl = null;
            ((RatingV1)object).contentTitle = null;
            ((RatingV1)object).contentMessage = null;
            ((RatingV1)object).iconUrl = null;
            ((RatingV1)object).rateScale = 5;
            ((RatingV1)object).contentTextColor = Color.parseColor((String)"#000000");
            ((RatingV1)object).submitCTA = null;
            ((RatingV1)object).rateValue = -1;
            if (jsonObject != null) {
                Object object;
                String string2;
                string = callToAction.isNull("image") ? null : callToAction.optString("image");
                ((RatingV1)object).imageUrl = string;
                string = callToAction.isNull("icon") ? null : callToAction.optString("icon");
                ((RatingV1)object).iconUrl = string;
                ((RatingV1)object).rateScale = callToAction.optInt("rateScale", 5);
                string = callToAction.optJSONObject("content");
                if (string != null) {
                    string2 = string.isNull("title") ? null : string.optString("title");
                    ((RatingV1)object).contentTitle = string2;
                    string2 = string.isNull("message") ? null : string.optString("message");
                    ((RatingV1)object).contentMessage = string2;
                    if (!string.isNull("textColor")) {
                        ((RatingV1)object).contentTextColor = Color.parseColor((String)string.optString("textColor"));
                    }
                    if (!string.isNull("bckColor")) {
                        try {
                            ((RatingV1)object).contentBackgroundColor = Color.parseColor((String)string.optString("bckColor"));
                        }
                        catch (Exception exception) {
                            Logger.e("WebEngage", "Error parsing bckColor. Not setting background color");
                        }
                    }
                }
                if ((string = callToAction.optJSONObject("submitCTA")) != null) {
                    String string3 = string;
                    string2 = string3.optString("id");
                    String string4 = string3.isNull("actionText") ? "Submit" : string.optString("actionText");
                    Object object2 = object;
                    object = string.optString("actionLink");
                    ((RatingV1)object2).submitCTA = callToAction = new CallToAction(string2, string4, (String)object, false, false);
                } else {
                    CallToAction callToAction2;
                    RatingV1 ratingV1 = object;
                    object = callToAction2;
                    callToAction2 = new CallToAction(null, "Submit", null, false, false);
                    ratingV1.submitCTA = object;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public void setRateValue(int rateValue) {
            void var1_1;
            this.rateValue = var1_1;
        }

        public int getRateValue() {
            return this.rateValue;
        }

        public String getImageUrl() {
            return this.imageUrl;
        }

        public String getContentTitle() {
            return this.contentTitle;
        }

        public String getContentMessage() {
            return this.contentMessage;
        }

        public String getIconUrl() {
            return this.iconUrl;
        }

        public int getRateScale() {
            return this.rateScale;
        }

        public int getContentTextColor() {
            return this.contentTextColor;
        }

        public int getContentBackgroundColor() {
            return this.contentBackgroundColor;
        }

        public CallToAction getSubmitCTA() {
            return this.submitCTA;
        }
    }

    public class CarouselV1
    extends BaseStyleData {
        private List<CarouselV1CallToAction> callToActions;
        private final String MODE;
        private int size;
        private int autoScrollTime;
        final /* synthetic */ PushNotificationData this$0;

        /*
         * WARNING - void declaration
         */
        public CarouselV1(PushNotificationData this$0, JSONObject jsonObject) {
            JSONArray jSONArray;
            void var2_2;
            JSONArray jSONArray2;
            this.this$0 = jSONArray2;
            super((PushNotificationData)jSONArray2, (JSONObject)var2_2);
            this.callToActions = null;
            this.size = 0;
            this.autoScrollTime = -1;
            jSONArray2 = jSONArray;
            jSONArray = new ArrayList();
            this.callToActions = jSONArray2;
            jSONArray2 = jsonObject.optJSONArray("items");
            if (jSONArray2 != null) {
                this.size = jSONArray2.length();
                for (int i5 = 0; i5 < jSONArray2.length(); ++i5) {
                    Object object = jSONArray2.optJSONObject(i5);
                    if (object == null || object.isNull("id") || object.isNull("image")) continue;
                    JSONObject jSONObject = object;
                    object = jSONObject.optString("actionText");
                    this.callToActions.add(new CarouselV1CallToAction(jSONObject, (String)object, jSONObject.optString("image")));
                }
            }
            this.MODE = var2_2.optString("mode", "landscape");
            this.autoScrollTime = var2_2.optInt("ast", -1);
        }

        public List<CarouselV1CallToAction> getCallToActions() {
            return this.callToActions;
        }

        /*
         * WARNING - void declaration
         */
        public void setCallToActions(List<CarouselV1CallToAction> callToActions) {
            void var1_1;
            this.callToActions = var1_1;
        }

        public String getMODE() {
            return this.MODE;
        }

        protected int getSize() {
            return this.size;
        }

        public int getAutoScrollTime() {
            return this.autoScrollTime;
        }

        /*
         * WARNING - void declaration
         */
        public void setAutoScrollTime(int autoScrollTime) {
            void var1_1;
            this.autoScrollTime = var1_1;
        }
    }

    public class InboxStyle
    extends BaseStyleData {
        private List<String> lines;
        final /* synthetic */ PushNotificationData this$0;

        public InboxStyle(PushNotificationData this$0, JSONObject json) {
            LinkedList<String> linkedList;
            JSONArray jSONArray;
            this.this$0 = jSONArray;
            super((PushNotificationData)jSONArray, (JSONObject)linkedList);
            this.lines = null;
            jSONArray = json.isNull("lines") ? null : linkedList.optJSONArray("lines");
            if (jSONArray != null) {
                LinkedList<String> linkedList2;
                linkedList = linkedList2;
                linkedList2 = new LinkedList<String>();
                this.lines = linkedList;
                for (int i5 = 0; i5 < jSONArray.length(); ++i5) {
                    this.lines.add(jSONArray.optString(i5));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public void setLines(List<String> lines) {
            void var1_1;
            this.lines = var1_1;
        }

        public List<String> getInboxLines() {
            return this.lines;
        }
    }

    public class BigPictureStyle
    extends BaseStyleData {
        private String bigPictureUrl;
        final /* synthetic */ PushNotificationData this$0;

        /*
         * WARNING - void declaration
         */
        public BigPictureStyle(PushNotificationData this$0, JSONObject json) {
            void var2_2;
            String string;
            this.this$0 = string;
            super((PushNotificationData)((Object)string), (JSONObject)var2_2);
            this.bigPictureUrl = null;
            string = json.isNull("image") ? null : var2_2.optString("image");
            this.bigPictureUrl = string;
        }

        /*
         * WARNING - void declaration
         */
        public void setBigPictureUrl(String url) {
            void var1_1;
            this.bigPictureUrl = var1_1;
        }

        public String getBigPictureUrl() {
            return this.bigPictureUrl;
        }
    }

    public class BigTextStyle
    extends BaseStyleData {
        private String bigText;
        final /* synthetic */ PushNotificationData this$0;

        /*
         * WARNING - void declaration
         */
        public BigTextStyle(PushNotificationData this$0, JSONObject json) {
            void var2_2;
            String string;
            this.this$0 = string;
            super((PushNotificationData)((Object)string), (JSONObject)var2_2);
            this.bigText = null;
            string = json.isNull("rm") ? ((PushNotificationData)((Object)string)).getContentText() : var2_2.optString("rm");
            this.bigText = string;
        }

        /*
         * WARNING - void declaration
         */
        public void setBigText(String bigText) {
            void var1_1;
            this.bigText = var1_1;
        }

        public String getBigText() {
            return this.bigText;
        }
    }

    public class BaseStyleData {
        private String bigContentTitle = null;
        private String message = null;
        private String summary = null;
        final /* synthetic */ PushNotificationData this$0;

        /*
         * WARNING - void declaration
         */
        public BaseStyleData(PushNotificationData this$0, JSONObject json) {
            void var2_2;
            String string;
            this.this$0 = string;
            String string2 = json.isNull("rt") ? ((PushNotificationData)((Object)string)).getTitle() : var2_2.optString("rt");
            this.bigContentTitle = string2;
            string2 = var2_2.isNull("rm") ? ((PushNotificationData)((Object)string)).getContentText() : var2_2.optString("rm");
            this.message = string2;
            string = var2_2.isNull("rst") ? ((PushNotificationData)((Object)string)).getContentSummary() : var2_2.optString("rst");
            this.summary = string;
        }

        /*
         * WARNING - void declaration
         */
        public void setBigContentTitle(String bigContentTitle) {
            void var1_1;
            this.bigContentTitle = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setMessage(String message) {
            void var1_1;
            this.message = var1_1;
        }

        public String getBigContentTitle() {
            return this.bigContentTitle;
        }

        public String getMessage() {
            return this.message;
        }

        public String getSummary() {
            return this.summary;
        }

        /*
         * WARNING - void declaration
         */
        public void setSummary(String summary) {
            void var1_1;
            this.summary = var1_1;
        }
    }
}

