/*
 * Decompiled with CFR 0.152.
 */
package com.webfuzzing.commons.report;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"endpoint_id", "test_case_id", "http_status"})
public class CoveredEndpoint {
    @JsonProperty(value="endpoint_id")
    @JsonPropertyDescription(value="A unique identifier for an operation. For example, in REST, it would be a HTTP endpoint, including verb, e.g., 'GET:/users/{id}'.")
    private String endpointId;
    @JsonProperty(value="test_case_id")
    @JsonPropertyDescription(value="A unique identifier for a test case. It could include its name and file location.")
    private String testCaseId;
    @JsonProperty(value="http_status")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="As in a test case the same endpoint could be called more than once, here we report all of the obtained HTTP status codes")
    private Set<Integer> httpStatus = new LinkedHashSet<Integer>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="endpoint_id")
    public String getEndpointId() {
        return this.endpointId;
    }

    @JsonProperty(value="endpoint_id")
    public void setEndpointId(String endpointId) {
        this.endpointId = endpointId;
    }

    @JsonProperty(value="test_case_id")
    public String getTestCaseId() {
        return this.testCaseId;
    }

    @JsonProperty(value="test_case_id")
    public void setTestCaseId(String testCaseId) {
        this.testCaseId = testCaseId;
    }

    @JsonProperty(value="http_status")
    public Set<Integer> getHttpStatus() {
        return this.httpStatus;
    }

    @JsonProperty(value="http_status")
    public void setHttpStatus(Set<Integer> httpStatus) {
        this.httpStatus = httpStatus;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CoveredEndpoint.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("endpointId");
        sb.append('=');
        sb.append(this.endpointId == null ? "<null>" : this.endpointId);
        sb.append(',');
        sb.append("testCaseId");
        sb.append('=');
        sb.append(this.testCaseId == null ? "<null>" : this.testCaseId);
        sb.append(',');
        sb.append("httpStatus");
        sb.append('=');
        sb.append(this.httpStatus == null ? "<null>" : this.httpStatus);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.endpointId == null ? 0 : this.endpointId.hashCode());
        result = result * 31 + (this.testCaseId == null ? 0 : this.testCaseId.hashCode());
        result = result * 31 + (this.httpStatus == null ? 0 : this.httpStatus.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CoveredEndpoint)) {
            return false;
        }
        CoveredEndpoint rhs = (CoveredEndpoint)other;
        return (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.endpointId == rhs.endpointId || this.endpointId != null && this.endpointId.equals(rhs.endpointId)) && (this.testCaseId == rhs.testCaseId || this.testCaseId != null && this.testCaseId.equals(rhs.testCaseId)) && (this.httpStatus == rhs.httpStatus || this.httpStatus != null && this.httpStatus.equals(rhs.httpStatus));
    }
}

