/*
 * Decompiled with CFR 0.152.
 */
package com.webfuzzing.commons.report;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.webfuzzing.commons.report.CoveredEndpoint;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"total_http_calls", "endpoint_ids", "covered_http_status"})
public class RESTReport {
    @JsonProperty(value="total_http_calls")
    @JsonPropertyDescription(value="Total number of HTTP calls made in all the test cases. A test case could contain several HTTP calls, e.g., a POST followed by a GET and then a DELETE.")
    private Integer totalHttpCalls;
    @JsonProperty(value="endpoint_ids")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="Unique ids of all the endpoints in the tested API.")
    private Set<String> endpointIds = new LinkedHashSet<String>();
    @JsonProperty(value="covered_http_status")
    @JsonPropertyDescription(value="List of which HTTP status codes were covered, based on endpoints.")
    private List<CoveredEndpoint> coveredHttpStatus = new ArrayList<CoveredEndpoint>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="total_http_calls")
    public Integer getTotalHttpCalls() {
        return this.totalHttpCalls;
    }

    @JsonProperty(value="total_http_calls")
    public void setTotalHttpCalls(Integer totalHttpCalls) {
        this.totalHttpCalls = totalHttpCalls;
    }

    @JsonProperty(value="endpoint_ids")
    public Set<String> getEndpointIds() {
        return this.endpointIds;
    }

    @JsonProperty(value="endpoint_ids")
    public void setEndpointIds(Set<String> endpointIds) {
        this.endpointIds = endpointIds;
    }

    @JsonProperty(value="covered_http_status")
    public List<CoveredEndpoint> getCoveredHttpStatus() {
        return this.coveredHttpStatus;
    }

    @JsonProperty(value="covered_http_status")
    public void setCoveredHttpStatus(List<CoveredEndpoint> coveredHttpStatus) {
        this.coveredHttpStatus = coveredHttpStatus;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(RESTReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("totalHttpCalls");
        sb.append('=');
        sb.append(this.totalHttpCalls == null ? "<null>" : this.totalHttpCalls);
        sb.append(',');
        sb.append("endpointIds");
        sb.append('=');
        sb.append(this.endpointIds == null ? "<null>" : this.endpointIds);
        sb.append(',');
        sb.append("coveredHttpStatus");
        sb.append('=');
        sb.append(this.coveredHttpStatus == null ? "<null>" : this.coveredHttpStatus);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.totalHttpCalls == null ? 0 : this.totalHttpCalls.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.endpointIds == null ? 0 : this.endpointIds.hashCode());
        result = result * 31 + (this.coveredHttpStatus == null ? 0 : this.coveredHttpStatus.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RESTReport)) {
            return false;
        }
        RESTReport rhs = (RESTReport)other;
        return (this.totalHttpCalls == rhs.totalHttpCalls || this.totalHttpCalls != null && this.totalHttpCalls.equals(rhs.totalHttpCalls)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.endpointIds == rhs.endpointIds || this.endpointIds != null && this.endpointIds.equals(rhs.endpointIds)) && (this.coveredHttpStatus == rhs.coveredHttpStatus || this.coveredHttpStatus != null && this.coveredHttpStatus.equals(rhs.coveredHttpStatus));
    }
}

