/*
 * Decompiled with CFR 0.152.
 */
package com.webfuzzing.commons.report;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.webfuzzing.commons.report.Coverage;
import com.webfuzzing.commons.report.Faults;
import com.webfuzzing.commons.report.ProblemDetails;
import com.webfuzzing.commons.report.TestCase;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"schema_version", "tool_name", "tool_version", "creation_time", "faults", "problem_details", "total_tests", "test_file_paths", "test_cases", "extra"})
public class Report {
    @JsonProperty(value="schema_version")
    @JsonPropertyDescription(value="The schema version of WFC needed to use to validate and process this document.")
    private String schemaVersion;
    @JsonProperty(value="tool_name")
    @JsonPropertyDescription(value="The name of the tool used to create the test cases reported in this document.")
    private String toolName;
    @JsonProperty(value="tool_version")
    @JsonPropertyDescription(value="The version number of the used tool, e.g., 1.0.0.")
    private String toolVersion;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone="UTC")
    @JsonProperty(value="creation_time")
    @JsonPropertyDescription(value="The timestamp of when this report file was created.")
    private Date creationTime;
    @JsonProperty(value="faults")
    private Faults faults;
    @JsonProperty(value="problem_details")
    private ProblemDetails problemDetails;
    @JsonProperty(value="total_tests")
    @JsonPropertyDescription(value="The total number of test cases generated by the tool.")
    private Integer totalTests;
    @JsonProperty(value="test_file_paths")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="The list of relative paths (compared to this document) of all the generated test suite files.")
    private Set<String> testFilePaths = new LinkedHashSet<String>();
    @JsonProperty(value="test_cases")
    @JsonPropertyDescription(value="Information on each generated test case.")
    private List<TestCase> testCases = new ArrayList<TestCase>();
    @JsonProperty(value="extra")
    @JsonPropertyDescription(value="Extra, optional coverage information, collected by different tools.")
    private List<Coverage> extra = new ArrayList<Coverage>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="schema_version")
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="schema_version")
    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    @JsonProperty(value="tool_name")
    public String getToolName() {
        return this.toolName;
    }

    @JsonProperty(value="tool_name")
    public void setToolName(String toolName) {
        this.toolName = toolName;
    }

    @JsonProperty(value="tool_version")
    public String getToolVersion() {
        return this.toolVersion;
    }

    @JsonProperty(value="tool_version")
    public void setToolVersion(String toolVersion) {
        this.toolVersion = toolVersion;
    }

    @JsonProperty(value="creation_time")
    public Date getCreationTime() {
        return this.creationTime;
    }

    @JsonProperty(value="creation_time")
    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    @JsonProperty(value="faults")
    public Faults getFaults() {
        return this.faults;
    }

    @JsonProperty(value="faults")
    public void setFaults(Faults faults) {
        this.faults = faults;
    }

    @JsonProperty(value="problem_details")
    public ProblemDetails getProblemDetails() {
        return this.problemDetails;
    }

    @JsonProperty(value="problem_details")
    public void setProblemDetails(ProblemDetails problemDetails) {
        this.problemDetails = problemDetails;
    }

    @JsonProperty(value="total_tests")
    public Integer getTotalTests() {
        return this.totalTests;
    }

    @JsonProperty(value="total_tests")
    public void setTotalTests(Integer totalTests) {
        this.totalTests = totalTests;
    }

    @JsonProperty(value="test_file_paths")
    public Set<String> getTestFilePaths() {
        return this.testFilePaths;
    }

    @JsonProperty(value="test_file_paths")
    public void setTestFilePaths(Set<String> testFilePaths) {
        this.testFilePaths = testFilePaths;
    }

    @JsonProperty(value="test_cases")
    public List<TestCase> getTestCases() {
        return this.testCases;
    }

    @JsonProperty(value="test_cases")
    public void setTestCases(List<TestCase> testCases) {
        this.testCases = testCases;
    }

    @JsonProperty(value="extra")
    public List<Coverage> getExtra() {
        return this.extra;
    }

    @JsonProperty(value="extra")
    public void setExtra(List<Coverage> extra) {
        this.extra = extra;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Report.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("schemaVersion");
        sb.append('=');
        sb.append(this.schemaVersion == null ? "<null>" : this.schemaVersion);
        sb.append(',');
        sb.append("toolName");
        sb.append('=');
        sb.append(this.toolName == null ? "<null>" : this.toolName);
        sb.append(',');
        sb.append("toolVersion");
        sb.append('=');
        sb.append(this.toolVersion == null ? "<null>" : this.toolVersion);
        sb.append(',');
        sb.append("creationTime");
        sb.append('=');
        sb.append(this.creationTime == null ? "<null>" : this.creationTime);
        sb.append(',');
        sb.append("faults");
        sb.append('=');
        sb.append(this.faults == null ? "<null>" : this.faults);
        sb.append(',');
        sb.append("problemDetails");
        sb.append('=');
        sb.append(this.problemDetails == null ? "<null>" : this.problemDetails);
        sb.append(',');
        sb.append("totalTests");
        sb.append('=');
        sb.append(this.totalTests == null ? "<null>" : this.totalTests);
        sb.append(',');
        sb.append("testFilePaths");
        sb.append('=');
        sb.append(this.testFilePaths == null ? "<null>" : this.testFilePaths);
        sb.append(',');
        sb.append("testCases");
        sb.append('=');
        sb.append(this.testCases == null ? "<null>" : this.testCases);
        sb.append(',');
        sb.append("extra");
        sb.append('=');
        sb.append(this.extra == null ? "<null>" : this.extra);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.toolVersion == null ? 0 : this.toolVersion.hashCode());
        result = result * 31 + (this.problemDetails == null ? 0 : this.problemDetails.hashCode());
        result = result * 31 + (this.schemaVersion == null ? 0 : this.schemaVersion.hashCode());
        result = result * 31 + (this.creationTime == null ? 0 : this.creationTime.hashCode());
        result = result * 31 + (this.testCases == null ? 0 : this.testCases.hashCode());
        result = result * 31 + (this.extra == null ? 0 : this.extra.hashCode());
        result = result * 31 + (this.testFilePaths == null ? 0 : this.testFilePaths.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.faults == null ? 0 : this.faults.hashCode());
        result = result * 31 + (this.toolName == null ? 0 : this.toolName.hashCode());
        result = result * 31 + (this.totalTests == null ? 0 : this.totalTests.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Report)) {
            return false;
        }
        Report rhs = (Report)other;
        return (this.toolVersion == rhs.toolVersion || this.toolVersion != null && this.toolVersion.equals(rhs.toolVersion)) && (this.problemDetails == rhs.problemDetails || this.problemDetails != null && this.problemDetails.equals(rhs.problemDetails)) && (this.schemaVersion == rhs.schemaVersion || this.schemaVersion != null && this.schemaVersion.equals(rhs.schemaVersion)) && (this.creationTime == rhs.creationTime || this.creationTime != null && this.creationTime.equals(rhs.creationTime)) && (this.testCases == rhs.testCases || this.testCases != null && this.testCases.equals(rhs.testCases)) && (this.extra == rhs.extra || this.extra != null && this.extra.equals(rhs.extra)) && (this.testFilePaths == rhs.testFilePaths || this.testFilePaths != null && this.testFilePaths.equals(rhs.testFilePaths)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.faults == rhs.faults || this.faults != null && this.faults.equals(rhs.faults)) && (this.toolName == rhs.toolName || this.toolName != null && this.toolName.equals(rhs.toolName)) && (this.totalTests == rhs.totalTests || this.totalTests != null && this.totalTests.equals(rhs.totalTests));
    }
}

